Ext.data.JsonP.first_app({"title":"Building your First App","guide":"<h1>Building your First App</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/first_app-section-1'>Preparation</a></li>\n<li><a href='#!/guide/first_app-section-2'>What we're going to build</a></li>\n<li><a href='#!/guide/first_app-section-3'>Getting Started</a></li>\n<li><a href='#!/guide/first_app-section-4'>Adding The Blogs Page</a></li>\n<li><a href='#!/guide/first_app-section-5'>Creating a Contact Form</a></li>\n<li><a href='#!/guide/first_app-section-6'>Pulling it all together</a></li>\n</ol>\n</div>\n\n<h2 id='first_app-section-1'>Preparation</h2>\n\n<p>This guide builds on the <a href=\"#!/guide/getting_started\">Getting Started Guide</a>, which quickly gets you set up with the SDK and ensures your environment is fully functional. If you haven't been through this yet we suggest reading that guide first (it only takes a few minutes), then come back here to create your first app.</p>\n\n<h2 id='first_app-section-2'>What we're going to build</h2>\n\n<p>Today we're going to build a simple mobile website-like app that could be used for your company's mobile site. We'll add a home page, a contact form and a simple list to fetch our recent blog posts and allow our visitor to read them right there on the phone.</p>\n\n<p>This is what we're going to build (it's interactive, try it yourself):</p>\n\n<pre class='inline-example raw portrait preview'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        //The whole app UI lives in this tab panel\n        <a href=\"#!/api/Ext.Viewport-method-add\" rel=\"Ext.Viewport-method-add\" class=\"docClass\">Ext.Viewport.add</a>({\n            xtype: 'tabpanel',\n            fullscreen: true,\n            tabBarPosition: 'bottom',\n\n            items: [\n                // This is the home page, just some simple html\n                {\n                    title: 'Home',\n                    iconCls: 'home',\n                    cls: 'home',\n                    html: [\n                        '&lt;img height=260 src=\"http://staging.sencha.com/img/sencha.png\" /&gt;',\n                        '&lt;h1&gt;Welcome to Sencha Touch&lt;/h1&gt;',\n                        \"&lt;p&gt;Building the Getting Started app&lt;/p&gt;\",\n                        '&lt;h2&gt;Sencha Touch (2.0.0)&lt;/h2&gt;'\n                    ].join(\"\")\n                },\n\n                // This is the recent blogs page. It uses a tree store to load its data from blog.json\n                {\n                    xtype: 'nestedlist',\n                    title: 'Blog',\n                    iconCls: 'star',\n                    cls: 'blog',\n                    displayField: 'title',\n\n                    store: {\n                        type: 'tree',\n\n                        fields: ['title', 'link', 'author', 'contentSnippet', 'content', {\n                            name: 'leaf',\n                            defaultValue: true\n                        }],\n\n                        root: {\n                            leaf: false\n                        },\n\n                        proxy: {\n                            type: 'jsonp',\n                            url: 'https://ajax.googleapis.com/ajax/services/feed/load?v=1.0&amp;q=http://feeds.feedburner.com/SenchaBlog',\n                            reader: {\n                                type: 'json',\n                                rootProperty: 'responseData.feed.entries'\n                            }\n                        }\n                    },\n\n                    detailCard: {\n                        xtype: 'panel',\n                        scrollable: true,\n                        styleHtmlContent: true\n                    },\n\n                    listeners: {\n                        itemtap: function(nestedList, list, index, element, post) {\n                            this.getDetailCard().setHtml(post.get('content'));\n                        }\n                    }\n                },\n\n                // This is the contact page, which features a form and a button. The button submits the form\n                {\n                    xtype: 'formpanel',\n                    title: 'Contact Us',\n                    iconCls: 'user',\n                    url: 'contact.php',\n                    layout: 'vbox',\n\n                    items: [\n                        {\n                            xtype: 'fieldset',\n                            title: 'Contact Us',\n                            instructions: 'Email address is optional',\n\n                            items: [\n                                {\n                                    xtype: 'textfield',\n                                    label: 'Name',\n                                    name: 'name'\n                                },\n                                {\n                                    xtype: 'emailfield',\n                                    label: 'Email',\n                                    name: 'email'\n                                },\n                                {\n                                    xtype: 'textareafield',\n                                    label: 'Message',\n                                    name: 'message',\n                                    height: 90\n                                }\n                            ]\n                        },\n                        {\n                            xtype: 'button',\n                            text: 'Send',\n                            ui: 'confirm',\n\n                            // The handler is called when the button is tapped\n                            handler: function() {\n\n                                // This looks up the items stack above, getting a reference to the first form it see\n                                var form = this.up('formpanel');\n\n                                // Sends an AJAX request with the form data to the url specified above (contact.php).\n                                // The success callback is called if we get a non-error response from the server\n                                form.submit({\n                                    success: function() {\n                                        // The callback function is run when the user taps the 'ok' button\n                                        <a href=\"#!/api/Ext.Msg-method-alert\" rel=\"Ext.Msg-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Thank You', 'Your message has been received', function() {\n                                            form.reset();\n                                        });\n                                    }\n                                });\n                            }\n                        }\n                    ]\n                }\n            ]\n        });\n    }\n});\n</code></pre>\n\n<h2 id='first_app-section-3'>Getting Started</h2>\n\n<p>The first thing we need to do is set up our application, just like we did in the <a href=\"#!/guide/getting_started\">Getting Started Guide</a>. The app is using a <a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">tab panel</a> that will hold the 4 pages so we'll start with that:</p>\n\n<pre class='inline-example raw miniphone'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>(\"<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>\", {\n            fullscreen: true,\n            items: [\n                {\n                    title: 'Home',\n                    iconCls: 'home',\n                    html: 'Welcome'\n                }\n            ]\n        });\n    }\n});\n</code></pre>\n\n<p>If you run this in the browser (click the Preview button), a <a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">TabPanel</a> should appear on top of the screen. The home page could be a bit more welcoming, so let's add some content to it and reposition the tab bar at the bottom of the page. We do that with the <a href=\"#!/api/Ext.tab.Panel-cfg-tabBarPosition\" rel=\"Ext.tab.Panel-cfg-tabBarPosition\" class=\"docClass\">tabBarPosition</a> config and by adding a bit of HTML:</p>\n\n<pre class='inline-example raw portrait'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>(\"<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>\", {\n            fullscreen: true,\n            tabBarPosition: 'bottom',\n\n            items: [\n                {\n                    title: 'Home',\n                    iconCls: 'home',\n                    html: [\n                        '&lt;img src=\"http://staging.sencha.com/img/sencha.png\" /&gt;',\n                        '&lt;h1&gt;Welcome to Sencha Touch&lt;/h1&gt;',\n                        \"&lt;p&gt;You're creating the Getting Started app. This demonstrates how \",\n                        \"to use tabs, lists and forms to create a simple app&lt;/p&gt;\",\n                        '&lt;h2&gt;Sencha Touch (2.0.0)&lt;/h2&gt;'\n                    ].join(\"\")\n                }\n            ]\n        });\n    }\n});\n</code></pre>\n\n<p>Click the Preview button next to the example to have a look: you should see some HTML content but it won't look very good. We'll add a <a href=\"#!/api/Ext.Component-cfg-cls\" rel=\"Ext.Component-cfg-cls\" class=\"docClass\">cls</a> config and add it to the panel, adding a CSS class that we can target to make things look better. All of the CSS we're adding is in the examples/getting_started/index.html file in the SDK download. Here's how our home page looks now:</p>\n\n<pre class='inline-example raw preview portrait'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>(\"<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>\", {\n            fullscreen: true,\n            tabBarPosition: 'bottom',\n\n            items: [\n                {\n                    title: 'Home',\n                    iconCls: 'home',\n                    cls: 'home',\n\n                    html: [\n                        '&lt;img src=\"http://staging.sencha.com/img/sencha.png\" /&gt;',\n                        '&lt;h1&gt;Welcome to Sencha Touch&lt;/h1&gt;',\n                        \"&lt;p&gt;You're creating the Getting Started app. This demonstrates how \",\n                        \"to use tabs, lists and forms to create a simple app&lt;/p&gt;\",\n                        '&lt;h2&gt;Sencha Touch (2.0.0pr1)&lt;/h2&gt;'\n                    ].join(\"\")\n                }\n            ]\n        });\n    }\n});\n</code></pre>\n\n<h2 id='first_app-section-4'>Adding The Blogs Page</h2>\n\n<p>Now that we have a decent looking home page, it's time to move on to the next screen. In order to keep the code for each page easy to follow we're just going to create one tab at a time and then combine them all together again at the end.</p>\n\n<p>For now, we'll remove the first tab and replace it with a List.</p>\n\n<p>let's expand it to show a list of our latest blog posts on a separate tab. To get started we'll just fake the data - in this case a few recent posts from <a href=\"sencha.com/blog\">http://sencha.com/blog</a>. There's a bit more code involved this time so first let's take a look at the result, then we can see how it's accomplished:</p>\n\n<pre class='inline-example raw portrait preview'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>(\"<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>\", {\n            fullscreen: true,\n            tabBarPosition: 'bottom',\n\n            items: [\n                {\n                    xtype: 'nestedlist',\n                    title: 'Blog',\n                    iconCls: 'star',\n                    displayField: 'title',\n\n                    store: {\n                        type: 'tree',\n\n                        fields: [\n                            'title', 'link', 'author', 'contentSnippet', 'content',\n                            {name: 'leaf', defaultValue: true}\n                        ],\n\n                        root: {\n                            leaf: false\n                        },\n\n                        proxy: {\n                            type: 'jsonp',\n                            url: 'https://ajax.googleapis.com/ajax/services/feed/load?v=1.0&amp;q=http://feeds.feedburner.com/SenchaBlog',\n                            reader: {\n                                type: 'json',\n                                rootProperty: 'responseData.feed.entries'\n                            }\n                        }\n                    },\n\n                    detailCard: {\n                        xtype: 'panel',\n                        scrollable: true,\n                        styleHtmlContent: true\n                    },\n\n                    listeners: {\n                        itemtap: function(nestedList, list, index, element, post) {\n                            this.getDetailCard().setHtml(post.get('content'));\n                        }\n                    }\n                }\n            ]\n        });\n    }\n});\n</code></pre>\n\n<p>You can click the 'Code Editor' button above the example to see the full code, but we'll go over it piece by piece. Instead of a panel we're using a <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">nestedlist</a> this time, fetching the most recent blog posts from sencha.com/blog. We're using Nested List so that we can drill down into the blog entry itself by simply tapping on the list.</p>\n\n<p>Let's break down the code above, starting with just the list itself:</p>\n\n<pre class='inline-example raw portrait'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>(\"<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>\", {\n            fullscreen: true,\n            tabBarPosition: 'bottom',\n\n            items: [\n                {\n                    xtype: 'nestedlist',\n                    title: 'Blog',\n                    iconCls: 'star',\n                    displayField: 'title',\n\n                    store: {\n                        type: 'tree',\n\n                        fields: [\n                            'title', 'link', 'author', 'contentSnippet', 'content',\n                            {name: 'leaf', defaultValue: true}\n                        ],\n\n                        root: {\n                            leaf: false\n                        },\n\n                        proxy: {\n                            type: 'jsonp',\n                            url: 'https://ajax.googleapis.com/ajax/services/feed/load?v=1.0&amp;q=http://feeds.feedburner.com/SenchaBlog',\n                            reader: {\n                                type: 'json',\n                                rootProperty: 'responseData.feed.entries'\n                            }\n                        }\n                    }\n                }\n            ]\n        });\n    }\n});\n</code></pre>\n\n<p>We're giving the Nested List a few simple configurations - title, iconCls and displayField - and a more detailed one called <a href=\"#!/api/Ext.dataview.NestedList-cfg-store\" rel=\"Ext.dataview.NestedList-cfg-store\" class=\"docClass\">store</a>. The Store config tells the nested list how to fetch its data. Let's go over each store config in turn:</p>\n\n<ul>\n<li><em>type: tree</em> creates a <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">tree store</a>, which NestedList uses</li>\n<li><em>fields</em> tells the Store what fields we're expecting in the blog data (title, content, author etc)</li>\n<li><em>proxy</em> tells the Store where to fetch its data from. We'll examine this more closely in a moment</li>\n<li><em>root</em> tells the root node it is not a leaf. Above we'd set the leaf defaultValue to true so we need to override that for the root</li>\n</ul>\n\n\n<p>Of all the Store configurations, proxy is doing the most work. We're telling the proxy to use Google's <a href=\"https://developers.google.com/feed/v1/reference\">Feed API service</a> to return our blog data in JSON-P format. This allows us to easily grab feed data from any blog and view it in our app (for example try swapping the Sencha blog url for http://rss.slashdot.org/Slashdot/slashdot above to see it fetch Slashdot's feed).</p>\n\n<p>The last part of the proxy definition was a Reader. The reader is what decodes the response from Google into useful data. When Google sends us back the blog data, they nest it inside a JSON object that looks a bit like this:</p>\n\n<pre><code>{\n    responseData: {\n        feed: {\n            entries: [\n                {author: 'Bob', title: 'Great Post', content: 'Really good content...'}\n            ]\n        }\n    }\n}\n</code></pre>\n\n<p>The bit we care about is the entries array, so we just set our Reader's <a href=\"#!/api/Ext.data.reader.Json-cfg-rootProperty\" rel=\"Ext.data.reader.Json-cfg-rootProperty\" class=\"docClass\">rootProperty</a> to 'responseData.feed.entries' and let the framework do the rest.</p>\n\n<h3>Digging In</h3>\n\n<p>Now that we have our nested list fetching and showing data, the last thing we need to do is to allow the user to tap on an entry to read it. We're just going to add two more configurations to our Nested List to finish this off:</p>\n\n<pre><code>{\n    xtype: 'nestedlist',\n    //all other configurations as above\n\n    detailCard: {\n        xtype: 'panel',\n        scrollable: true,\n        styleHtmlContent: true\n    },\n\n    listeners: {\n        itemtap: function(nestedList, list, index, element, post) {\n            this.getDetailCard().setHtml(post.get('content'));\n        }\n    }\n}\n</code></pre>\n\n<p>Here we've just set up a <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a>, which is a useful feature of Nested List that allows you to show a different view when a user taps on an item. We've configured our detailCard to be a scrollable <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Panel</a> that uses <a href=\"#!/api/Ext.Panel-cfg-styleHtmlContent\" rel=\"Ext.Panel-cfg-styleHtmlContent\" class=\"docClass\">styleHtmlContent</a> to make the text look good.</p>\n\n<p>The final piece of the puzzle is adding an <a href=\"#!/api/Ext.dataview.NestedList-event-itemtap\" rel=\"Ext.dataview.NestedList-event-itemtap\" class=\"docClass\">itemtap</a> listener, which just calls our function whenever an item is tapped on. All our function does is set the detailCard's HTML to the content of the post you just tapped on and the framework takes care of the rest, animating the detail card into view to make the post appear. This was the only line of code we had to write to make the blog reader work.</p>\n\n<h2 id='first_app-section-5'>Creating a Contact Form</h2>\n\n<p>The final thing we're going to do for our app is create a contact form. We're just going to take the user's name, email address and a message, and use a <a href=\"#!/api/Ext.form.FieldSet\" rel=\"Ext.form.FieldSet\" class=\"docClass\">FieldSet</a> to make it look good. The code for this one is simple:</p>\n\n<pre class='inline-example raw portrait'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>(\"<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>\", {\n            fullscreen: true,\n            tabBarPosition: 'bottom',\n\n            items: [\n                {\n                    title: 'Contact',\n                    iconCls: 'user',\n                    xtype: 'formpanel',\n                    url: 'contact.php',\n                    layout: 'vbox',\n\n                    items: [\n                        {\n                            xtype: 'fieldset',\n                            title: 'Contact Us',\n                            instructions: '(email address is optional)',\n                            items: [\n                                {\n                                    xtype: 'textfield',\n                                    label: 'Name'\n                                },\n                                {\n                                    xtype: 'emailfield',\n                                    label: 'Email'\n                                },\n                                {\n                                    xtype: 'textareafield',\n                                    label: 'Message'\n                                }\n                            ]\n                        },\n                        {\n                            xtype: 'button',\n                            text: 'Send',\n                            ui: 'confirm',\n                            handler: function() {\n                                this.up('formpanel').submit();\n                            }\n                        }\n                    ]\n                }\n            ]\n        });\n    }\n});\n</code></pre>\n\n<p>This time we're just creating a <a href=\"#!/api/Ext.form.Panel\" rel=\"Ext.form.Panel\" class=\"docClass\">form</a> that contains a <a href=\"#!/api/Ext.form.FieldSet\" rel=\"Ext.form.FieldSet\" class=\"docClass\">fieldset</a>. The fieldset contains three fields - one for name, one for email and one for a message. We've using a <a href=\"#!/api/Ext.layout.VBox\" rel=\"Ext.layout.VBox\" class=\"docClass\">VBox layout</a>, which just arranges the items vertically on the page one above the other.</p>\n\n<p>At the bottom we have a <a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">Button</a> with a tap <a href=\"#!/api/Ext.Button-cfg-handler\" rel=\"Ext.Button-cfg-handler\" class=\"docClass\">handler</a>. This employs the useful <a href=\"#!/api/Ext.Container-method-up\" rel=\"Ext.Container-method-up\" class=\"docClass\">up</a> method, which returns the form panel that the button is inside of. We then just call <a href=\"#!/api/Ext.form.Panel-method-submit\" rel=\"Ext.form.Panel-method-submit\" class=\"docClass\">submit</a> to submit the form, which sends it to the url we specified above ('contact.php').</p>\n\n<h2 id='first_app-section-6'>Pulling it all together</h2>\n\n<p>Now that we've created each view individually it's time to bring them all together into our completed app.</p>\n\n<pre class='inline-example raw preview portrait'><code>//We've added a third and final item to our tab panel - scroll down to see it\n<a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>(\"<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>\", {\n            fullscreen: true,\n            tabBarPosition: 'bottom',\n\n            items: [\n                {\n                    title: 'Home',\n                    iconCls: 'home',\n                    cls: 'home',\n                    html: [\n                        '&lt;img width=\"65%\" src=\"http://staging.sencha.com/img/sencha.png\" /&gt;',\n                        '&lt;h1&gt;Welcome to Sencha Touch&lt;/h1&gt;',\n                        \"&lt;p&gt;You're creating the Getting Started app. This demonstrates how \",\n                        \"to use tabs, lists and forms to create a simple app&lt;/p&gt;\",\n                        '&lt;h2&gt;Sencha Touch (2.0.0pr1)&lt;/h2&gt;'\n                    ].join(\"\")\n                },\n                {\n                    xtype: 'nestedlist',\n                    title: 'Blog',\n                    iconCls: 'star',\n                    displayField: 'title',\n\n                    store: {\n                        type: 'tree',\n\n                        fields: [\n                            'title', 'link', 'author', 'contentSnippet', 'content',\n                            {name: 'leaf', defaultValue: true}\n                        ],\n\n                        root: {\n                            leaf: false\n                        },\n\n                        proxy: {\n                            type: 'jsonp',\n                            url: 'https://ajax.googleapis.com/ajax/services/feed/load?v=1.0&amp;q=http://feeds.feedburner.com/SenchaBlog',\n                            reader: {\n                                type: 'json',\n                                rootProperty: 'responseData.feed.entries'\n                            }\n                        }\n                    },\n\n                    detailCard: {\n                        xtype: 'panel',\n                        scrollable: true,\n                        styleHtmlContent: true\n                    },\n\n                    listeners: {\n                        itemtap: function(nestedList, list, index, element, post) {\n                            this.getDetailCard().setHtml(post.get('content'));\n                        }\n                    }\n                },\n                //this is the new item\n                {\n                    title: 'Contact',\n                    iconCls: 'user',\n                    xtype: 'formpanel',\n                    url: 'contact.php',\n                    layout: 'vbox',\n\n                    items: [\n                        {\n                            xtype: 'fieldset',\n                            title: 'Contact Us',\n                            instructions: '(email address is optional)',\n                            items: [\n                                {\n                                    xtype: 'textfield',\n                                    label: 'Name'\n                                },\n                                {\n                                    xtype: 'emailfield',\n                                    label: 'Email'\n                                },\n                                {\n                                    xtype: 'textareafield',\n                                    label: 'Message'\n                                }\n                            ]\n                        },\n                        {\n                            xtype: 'button',\n                            text: 'Send',\n                            ui: 'confirm',\n                            handler: function() {\n                                this.up('formpanel').submit();\n                            }\n                        }\n                    ]\n                }\n            ]\n        });\n    }\n});\n</code></pre>\n\n<p>You can find the full source code of the getting started app in the examples/getting_started folder of the Sencha Touch 2.0 SDK download.</p>\n"});