Ext.data.JsonP.getting_started({"title":"Getting Started with Touch 2","guide":"<h1>Getting Started with Sencha Touch 2</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/getting_started-section-1'>What is Sencha Touch?</a></li>\n<li><a href='#!/guide/getting_started-section-2'>Things you'll need</a></li>\n<li><a href='#!/guide/getting_started-section-3'>Starting your app</a></li>\n<li><a href='#!/guide/getting_started-section-4'>Next Steps</a></li>\n</ol>\n</div>\n\n<h2 id='getting_started-section-1'>What is Sencha Touch?</h2>\n\n<p>Sencha Touch enables you to quickly and easily create HTML-5 based mobile apps that work on Android, iOS, and Blackberry devices and produce a native-app-like experience inside a browser.</p>\n\n<h2 id='getting_started-section-2'>Things you'll need</h2>\n\n<p>Here's what you need to get started:</p>\n\n<ul>\n<li>The free <a href=\"http://www.sencha.com/blog/sencha-touch-2-raising-the-bar\">Sencha Touch 2.0 SDK</a>, currently in beta</li>\n<li>A web server running locally on your computer</li>\n<li>A modern web browser; Chrome or Safari are recommended</li>\n</ul>\n\n\n<p>Download and unzip the latest version of the SDK. Place the unzipped folder into your web server's document root. If you don't have a web server or aren't sure, we recommend using a simple one-click installer like WAMP or MAMP.</p>\n\n<p>Once you have the folder in the right place just open your web browser, point it to http://localhost/sencha-touch-folder (or wherever your web server is configured to serve from) and you should see the Sencha Touch Welcome page. If that's all working you're ready to start your first app.</p>\n\n<h2 id='getting_started-section-3'>Starting your app</h2>\n\n<p>Sencha Touch apps work best when they follow the simple application structure guidelines we provide. This is a small set of conventions and classes that make writing maintainable apps simpler, especially when you work as part of a team.</p>\n\n<p>The first step is to set up the simple folder structure that will house the app. Initially all you need is two files and a copy of Sencha Touch. By convention, these are:</p>\n\n<ul>\n<li><strong>index.html</strong> - a simple HTML file that includes Sencha Touch and your application file</li>\n<li><strong>app.js</strong> - a file where you define the app name, home screen icon, and what it's supposed to do on launch</li>\n<li><strong>touch</strong> - a copy of the downloaded Sencha Touch folder</li>\n</ul>\n\n\n<p>Let's start with the index.html file. Here's what it looks like:</p>\n\n<pre><code>&lt;!DOCTYPE html&gt;\n&lt;html&gt;\n&lt;head&gt;\n    &lt;title&gt;Getting Started&lt;/title&gt;\n    &lt;link rel=\"stylesheet\" href=\"touch/resources/css/sencha-touch.css\" type=\"text/css\"&gt;\n    &lt;script type=\"text/javascript\" src=\"touch/builds/sencha-touch-all-debug.js\"&gt;&lt;/script&gt;\n    &lt;script type=\"text/javascript\" src=\"app.js\"&gt;&lt;/script&gt;\n&lt;/head&gt;\n&lt;body&gt;&lt;/body&gt;\n&lt;/html&gt;\n</code></pre>\n\n<p>This is probably one of the simplest HTML pages you'll ever write. All it does is include Sencha Touch (the JavaScript file and its stylesheet), and your app.js. Note that the body is empty - we'll let Sencha Touch fill that up.</p>\n\n<p>Next, let's look at the contents of our app.js file. We'll keep things simple to start and just call <code>alert</code> to make sure everything's working:</p>\n\n<pre class='inline-example raw miniphone'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        alert('launched');\n    }\n});\n</code></pre>\n\n<p>That's all you need to get started. Now, launch Safari or Chrome and make sure it works as expected. You can also click the small Preview icon next to the example above to run it. So far it doesn't do very much, but the fact that the alert message pops up means Sencha Touch is on the page and the app launched.</p>\n\n<p>The last thing we're going to do is create a <a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Panel</a> with the time-honored Hello World. This is really simple, all we need to do is update our launch function to use <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>, like this:</p>\n\n<pre class='inline-example raw miniphone'><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    name: 'Sencha',\n\n    launch: function() {\n        <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>', {\n            fullscreen: true,\n            html: 'Hello World'\n        });\n    }\n});\n</code></pre>\n\n<h2 id='getting_started-section-4'>Next Steps</h2>\n\n<p>Now that we've put together the simplest of pages and achieved Hello World, it's time to create our first simple app. The next step is to go through the <a href=\"#!/guide/first_app\">First Application guide</a>, which builds on what you've just done and builds a simple but powerful app in around 15 minutes.</p>\n\n<p>If you'd like to skip ahead or find out more detailed information about other aspects of the framework we recommend checking out the following guides and resources:</p>\n\n<h3>Guides</h3>\n\n<ul>\n<li><a href=\"#!/guide/components\">Components and Containers</a></li>\n<li><a href=\"#!/guide/apps_intro\">Intro to Applications</a></li>\n<li><a href=\"#!/guide/layouts\">The Layout System</a></li>\n<li><a href=\"#!/guide/data\">The Data Package</a></li>\n<li><a href=\"#!/guide/whats_new\">What's New in Sencha Touch 2</a></li>\n</ul>\n\n\n<h3>Application Examples</h3>\n\n<ul>\n<li><a href=\"#!/example/kitchensink/index.html\">Kitchen Sink</a></li>\n<li><a href=\"#!/example/twitter/index.html\">Twitter</a></li>\n<li><a href=\"#!/example/kiva/index.html\">Kiva</a></li>\n</ul>\n\n\n<h3>Component Examples</h3>\n\n<ul>\n<li><a href=\"#!/example/carousel/index.html\">Carousel</a></li>\n<li><a href=\"#!/example/forms/index.html\">Forms</a></li>\n<li><a href=\"#!/example/picker/index.html\">Date Picker</a></li>\n</ul>\n\n"});