Ext.data.JsonP.layouts({"title":"Layouts","guide":"<h1>Using Layouts in Sencha Touch 2</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/layouts-section-1'>Intro and HBox</a></li>\n<li><a href='#!/guide/layouts-section-2'>VBox Layout</a></li>\n<li><a href='#!/guide/layouts-section-3'>Card Layout</a></li>\n<li><a href='#!/guide/layouts-section-4'>Fit Layout</a></li>\n<li><a href='#!/guide/layouts-section-5'>Docking</a></li>\n<li><a href='#!/guide/layouts-section-6'>Further Reading</a></li>\n</ol>\n</div>\n\n<h2 id='layouts-section-1'>Intro and HBox</h2>\n\n<p>Layouts describe the sizing and positioning on <a href=\"#!/guide/components\">Components</a> in your app. For example, an email client might have a list of messages pinned to the left, taking say one third of the available width, and a message viewing panel in the rest of the screen.</p>\n\n<p>We can achieve this using an hbox layout and its ability to <em>'flex'</em> items within it. Flexing means we divide the available area up based on the <em>flex</em> of each child component, so to achieve our example above we can set up flexes like this:</p>\n\n<p><p class='screenshot'><img src='guides/layouts/hbox.jpg' alt=''><span></span></p></p>\n\n<p>The code for this is simple, we just need to specify the 'hbox' layout on any Container, then supply a flex for each of the child components (Panels in this case):</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>', {\n    fullscreen: true,\n    layout: 'hbox',\n    items: [\n        {\n            xtype: 'panel',\n            html: 'message list',\n            flex: 1\n        },\n        {\n            xtype: 'panel',\n            html: 'message preview',\n            flex: 2\n        }\n    ]\n});\n</code></pre>\n\n<p>This creates a <a href=\"#!/guide/components\">Container</a> that fills the screen, and inside of it creates a message list panel and a preview panel. Their relative flex configs of 1 and 2 means that the message list will take up one third of the available width, with the preview taking the remaining two thirds. If our Container was 300px wide, the first item (flex: 1) will be 100px wide and the second (flex: 2) will be 200px wide.</p>\n\n<p>The hbox is one of the most useful layouts as it can arrange components in a wide variety of horizontal combinations. See the <a href=\"#!/api/Ext.layout.HBox\" rel=\"Ext.layout.HBox\" class=\"docClass\">HBox documentation</a> for more examples.</p>\n\n<h2 id='layouts-section-2'>VBox Layout</h2>\n\n<p>VBox is much like HBox, just vertical instead of horizontal. Again, we can visualize this easily as a set of stacked boxes:</p>\n\n<p><p class='screenshot'><img src='guides/layouts/vbox.jpg' alt=''><span></span></p></p>\n\n<p>The code to create this is almost identical to the example above - we just traded <em>layout: 'hbox'</em> for <em>layout: 'vbox'</em>:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>', {\n    fullscreen: true,\n    layout: 'vbox',\n    items: [\n        {\n            xtype: 'panel',\n            html: 'message list',\n            flex: 1\n        },\n        {\n            xtype: 'panel',\n            html: 'message preview',\n            flex: 2\n        }\n    ]\n});\n</code></pre>\n\n<p>If our Container was 300px tall, the first panel (flex: 1) will be 100px tall, and the second (flex: 2) will be 200px tall. See the <a href=\"#!/api/Ext.layout.VBox\" rel=\"Ext.layout.VBox\" class=\"docClass\">VBox documentation</a> for more examples.</p>\n\n<h2 id='layouts-section-3'>Card Layout</h2>\n\n<p>Sometimes you want to show several screens worth of information but you've only got a small screen to work with. TabPanels and Carousels both enable you to see one screen of many at a time, and underneath they both use a Card Layout.</p>\n\n<p>Card Layout takes the size of the Container it is applied to and sizes the currently active item to fill the Container completely. It then hides the rest of the items, allowing you to change which one is currently visible but only showing one at once:</p>\n\n<p><p class='screenshot'><img src='guides/layouts/card.jpg' alt=''><span></span></p></p>\n\n<p>Here the gray box is our Container, and the blue box inside it is the currently active card. The three other cards are hidden from view, but can be swapped in later. While it's not too common to create Card layouts directly, you can do so like this:</p>\n\n<pre><code>var panel = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>', {\n    layout: 'card',\n    items: [\n        {\n            html: \"First Item\"\n        },\n        {\n            html: \"Second Item\"\n        },\n        {\n            html: \"Third Item\"\n        },\n        {\n            html: \"Fourth Item\"\n        }\n    ]\n});\n\npanel.setActiveItem(1);\n</code></pre>\n\n<p>Here we create a Panel with a Card Layout and later set the second item active (the active item index is zero-based, so 1 corresponds to the second item). Normally you're better off using a <a href=\"#!/guide/tabs\">Tab Panel</a> or a <a href=\"#!/guide/carousel\">Carousel</a>.</p>\n\n<h2 id='layouts-section-4'>Fit Layout</h2>\n\n<p>Fit Layout is probably the simplest layout available. All it does is make a child component fit to the full size of its parent Container.</p>\n\n<p><p class='screenshot'><img src='guides/layouts/fit.jpg' alt=''><span></span></p></p>\n\n<p>For example, if you have a parent Container that is 200px by 200px and give it a single child component and a 'fit' layout, the child component will also be 200px by 200px:</p>\n\n<pre><code>var panel = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Panel\" rel=\"Ext.Panel\" class=\"docClass\">Ext.Panel</a>', {\n    width: 200,\n    height: 200,\n    layout: 'fit',\n\n    items: {\n        xtype: 'panel',\n        html: 'Also 200px by 200px'\n    }\n});\n\n<a href=\"#!/api/Ext.Viewport-method-add\" rel=\"Ext.Viewport-method-add\" class=\"docClass\">Ext.Viewport.add</a>(panel);\n</code></pre>\n\n<p>Please note that if you add more than one item into a container with a fit layout, only the first item will be visible. If you want to switch between multiple items use the Card layout instead.</p>\n\n<h2 id='layouts-section-5'>Docking</h2>\n\n<p>Every layout is capable of docking items inside it. Docking enables you to place additional Components at the top, right, bottom or left edges of the parent Container, resizing the other items as necessary.</p>\n\n<p>For example, coming back to our first hbox layout above, let's imagine we want to dock another component at the top, like this:</p>\n\n<p><p class='screenshot'><img src='guides/layouts/docktop.jpg' alt=''><span></span></p></p>\n\n<p>This is often used for things like toolbars and banners, and is easy to achieve using the <em>dock: 'top'</em> configuration:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>', {\n    fullscreen: true,\n    layout: 'hbox',\n    items: [\n        {\n            dock: 'top',\n            xtype: 'panel',\n            height: 20,\n            html: 'This is docked to the top'\n        },\n        {\n            xtype: 'panel',\n            html: 'message list',\n            flex: 1\n        },\n        {\n            xtype: 'panel',\n            html: 'message preview',\n            flex: 2\n        }\n    ]\n});\n</code></pre>\n\n<p>You can add any number of docked items by simply providing the <em>dock</em> configuration on the child components you want docked. You can also dock items on any side, for example if we want to do this with our previous vbox example:</p>\n\n<p><p class='screenshot'><img src='guides/layouts/dockleft.jpg' alt=''><span></span></p></p>\n\n<p>We can achieve it by specifying <em>dock: 'left'</em>:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>', {\n    fullscreen: true,\n    layout: 'vbox',\n    items: [\n        {\n            dock: 'left',\n            xtype: 'panel',\n            width: 100,\n            html: 'This is docked to the left'\n        },\n        {\n            xtype: 'panel',\n            html: 'message list',\n            flex: 1\n        },\n        {\n            xtype: 'panel',\n            html: 'message preview',\n            flex: 2\n        }\n    ]\n});\n</code></pre>\n\n<p>You can add multiple docked items on each side (for example docking several items in the 'bottom' position).</p>\n\n<h2 id='layouts-section-6'>Further Reading</h2>\n\n<p>Layouts are just part of the Sencha Touch 2 ecosystem. To understand more about the framework and how it works, we recommend the following:</p>\n\n<ul>\n<li><a href=\"#!/guide/components\">Components and Containers</a></li>\n<li><a href=\"#!/guide/class_system\">The Class System</a></li>\n<li><a href=\"#!/guide/data\">The Data Package</a></li>\n<li><a href=\"#!/guide/getting_started\">Getting Started</a></li>\n</ul>\n\n"});