Ext.data.JsonP.navigation_view({"title":"Using Navigation View","guide":"<h1>Using Navigation View in Sencha Touch 2</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/navigation_view-section-1'>Creating a simple Navigation View</a></li>\n<li><a href='#!/guide/navigation_view-section-2'>Pushing new Views</a></li>\n<li><a href='#!/guide/navigation_view-section-3'>Popping Views</a></li>\n</ol>\n</div>\n\n<p>Navigation View is a new component in Sencha Touch 2. At its base, it is a simple container with a card layout and a docked toolbar; however we built on top of that a easy way to push (add) and pop (remove) views in stack-like fashion. When you push a view, it will add that view into the <code>stack</code> and animate the new title into the toolbar. It will also animate a back button into the toolbar so you can return (or pop) to the previous view.</p>\n\n<p>The easiest way to demonstrate this is with an example:</p>\n\n<pre class='inline-example preview'><code>//create the navigation view and add it into the <a href=\"#!/api/Ext.Viewport\" rel=\"Ext.Viewport\" class=\"docClass\">Ext.Viewport</a>\nvar view = <a href=\"#!/api/Ext.Viewport-method-add\" rel=\"Ext.Viewport-method-add\" class=\"docClass\">Ext.Viewport.add</a>({\n    xtype: 'navigationview',\n\n    //we only give it one item by default, which will be the only item in the 'stack' when it loads\n    items: [\n        {\n            //items can have titles\n            title: 'Navigation View',\n            padding: 10,\n\n            //inside this first item we are going to add a button\n            items: [\n                {\n                    xtype: 'button',\n                    text: 'Push another view!',\n                    handler: function() {\n                        //when someone taps this button, it will push another view into stack\n                        view.push({\n                            //this one also has a title\n                            title: 'Second View',\n                            padding: 10,\n\n                            //once again, this view has one button\n                            items: [\n                                {\n                                    xtype: 'button',\n                                    text: 'Pop this view!',\n                                    handler: function() {\n                                        //and when you press this button, it will pop the current view (this) out of the stack\n                                        view.pop();\n                                    }\n                                }\n                            ]\n                        });\n                    }\n                }\n            ]\n        }\n    ]\n});\n</code></pre>\n\n<h2 id='navigation_view-section-1'>Creating a simple Navigation View</h2>\n\n<p>Creating a Navigation View is just like creating other containers. You use <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a> to create your Navigation View instance, and the only configuration you need to add is <a href=\"#!/api/Ext.navigation.View-cfg-items\" rel=\"Ext.navigation.View-cfg-items\" class=\"docClass\">items</a>.</p>\n\n<pre class='inline-example '><code>var view = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.navigation.View\" rel=\"Ext.navigation.View\" class=\"docClass\">Ext.navigation.View</a>', {\n    fullscreen: true,\n    items: [\n        {\n            title: 'Navigation View',\n            html: 'This is the first item in the stack!'\n        }\n    ]\n});\n</code></pre>\n\n<p>As you can see, we only give it two configurations:</p>\n\n<ul>\n<li><strong><a href=\"#!/api/Ext.navigation.View-cfg-fullscreen\" rel=\"Ext.navigation.View-cfg-fullscreen\" class=\"docClass\">fullscreen</a></strong>: This is so it is automatically inserted into the <a href=\"#!/api/Ext.Viewport\" rel=\"Ext.Viewport\" class=\"docClass\">viewport</a>.</li>\n<li><strong><a href=\"#!/api/Ext.navigation.View-cfg-items\" rel=\"Ext.navigation.View-cfg-items\" class=\"docClass\">items</a></strong>: This is the items that the navigaiton view will contain by default. We only insert one item here, which means it will the first item in the <code>stack</code>; therefore active.\n\n<ul>\n<li><strong>title</strong>: This is the title that will be displayed navigation bar (not required).</li>\n<li><strong><a href=\"#!/api/Ext.Container-cfg-html\" rel=\"Ext.Container-cfg-html\" class=\"docClass\">html</a></strong>: We use the <code>html</code> configuration here just so our first item has some dummy content.</li>\n</ul>\n</li>\n</ul>\n\n\n<h2 id='navigation_view-section-2'>Pushing new Views</h2>\n\n<p>To 'push' means to add a new view to the stack of the navigation view. This will do three things:</p>\n\n<ol>\n<li>Animate the navigation view to show the new item (slide).</li>\n<li>Animate the <code>title</code> configuration of the item (if specified) in the navigation bar (slide).</li>\n<li>Animate the the back button into the navigation bar (slide).</li>\n</ol>\n\n\n<p>Pushing views is made simple using the <a href=\"#!/api/Ext.navigation.View-method-push\" rel=\"Ext.navigation.View-method-push\" class=\"docClass\">push</a> method:</p>\n\n<pre><code>view.push({\n    title: 'New views title',\n    html: 'Some content'\n});\n</code></pre>\n\n<p>You can either pass a reference to a component or a configuration like I did above. And of course, the item you push can be any subclass of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>:</p>\n\n<pre><code>var tabPanel = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">Ext.tab.Panel</a>', {\n    items: [\n        {\n            title: 'First',\n            html: 'first'\n        },\n        {\n            title: 'Second',\n            html: 'second'\n        }\n    ]\n});\n\nview.push(tabPanel);\n</code></pre>\n\n<h2 id='navigation_view-section-3'>Popping Views</h2>\n\n<p>To 'pop' means to remove the top most (visually active) view from the Navigation View. Of course you need to have more than 1 item in the stack for this to do anything. When you pop, it will do a few things:</p>\n\n<ol>\n<li>Animate the navigation view back to the previous item in the stack (reverse slide).</li>\n<li>Animate the current title out of view, and animate the previous stacks title into view (slide).</li>\n<li>Animate the back button out of view, and if there is still more than 2 items in the stack, animate the previous views back button.</li>\n</ol>\n\n\n<p>Popping views is very simple. You just call the <a href=\"#!/api/Ext.navigation.View-method-pop\" rel=\"Ext.navigation.View-method-pop\" class=\"docClass\">pop</a> method:</p>\n\n<pre><code>view.pop();\n</code></pre>\n"});