Ext.data.JsonP.nested_list({"title":"Using Nested List","guide":"<h1>Using Nested List in Sencha Touch 2</h1>\n<div class='toc'>\n<p><strong>Contents</strong></p>\n<ol>\n<li><a href='#!/guide/nested_list-section-1'>Creating a simple Nested List</a></li>\n<li><a href='#!/guide/nested_list-section-2'>Loading Remote Data</a></li>\n<li><a href='#!/guide/nested_list-section-3'>Detail Cards</a></li>\n<li><a href='#!/guide/nested_list-section-4'>Detail Container</a></li>\n</ol>\n</div>\n\n<p><a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Nested List</a> is a component in Sencha Touch which provides a miller column interface to navigate between nested sets of data with a clean and easy to use interface.</p>\n\n<pre class='inline-example miniphone preview'><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('ListItem', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['text']\n});\n\nvar treeStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>', {\n    model: 'ListItem',\n    defaultRootProperty: 'items',\n    root: {\n        items: [\n            {\n                text: 'Drinks',\n                items: [\n                    {\n                        text: 'Water',\n                        items: [\n                            { text: 'Still', leaf: true },\n                            { text: 'Sparkling', leaf: true }\n                        ]\n                    },\n                    { text: 'Soda', leaf: true }\n                ]\n            },\n            {\n                text: 'Snacks',\n                items: [\n                    { text: 'Nuts', leaf: true },\n                    { text: 'Pretzels', leaf: true },\n                    { text: 'Wasabi Peas', leaf: true  }\n                ]\n            }\n        ]\n    }\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Ext.NestedList</a>', {\n    fullscreen: true,\n    store: treeStore\n});\n</code></pre>\n\n<h2 id='nested_list-section-1'>Creating a simple Nested List</h2>\n\n<p>Creating a simple <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Nested List</a> is fairly simple. There are only a few important configurations:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext.dataview.NestedList-cfg-store\" rel=\"Ext.dataview.NestedList-cfg-store\" class=\"docClass\">store</a> - this is the data store which is where the <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Nested List</a> gets its data. <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Nested List</a> uses the <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a> class as <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Nested List</a> has a tree-like UI.</li>\n<li><a href=\"#!/api/Ext.dataview.NestedList-cfg-displayField\" rel=\"Ext.dataview.NestedList-cfg-displayField\" class=\"docClass\">displayField</a> - this is the field of the <a href=\"#!/api/Ext.dataview.NestedList-cfg-store\" rel=\"Ext.dataview.NestedList-cfg-store\" class=\"docClass\">store</a> which will be displayed on each list item in the <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Nested List</a>. This configuration defaults to <code>text</code> so in some cases it is not needed.</li>\n</ul>\n\n\n<p>Lets look at the at the code needed to create a basic <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">nested list</a>:</p>\n\n<pre class='inline-example miniphone'><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('ListItem', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['text']\n});\n\nvar treeStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>', {\n    model: 'ListItem',\n    defaultRootProperty: 'items',\n    root: {\n        items: [\n            {\n                text: 'Drinks',\n                items: [\n                    {\n                        text: 'Water',\n                        items: [\n                            { text: 'Still', leaf: true },\n                            { text: 'Sparkling', leaf: true }\n                        ]\n                    },\n                    { text: 'Soda', leaf: true }\n                ]\n            },\n            {\n                text: 'Snacks',\n                items: [\n                    { text: 'Nuts', leaf: true },\n                    { text: 'Pretzels', leaf: true },\n                    { text: 'Wasabi Peas', leaf: true  }\n                ]\n            }\n        ]\n    }\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Ext.NestedList</a>', {\n    fullscreen: true,\n    store: treeStore\n});\n</code></pre>\n\n<p><strong>Lets walk through the code:</strong></p>\n\n<ul>\n<li>First we define our <code>ListItem</code> model. This is a simple <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a> with 1 field defined which is our <code>text</code> field. This is the only information we need at this point, and it will be displayed in the list for each item.</li>\n<li>Next we create our <code>treeStore</code>.</li>\n<li>The first property we pass is the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">model</a> instance was just defined.</li>\n<li>Then we define the <a href=\"#!/api/Ext.data.TreeStore-cfg-defaultRootProperty\" rel=\"Ext.data.TreeStore-cfg-defaultRootProperty\" class=\"docClass\">defaultRootProperty</a><code>of the data that will be passed into our treeStore. In our case, this will be</code>items`.</li>\n<li>Then we define the <a href=\"#!/api/Ext.data.TreeStore-cfg-root\" rel=\"Ext.data.TreeStore-cfg-root\" class=\"docClass\">root</a> property. This is the data that will be passed into the treeStore.</li>\n</ul>\n\n\n<h3>Tree Store Data</h3>\n\n<p>The most confusing part of the above example is definitely the <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">TreeStore</a> and its <a href=\"#!/api/Ext.data.TreeStore-cfg-root\" rel=\"Ext.data.TreeStore-cfg-root\" class=\"docClass\">root/data</a>. Lets look at the code again:</p>\n\n<pre><code>var treeStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>', {\n    model: 'ListItem',\n    defaultRootProperty: 'items',\n    root: {\n        items: [\n            {\n                text: 'Drinks',\n                items: [\n                    {\n                        text: 'Water',\n                        items: [\n                            { text: 'Still', leaf: true },\n                            { text: 'Sparkling', leaf: true }\n                        ]\n                    },\n                    { text: 'Soda', leaf: true }\n                ]\n            },\n            {\n                text: 'Snacks',\n                items: [\n                    { text: 'Nuts', leaf: true },\n                    { text: 'Pretzels', leaf: true },\n                    { text: 'Wasabi Peas', leaf: true  }\n                ]\n            }\n        ]\n    }\n});\n</code></pre>\n\n<p>So the first two lines are easy to understand. First we create an instance of a <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">TreeStore</a> and then we give it a model which we defined above. Simple.</p>\n\n<p><a href=\"#!/api/Ext.data.TreeStore-cfg-defaultRootProperty\" rel=\"Ext.data.TreeStore-cfg-defaultRootProperty\" class=\"docClass\">defaultRootProperty</a> is where it starts to get a little bit trickier. It is the root field of your data which tells the <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">nested list</a> where the data starts. This is the same whether it is inline JavaScript (like above) or remote data (which we will come to later). This properly also applies to each item in your data, even if it is nested.</p>\n\n<p>The <a href=\"#!/api/Ext.data.TreeStore-cfg-root\" rel=\"Ext.data.TreeStore-cfg-root\" class=\"docClass\">root</a> property is this case is the data for this <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">store</a>. As you can see it is an object, and it only has one property which is <code>items</code> - which is also our <code>defaultRootProperty</code>. Now within each item, we specify a <code>text</code> property which we also defined in our <code>ListItem</code> model above. As you can see the <strong>Drinks</strong>, <strong>Water</strong> and <strong>Snacks</strong> items also have children (using the <code>defaultRootProperty</code> <code>items</code>).</p>\n\n<p>Some of the items also have a <code>leaf</code> property. This means that when a user taps on this item, a <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detail card</a> will appear (if configured) - but we will leave that until later.</p>\n\n<h2 id='nested_list-section-2'>Loading Remote Data</h2>\n\n<p>In the above example we simply add some inline data, but when creating real world examples this is very rarely the case. What if we want to load data from a remove JSON file?</p>\n\n<p>It is actually very similar. Lets look at the JSON file we want to load:</p>\n\n<pre><code>{\n    \"items\": [\n        {\n            \"text\": \"Drinks\",\n            \"items\": [\n                {\n                    \"text\": \"Water\",\n                    \"items\": [\n                        { \"text\": \"Still\", \"leaf\": true },\n                        { \"text\": \"Sparkling\", \"leaf\": true }\n                    ]\n                },\n                { \"text\": \"Soda\", \"leaf\": true }\n            ]\n        },\n        {\n            \"text\": \"Snacks\",\n            \"items\": [\n                { \"text\": \"Nuts\", \"leaf\": true },\n                { \"text\": \"Pretzels\", \"leaf\": true },\n                { \"text\": \"Wasabi Peas\", \"leaf\": true  }\n            ]\n        }\n    ]\n}\n</code></pre>\n\n<p>As you can see, it is identical to the inline <a href=\"#!/api/Ext.data.TreeStore-cfg-root\" rel=\"Ext.data.TreeStore-cfg-root\" class=\"docClass\">root</a> properly we defined above. So lets look at what is different when we create the <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">TreeStore</a>:</p>\n\n<pre><code>var treeStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>', {\n    model: 'ListItem',\n    defaultRootProperty: 'items'\n    proxy: {\n        type: 'ajax',\n        url: 'data.json'\n    }\n});\n</code></pre>\n\n<p>We create the store using <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a> and then we set the <code>model</code> and <code>defaultRootProperty</code> properties just like before, but then, this time, we set a <code>proxy</code>. This property tells the <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">TreeStore</a> to load its data using a specify proxy. In this case we give it a <code>type</code> of <strong>ajax</strong> (because it is loading a remote file) and then <code>url</code> of where the JSON file is. Simple.</p>\n\n<h2 id='nested_list-section-3'>Detail Cards</h2>\n\n<p>A <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detail card</a> is what shows (if configured) if a user taps on an item that is a <code>leaf</code> (defined in the data the <a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">TreeStore</a> loads - example above). It can be any type of <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a>, which means it is very customizable. You can set the detail card using the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a> config in the nested list configuration. Lets look a simple example:</p>\n\n<pre class='inline-example miniphone preview'><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('ListItem', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['text']\n});\n\nvar treeStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>', {\n    model: 'ListItem',\n    defaultRootProperty: 'items',\n    root: {\n        items: [\n            {\n                text: 'Drinks',\n                items: [\n                    {\n                        text: 'Water',\n                        items: [\n                            { text: 'Still', leaf: true },\n                            { text: 'Sparkling', leaf: true }\n                        ]\n                    },\n                    { text: 'Soda', leaf: true }\n                ]\n            },\n            {\n                text: 'Snacks',\n                items: [\n                    { text: 'Nuts', leaf: true },\n                    { text: 'Pretzels', leaf: true },\n                    { text: 'Wasabi Peas', leaf: true  }\n                ]\n            }\n        ]\n    }\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Ext.NestedList</a>', {\n    fullscreen: true,\n    store: treeStore,\n    detailCard: {\n        html: 'You are viewing the detail card!'\n    }\n});\n</code></pre>\n\n<p>As you can see, when you tap on one of the <code>leaf</code> items, the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detail card</a> is visible. So lets look at the code:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Ext.NestedList</a>', {\n    fullscreen: true,\n    store: treeStore,\n    detailCard: {\n        html: 'You are viewing the detail card!'\n    }\n});\n</code></pre>\n\n<p>We simply set the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a> to be an object, with a config of <a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">html</a> set. This object will automatically be transformed into a <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Component</a> (just like when you call <a href=\"#!/api/Ext.Container-method-add\" rel=\"Ext.Container-method-add\" class=\"docClass\">add</a> on a <a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Container</a>).</p>\n\n<p>What if we want to set the data in the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a> depending on what item we tap? Lets look at how we do that:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Ext.NestedList</a>', {\n    fullscreen: true,\n    store: treeStore,\n    detailCard: {\n        html: 'You are viewing the detail card!'\n    },\n    listeners: {\n        leafitemtap: function(nestedList, list, index, target, record) {\n            var detailCard = nestedList.getDetailCard();\n            detailCard.setHtml('You selected: ' + record.get('text'));\n        }\n    }\n});\n</code></pre>\n\n<p>Look how we added the <a href=\"#!/api/Ext.dataview.NestedList-cfg-listeners\" rel=\"Ext.dataview.NestedList-cfg-listeners\" class=\"docClass\">listeners</a> config. We do this because we want to listen to the <strong><a href=\"#!/api/Ext.dataview.NestedList-event-leafitemtap\" rel=\"Ext.dataview.NestedList-event-leafitemtap\" class=\"docClass\">leafitemtap</a></strong> event, which is called when any leaf item is... tapped. :)</p>\n\n<p>When that event is fired, it is passed a number of arguments:</p>\n\n<ul>\n<li><strong>nestedList</strong> - this is a reference to the <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">nested list</a> instance.</li>\n<li><strong>list</strong> - this is a reference to the last <a href=\"#!/api/Ext.dataview.List\" rel=\"Ext.dataview.List\" class=\"docClass\">list</a>, where the item with the <code>leaf</code> config was tapped.</li>\n<li><strong>index</strong> - the index of the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">record</a> in the <a href=\"#!/api/Ext.dataview.List\" rel=\"Ext.dataview.List\" class=\"docClass\">list</a> <a href=\"#!/api/Ext.dataview.List-cfg-store\" rel=\"Ext.dataview.List-cfg-store\" class=\"docClass\">store</a>.</li>\n<li><strong>target</strong> - the <a href=\"#!/api/Ext.dom.Element\" rel=\"Ext.dom.Element\" class=\"docClass\">element</a> which was tapped.</li>\n<li><strong>record</strong> - the <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">record</a> of the item which was tapped.</li>\n</ul>\n\n\n<p>Now that we know when someone taps a <code>leaf</code> item, and we know which <code>record</code> was tapped, we can update the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detail card</a> with some data.</p>\n\n<p>To get the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a>, we can use the <a href=\"#!/api/Ext.dataview.NestedList-method-getDetailCard\" rel=\"Ext.dataview.NestedList-method-getDetailCard\" class=\"docClass\">Ext.NestedList.getDetailCard</a> method, and then with that we can update the <a href=\"#!/api/Ext.Component-cfg-html\" rel=\"Ext.Component-cfg-html\" class=\"docClass\">html</a> config of our <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a>.</p>\n\n<p>Lets look at an example of this working:</p>\n\n<pre class='inline-example miniphone preview'><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('ListItem', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['text']\n});\n\nvar treeStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>', {\n    model: 'ListItem',\n    defaultRootProperty: 'items',\n    root: {\n        items: [\n            {\n                text: 'Drinks',\n                items: [\n                    {\n                        text: 'Water',\n                        items: [\n                            { text: 'Still', leaf: true },\n                            { text: 'Sparkling', leaf: true }\n                        ]\n                    },\n                    { text: 'Soda', leaf: true }\n                ]\n            },\n            {\n                text: 'Snacks',\n                items: [\n                    { text: 'Nuts', leaf: true },\n                    { text: 'Pretzels', leaf: true },\n                    { text: 'Wasabi Peas', leaf: true  }\n                ]\n            }\n        ]\n    }\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Ext.NestedList</a>', {\n    fullscreen: true,\n    store: treeStore,\n    detailCard: {\n        html: 'You are viewing the detail card!'\n    },\n    listeners: {\n        leafitemtap: function(nestedList, list, index, target, record) {\n            var detailCard = nestedList.getDetailCard();\n            detailCard.setHtml('You selected: ' + record.get('text'));\n        }\n    }\n});\n</code></pre>\n\n<h2 id='nested_list-section-4'>Detail Container</h2>\n\n<p>Nested List has a <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailContainer\" rel=\"Ext.dataview.NestedList-cfg-detailContainer\" class=\"docClass\">detailContainer</a> configuration which is used to specify the container of the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a>. This is used when you want the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a> to be in another container, which is often the case when the screen size is bigger than a normal phone.</p>\n\n<p>Lets look at an example of this in action:</p>\n\n<pre class='inline-example preview'><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('ListItem', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['text']\n});\n\nvar treeStore = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.TreeStore\" rel=\"Ext.data.TreeStore\" class=\"docClass\">Ext.data.TreeStore</a>', {\n    model: 'ListItem',\n    defaultRootProperty: 'items',\n    root: {\n        items: [\n            {\n                text: 'Drinks',\n                items: [\n                    {\n                        text: 'Water',\n                        items: [\n                            { text: 'Still', leaf: true },\n                            { text: 'Sparkling', leaf: true }\n                        ]\n                    },\n                    { text: 'Soda', leaf: true }\n                ]\n            },\n            {\n                text: 'Snacks',\n                items: [\n                    { text: 'Nuts', leaf: true },\n                    { text: 'Pretzels', leaf: true },\n                    { text: 'Wasabi Peas', leaf: true  }\n                ]\n            }\n        ]\n    }\n});\n\nvar detailContainer = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>', {\n    layout: 'card',\n    flex: 1\n});\n\nvar nestedList = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Ext.NestedList</a>', {\n    store: treeStore,\n    detailContainer: detailContainer,\n    detailCard: true,\n    listeners: {\n        leafitemtap: function(nestedList, list, index, target, record) {\n            var detailCard = nestedList.getDetailCard();\n            detailCard.setHtml('You selected: ' + record.get('text'));\n        }\n    },\n    flex: 1\n});\n\n<a href=\"#!/api/Ext.Viewport-method-add\" rel=\"Ext.Viewport-method-add\" class=\"docClass\">Ext.Viewport.add</a>({\n    layout: 'hbox',\n    items: [\n        nestedList,\n        detailContainer\n    ]\n});\n</code></pre>\n\n<p>As you can see, we have 2 items in the Viewport now.</p>\n\n<ul>\n<li>The <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">nested list</a>.</li>\n<li>A new container which we specify as the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailContainer\" rel=\"Ext.dataview.NestedList-cfg-detailContainer\" class=\"docClass\">detailContainer</a>.</li>\n</ul>\n\n\n<p>Setting the configuration is very simple. You just give it a reference to the container you want to use as the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailContainer\" rel=\"Ext.dataview.NestedList-cfg-detailContainer\" class=\"docClass\">detail container</a>:</p>\n\n<pre><code>var detailContainer = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>', {\n    layout: 'card'\n});\n\nvar nestedList = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">Ext.NestedList</a>', {\n    store: treeStore,\n    detailCard: true,\n    detailContainer: detailContainer\n});\n</code></pre>\n\n<p>If you do not specify a <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailContainer\" rel=\"Ext.dataview.NestedList-cfg-detailContainer\" class=\"docClass\">detailContainer</a>, the <a href=\"#!/api/Ext.dataview.NestedList-cfg-detailCard\" rel=\"Ext.dataview.NestedList-cfg-detailCard\" class=\"docClass\">detailCard</a> will be added into the <a href=\"#!/api/Ext.dataview.NestedList\" rel=\"Ext.dataview.NestedList\" class=\"docClass\">nested list</a>.</p>\n"});