Ext.data.JsonP.stores({"title":"Using Stores","guide":"<h1>Using Stores</h1>\n\n<p><a href=\"#!/guide/Models\">Models</a> are typically used with a Store, which is basically a collection of model instances. Setting up a store and loading its data is simple:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    proxy: {\n        type: 'ajax',\n        url : 'users.json',\n        reader: 'json'\n    },\n    autoLoad: true\n});\n</code></pre>\n\n<p>We configured our store to use an <a href=\"#!/api/Ext.data.proxy.Ajax\" rel=\"Ext.data.proxy.Ajax\" class=\"docClass\">Ajax Proxy</a>, providing the name of the URL from which to load data the <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Reader</a> used to decode the data. In this case our server is returning JSON, so we've set up a <a href=\"#!/api/Ext.data.reader.Json\" rel=\"Ext.data.reader.Json\" class=\"docClass\">Json Reader</a> to read the response.\nThe store auto-loads a set of User model instances from the URL <code>users.json</code>.  The <code>users.json</code> URL should return a JSON string that looks something like this:</p>\n\n<pre><code>{\n    success: true,\n    users: [\n        { id: 1, name: 'Ed' },\n        { id: 2, name: 'Tommy' }\n    ]\n}\n</code></pre>\n\n<p>For a live demo, see the <a href=\"guides/data/examples/simple_store/index.html\">Simple Store</a> example.</p>\n\n<h3>Inline data</h3>\n\n<p>Stores can also load data inline. Internally, <code>Store</code> converts each of the objects we pass in as <a href=\"#!/api/Ext.data.Store-cfg-data\" rel=\"Ext.data.Store-cfg-data\" class=\"docClass\">data</a> into <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Model</a> instances:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n    data: [\n        { firstName: 'Ed',    lastName: 'Spencer' },\n        { firstName: 'Tommy', lastName: 'Maintz' },\n        { firstName: 'Aaron', lastName: 'Conran' },\n        { firstName: 'Jamie', lastName: 'Avins' }\n    ]\n});\n</code></pre>\n\n<p><a href=\"guides/data/examples/inline_data/index.html\">Inline Data example</a></p>\n\n<h3>Sorting and Grouping</h3>\n\n<p>Stores are able to perform sorting, filtering, and grouping locally, as well as to support remote sorting, filtering, and grouping:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User',\n\n    sorters: ['name', 'id'],\n    filters: {\n        property: 'name',\n        value   : 'Ed'\n    },\n    groupField: 'age',\n    groupDir: 'DESC'\n});\n</code></pre>\n\n<p>In the store we just created, the data will be sorted first by name then id; it will be filtered to only include users with the name <code>Ed</code>, and the data will be grouped by age in descending order. It's easy to change the sorting, filtering, and grouping at any time through the Store API.  For a live demo, see the <a href=\"guides/data/examples/sorting_grouping_filtering_store/index.html\">Sorting Grouping Filtering Store</a> example.</p>\n"});