Ext.data.JsonP.Ext_ClassManager({"inheritdoc":null,"aliases":{},"extends":null,"alternateClassNames":[],"uses":[],"singleton":true,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[],"property":[]},"component":false,"tagname":"class","code_type":"nop","members":{"css_var":[],"css_mixin":[],"cfg":[],"method":[{"owner":"Ext.ClassManager","tagname":"method","name":"applyOverrides","id":"method-applyOverrides","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"create","id":"method-create","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"createNamespaces","id":"method-createNamespaces","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"dynInstantiate","id":"method-dynInstantiate","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"get","id":"method-get","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"getAliasesByName","id":"method-getAliasesByName","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"getByAlias","id":"method-getByAlias","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"getClass","id":"method-getClass","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"getDisplayName","id":"method-getDisplayName","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"getInstantiator","id":"method-getInstantiator","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"getName","id":"method-getName","meta":{"markdown":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"getNameByAlias","id":"method-getNameByAlias","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"getNameByAlternate","id":"method-getNameByAlternate","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"getNamesByExpression","id":"method-getNamesByExpression","meta":{"markdown":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"instantiate","id":"method-instantiate","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"instantiateByAlias","id":"method-instantiateByAlias","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"isCreated","id":"method-isCreated","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"onCreated","id":"method-onCreated","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"parseNamespace","id":"method-parseNamespace","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"registerPostprocessor","id":"method-registerPostprocessor","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"set","id":"method-set","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"setAlias","id":"method-setAlias","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"setDefaultPostprocessorPosition","id":"method-setDefaultPostprocessorPosition","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"setDefaultPostprocessors","id":"method-setDefaultPostprocessors","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"method","name":"setNamespace","id":"method-setNamespace","meta":{}},{"owner":"Ext.ClassManager","tagname":"method","name":"triggerCreated","id":"method-triggerCreated","meta":{"private":true}}],"event":[],"property":[{"owner":"Ext.ClassManager","tagname":"property","name":"classes","id":"property-classes","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"createdListeners","id":"property-createdListeners","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"defaultPostprocessors","id":"property-defaultPostprocessors","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"enableNamespaceParseCache","id":"property-enableNamespaceParseCache","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"existCache","id":"property-existCache","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"instantiators","id":"property-instantiators","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"maps","id":"property-maps","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"nameCreatedListeners","id":"property-nameCreatedListeners","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"namespaceParseCache","id":"property-namespaceParseCache","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"namespaceRewrites","id":"property-namespaceRewrites","meta":{"private":true}},{"owner":"Ext.ClassManager","tagname":"property","name":"postprocessors","id":"property-postprocessors","meta":{"private":true}}]},"superclasses":[],"html_meta":{"author":null},"private":false,"mixedInto":[],"name":"Ext.ClassManager","mixins":[],"inheritable":false,"subclasses":[],"id":"class-Ext.ClassManager","html":"<div><pre class=\"hierarchy\"><h4>Files</h4><div class='dependency'><a href='source/ClassManager.html#Ext-ClassManager' target='_blank'>ClassManager.js</a></div></pre><div class='doc-contents'><p><a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">Ext.ClassManager</a> manages all classes and handles mapping from string class name to\nactual class objects throughout the whole framework. It is not generally accessed directly, rather through\nthese convenient shorthands:</p>\n\n<ul>\n<li><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a></li>\n<li><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a></li>\n<li><a href=\"#!/api/Ext-method-widget\" rel=\"Ext-method-widget\" class=\"docClass\">Ext.widget</a></li>\n<li><a href=\"#!/api/Ext-method-getClass\" rel=\"Ext-method-getClass\" class=\"docClass\">Ext.getClass</a></li>\n<li><a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a></li>\n</ul>\n\n\n<h2>Basic syntax:</h2>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>(className, properties);\n</code></pre>\n\n<p>in which <code>properties</code> is an object represent a collection of properties that apply to the class. See\n<a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">create</a> for more detailed instructions.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n     name: 'Unknown',\n\n     constructor: function(name) {\n         if (name) {\n             this.name = name;\n         }\n\n         return this;\n     },\n\n     eat: function(foodType) {\n         alert(\"I'm eating: \" + foodType);\n\n         return this;\n     }\n});\n\nvar aaron = new Person(\"Aaron\");\naaron.eat(\"Sandwich\"); // alert(\"I'm eating: Sandwich\");\n</code></pre>\n\n<p><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a> has a powerful set of extensible <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">pre-processors</a> which takes care of\neverything related to class creation, including but not limited to inheritance, mixins, configuration, statics, etc.</p>\n\n<h2>Inheritance:</h2>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Developer', {\n     extend: 'Person',\n\n     constructor: function(name, isGeek) {\n         this.isGeek = isGeek;\n\n         // Apply a method from the parent class' prototype\n         this.callParent([name]);\n\n         return this;\n\n     },\n\n     code: function(language) {\n         alert(\"I'm coding in: \" + language);\n\n         this.eat(\"Bugs\");\n\n         return this;\n     }\n});\n\nvar jacky = new Developer(\"Jacky\", true);\njacky.code(\"JavaScript\"); // alert(\"I'm coding in: JavaScript\");\n                          // alert(\"I'm eating: Bugs\");\n</code></pre>\n\n<p>See <a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">Ext.Base.callParent</a> for more details on calling superclass' methods</p>\n\n<h2>Mixins:</h2>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('CanPlayGuitar', {\n     playGuitar: function() {\n        alert(\"F#...G...D...A\");\n     }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('CanComposeSongs', {\n     composeSongs: function() { ... }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('CanSing', {\n     sing: function() {\n         alert(\"I'm on the highway to hell...\")\n     }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Musician', {\n     extend: 'Person',\n\n     mixins: {\n         canPlayGuitar: 'CanPlayGuitar',\n         canComposeSongs: 'CanComposeSongs',\n         canSing: 'CanSing'\n     }\n})\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('CoolPerson', {\n     extend: 'Person',\n\n     mixins: {\n         canPlayGuitar: 'CanPlayGuitar',\n         canSing: 'CanSing'\n     },\n\n     sing: function() {\n         alert(\"Ahem....\");\n\n         this.mixins.canSing.sing.call(this);\n\n         alert(\"[Playing guitar at the same time...]\");\n\n         this.playGuitar();\n     }\n});\n\nvar me = new CoolPerson(\"Jacky\");\n\nme.sing(); // alert(\"Ahem...\");\n           // alert(\"I'm on the highway to hell...\");\n           // alert(\"[Playing guitar at the same time...]\");\n           // alert(\"F#...G...D...A\");\n</code></pre>\n\n<h2>Config:</h2>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('SmartPhone', {\n     config: {\n         hasTouchScreen: false,\n         operatingSystem: 'Other',\n         price: 500\n     },\n\n     isExpensive: false,\n\n     constructor: function(config) {\n         this.initConfig(config);\n\n         return this;\n     },\n\n     applyPrice: function(price) {\n         this.isExpensive = (price &gt; 500);\n\n         return price;\n     },\n\n     applyOperatingSystem: function(operatingSystem) {\n         if (!(/^(iOS|Android|BlackBerry)$/i).test(operatingSystem)) {\n             return 'Other';\n         }\n\n         return operatingSystem;\n     }\n});\n\nvar iPhone = new SmartPhone({\n     hasTouchScreen: true,\n     operatingSystem: 'iOS'\n});\n\niPhone.getPrice(); // 500;\niPhone.getOperatingSystem(); // 'iOS'\niPhone.getHasTouchScreen(); // true;\niPhone.hasTouchScreen(); // true\n\niPhone.isExpensive; // false;\niPhone.setPrice(600);\niPhone.getPrice(); // 600\niPhone.isExpensive; // true;\n\niPhone.setOperatingSystem('AlienOS');\niPhone.getOperatingSystem(); // 'Other'\n</code></pre>\n\n<h2>Statics:</h2>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Computer', {\n     statics: {\n         factory: function(brand) {\n            // 'this' in static methods refer to the class itself\n             return new this(brand);\n         }\n     },\n\n     constructor: function() { ... }\n});\n\nvar dellComputer = Computer.factory('Dell');\n</code></pre>\n\n<p>Also see <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">Ext.Base.statics</a> and <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">Ext.Base.self</a> for more details on accessing\nstatic properties within class methods</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-classes' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-classes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-classes' class='name expandable'>classes</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'>All classes which were defined through the ClassManager. ...</div><div class='long'><p>All classes which were defined through the ClassManager. Keys are the\nname of the classes and the values are references to the classes.</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-createdListeners' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-createdListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-createdListeners' class='name expandable'>createdListeners</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-defaultPostprocessors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-defaultPostprocessors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-defaultPostprocessors' class='name expandable'>defaultPostprocessors</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-enableNamespaceParseCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-enableNamespaceParseCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-enableNamespaceParseCache' class='name expandable'>enableNamespaceParseCache</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div><div id='property-existCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-existCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-existCache' class='name expandable'>existCache</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-instantiators' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-instantiators' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-instantiators' class='name expandable'>instantiators</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-maps' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-maps' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-maps' class='name expandable'>maps</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{alternateToName: {}, aliasToName: {}, nameToAliases: {}, nameToAlternates: {}, overridesByName: {}}</code></p></div></div></div><div id='property-nameCreatedListeners' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-nameCreatedListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-nameCreatedListeners' class='name expandable'>nameCreatedListeners</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-namespaceParseCache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-namespaceParseCache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-namespaceParseCache' class='name expandable'>namespaceParseCache</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-namespaceRewrites' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-namespaceRewrites' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-namespaceRewrites' class='name not-expandable'>namespaceRewrites</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='property-postprocessors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-property-postprocessors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-property-postprocessors' class='name expandable'>postprocessors</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>{}</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-applyOverrides' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-applyOverrides' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-applyOverrides' class='name expandable'>applyOverrides</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-create' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-create' class='name expandable'>create</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> className, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> data, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> createdFn</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>createdFn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createNamespaces' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-createNamespaces' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-createNamespaces' class='name expandable'>createNamespaces</a>( <span class='pre'></span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>The new Ext.ns, supports namespace rewriting ...</div><div class='long'><p>The new <a href=\"#!/api/Ext-method-ns\" rel=\"Ext-method-ns\" class=\"docClass\">Ext.ns</a>, supports namespace rewriting</p>\n</div></div></div><div id='method-dynInstantiate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-dynInstantiate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-dynInstantiate' class='name expandable'>dynInstantiate</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> args</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-get' class='name expandable'>get</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name</span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></div><div class='description'><div class='short'>Retrieve a class by its name. ...</div><div class='long'><p>Retrieve a class by its name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'><p>class</p>\n</div></li></ul></div></div></div><div id='method-getAliasesByName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getAliasesByName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getAliasesByName' class='name expandable'>getAliasesByName</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Get the aliases of a class by the class name ...</div><div class='long'><p>Get the aliases of a class by the class name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>aliases</p>\n</div></li></ul></div></div></div><div id='method-getByAlias' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getByAlias' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getByAlias' class='name expandable'>getByAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> alias</span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></div><div class='description'><div class='short'>Get a reference to the class by its alias. ...</div><div class='long'><p>Get a reference to the class by its alias.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'><p>class</p>\n</div></li></ul></div></div></div><div id='method-getClass' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getClass' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getClass' class='name expandable'>getClass</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object</span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></div><div class='description'><div class='short'>Get the class of the provided object; returns null if it's not an instance\nof any class created with Ext.define. ...</div><div class='long'><p>Get the class of the provided object; returns null if it's not an instance\nof any class created with <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>. This is usually invoked by the shorthand <a href=\"#!/api/Ext-method-getClass\" rel=\"Ext-method-getClass\" class=\"docClass\">Ext.getClass</a></p>\n\n<pre><code>var component = new <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>();\n\n<a href=\"#!/api/Ext.ClassManager-method-getClass\" rel=\"Ext.ClassManager-method-getClass\" class=\"docClass\">Ext.ClassManager.getClass</a>(component); // returns <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a>\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'><p>class</p>\n</div></li></ul></div></div></div><div id='method-getDisplayName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getDisplayName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getDisplayName' class='name expandable'>getDisplayName</a>( <span class='pre'>Mixed object</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : Mixed<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getInstantiator' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getInstantiator' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getInstantiator' class='name expandable'>getInstantiator</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> length</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>length</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getName' class='name expandable'>getName</a>( <span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the name of the class by its reference or its instance;\nusually invoked by the shorthand Ext.getClassName\n\nExt.Cl...</div><div class='long'><p>Get the name of the class by its reference or its instance;\nusually invoked by the shorthand <a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a></p>\n\n<pre><code><a href=\"#!/api/Ext.ClassManager-method-getName\" rel=\"Ext.ClassManager-method-getName\" class=\"docClass\">Ext.ClassManager.getName</a>(Ext.Action); // returns \"Ext.Action\"\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='method-getNameByAlias' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getNameByAlias' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getNameByAlias' class='name expandable'>getNameByAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> alias</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the name of a class by its alias. ...</div><div class='long'><p>Get the name of a class by its alias.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='method-getNameByAlternate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getNameByAlternate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getNameByAlternate' class='name expandable'>getNameByAlternate</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> alternate</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the name of a class by its alternate name. ...</div><div class='long'><p>Get the name of a class by its alternate name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alternate</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='method-getNamesByExpression' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-getNamesByExpression' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-getNamesByExpression' class='name expandable'>getNamesByExpression</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> expression</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Converts a string expression to an array of matching class names. ...</div><div class='long'><p>Converts a string expression to an array of matching class names. An expression can either refers to class aliases\nor class names. Expressions support wildcards:</p>\n\n<pre><code> // returns ['Ext.window.Window']\nvar window = <a href=\"#!/api/Ext.ClassManager-method-getNamesByExpression\" rel=\"Ext.ClassManager-method-getNamesByExpression\" class=\"docClass\">Ext.ClassManager.getNamesByExpression</a>('widget.window');\n\n// returns ['widget.panel', 'widget.window', ...]\nvar allWidgets = <a href=\"#!/api/Ext.ClassManager-method-getNamesByExpression\" rel=\"Ext.ClassManager-method-getNamesByExpression\" class=\"docClass\">Ext.ClassManager.getNamesByExpression</a>('widget.*');\n\n// returns ['<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', 'Ext.data.ArrayProxy', ...]\nvar allData = <a href=\"#!/api/Ext.ClassManager-method-getNamesByExpression\" rel=\"Ext.ClassManager-method-getNamesByExpression\" class=\"docClass\">Ext.ClassManager.getNamesByExpression</a>('Ext.data.*');\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>expression</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>classNames</p>\n</div></li></ul></div></div></div><div id='method-instantiate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-instantiate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-instantiate' class='name expandable'>instantiate</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, Mixed args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Instantiate a class by either full name, alias or alternate name; usually invoked by the convenient\nshorthand Ext.cre...</div><div class='long'><p>Instantiate a class by either full name, alias or alternate name; usually invoked by the convenient\nshorthand <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a></p>\n\n<p>If <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a> is <a href=\"#!/api/Ext.Loader-method-setConfig\" rel=\"Ext.Loader-method-setConfig\" class=\"docClass\">enabled</a> and the class has not been defined yet, it will\nattempt to load the class via synchronous loading.</p>\n\n<p>For example, all these three lines return the same result:</p>\n\n<pre><code>// alias\nvar window = <a href=\"#!/api/Ext.ClassManager-method-instantiate\" rel=\"Ext.ClassManager-method-instantiate\" class=\"docClass\">Ext.ClassManager.instantiate</a>('widget.window', { width: 600, height: 800, ... });\n\n// alternate name\nvar window = <a href=\"#!/api/Ext.ClassManager-method-instantiate\" rel=\"Ext.ClassManager-method-instantiate\" class=\"docClass\">Ext.ClassManager.instantiate</a>('Ext.Window', { width: 600, height: 800, ... });\n\n// full class name\nvar window = <a href=\"#!/api/Ext.ClassManager-method-instantiate\" rel=\"Ext.ClassManager-method-instantiate\" class=\"docClass\">Ext.ClassManager.instantiate</a>('Ext.window.Window', { width: 600, height: 800, ... });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>args</span> : Mixed<div class='sub-desc'><p>,... Additional arguments after the name will be passed to the class' constructor.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>instance</p>\n</div></li></ul></div></div></div><div id='method-instantiateByAlias' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-instantiateByAlias' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-instantiateByAlias' class='name expandable'>instantiateByAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> alias, Mixed... args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Instantiate a class by its alias; usually invoked by the convenient shorthand Ext.createByAlias\nIf Ext.Loader is enab...</div><div class='long'><p>Instantiate a class by its alias; usually invoked by the convenient shorthand <a href=\"#!/api/Ext-method-createByAlias\" rel=\"Ext-method-createByAlias\" class=\"docClass\">Ext.createByAlias</a>\nIf <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a> is <a href=\"#!/api/Ext.Loader-method-setConfig\" rel=\"Ext.Loader-method-setConfig\" class=\"docClass\">enabled</a> and the class has not been defined yet, it will\nattempt to load the class via synchronous loading.</p>\n\n<pre><code>var window = <a href=\"#!/api/Ext.ClassManager-method-instantiateByAlias\" rel=\"Ext.ClassManager-method-instantiateByAlias\" class=\"docClass\">Ext.ClassManager.instantiateByAlias</a>('widget.window', { width: 600, height: 800, ... });\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>args</span> : Mixed...<div class='sub-desc'><p>Additional arguments after the alias will be passed to the class constructor.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>instance</p>\n</div></li></ul></div></div></div><div id='method-isCreated' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-isCreated' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-isCreated' class='name expandable'>isCreated</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> className</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if a class has already been created. ...</div><div class='long'><p>Checks if a class has already been created.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>exist</p>\n</div></li></ul></div></div></div><div id='method-onCreated' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-onCreated' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-onCreated' class='name expandable'>onCreated</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> className</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>className</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-parseNamespace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-parseNamespace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-parseNamespace' class='name expandable'>parseNamespace</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> namespace</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Supports namespace rewriting ...</div><div class='long'><p>Supports namespace rewriting</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>namespace</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-registerPostprocessor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-registerPostprocessor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-registerPostprocessor' class='name expandable'>registerPostprocessor</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> postprocessor</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Register a post-processor function. ...</div><div class='long'><p>Register a post-processor function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>postprocessor</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-set' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-set' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-set' class='name expandable'>set</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">Ext.ClassManager</a></div><div class='description'><div class='short'>Sets a name reference to a class. ...</div><div class='long'><p>Sets a name reference to a class.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">Ext.ClassManager</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setAlias' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-setAlias' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-setAlias' class='name expandable'>setAlias</a>( <span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> cls, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> alias</span> )</div><div class='description'><div class='short'>Register the alias for a class. ...</div><div class='long'><p>Register the alias for a class.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>a reference to a class or a className</p>\n</div></li><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Alias to use when referring to this class</p>\n</div></li></ul></div></div></div><div id='method-setDefaultPostprocessorPosition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-setDefaultPostprocessorPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-setDefaultPostprocessorPosition' class='name expandable'>setDefaultPostprocessorPosition</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> offset, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> relativeName</span> ) : <a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">Ext.ClassManager</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Insert this post-processor at a specific position in the stack, optionally relative to\nany existing post-processor ...</div><div class='long'><p>Insert this post-processor at a specific position in the stack, optionally relative to\nany existing post-processor</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The post-processor name. Note that it needs to be registered with\n<a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">registerPostprocessor</a> before this</p>\n</div></li><li><span class='pre'>offset</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The insertion position. Four possible values are:\n'first', 'last', or: 'before', 'after' (relative to the name provided in the third argument)</p>\n</div></li><li><span class='pre'>relativeName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">Ext.ClassManager</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setDefaultPostprocessors' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-setDefaultPostprocessors' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-setDefaultPostprocessors' class='name expandable'>setDefaultPostprocessors</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> The</span> ) : <a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">Ext.ClassManager</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Set the default post processors array stack which are applied to every class. ...</div><div class='long'><p>Set the default post processors array stack which are applied to every class.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>The</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>name of a registered post processor or an array of registered names.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.ClassManager\" rel=\"Ext.ClassManager\" class=\"docClass\">Ext.ClassManager</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-setNamespace' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-setNamespace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-setNamespace' class='name expandable'>setNamespace</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name, Mixed value</span> )</div><div class='description'><div class='short'>Creates a namespace and assign the value to the created object\n\nExt.ClassManager.setNamespace('MyCompany.pkg.Example'...</div><div class='long'><p>Creates a namespace and assign the <code>value</code> to the created object</p>\n\n<pre><code><a href=\"#!/api/Ext.ClassManager-method-setNamespace\" rel=\"Ext.ClassManager-method-setNamespace\" class=\"docClass\">Ext.ClassManager.setNamespace</a>('MyCompany.pkg.Example', someObject);\nalert(MyCompany.pkg.Example === someObject); // alerts true\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li><li><span class='pre'>value</span> : Mixed<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-triggerCreated' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.ClassManager'>Ext.ClassManager</span><br/><a href='source/ClassManager.html#Ext-ClassManager-method-triggerCreated' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.ClassManager-method-triggerCreated' class='name expandable'>triggerCreated</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> className</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>className</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"requires":[],"meta":{"author":["Jacky Nguyen <jacky@sencha.com>"]},"files":[{"href":"ClassManager.html#Ext-ClassManager","filename":"ClassManager.js"}]});