Ext.data.JsonP.Ext_DateExtras({"inheritdoc":null,"aliases":{},"extends":null,"alternateClassNames":[],"uses":[],"singleton":true,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[],"property":[]},"component":false,"tagname":"class","code_type":"assignment","members":{"css_var":[],"css_mixin":[],"cfg":[],"method":[{"owner":"Ext.DateExtras","tagname":"method","name":"add","id":"method-add","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"between","id":"method-between","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"clearTime","id":"method-clearTime","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"clone","id":"method-clone","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"format","id":"method-format","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getDayOfYear","id":"method-getDayOfYear","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getDaysInMonth","id":"method-getDaysInMonth","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getElapsed","id":"method-getElapsed","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getFirstDateOfMonth","id":"method-getFirstDateOfMonth","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getFirstDayOfMonth","id":"method-getFirstDayOfMonth","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getGMTOffset","id":"method-getGMTOffset","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getLastDateOfMonth","id":"method-getLastDateOfMonth","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getLastDayOfMonth","id":"method-getLastDayOfMonth","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getMonthNumber","id":"method-getMonthNumber","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getShortDayName","id":"method-getShortDayName","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getShortMonthName","id":"method-getShortMonthName","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getSuffix","id":"method-getSuffix","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getTimezone","id":"method-getTimezone","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"getWeekOfYear","id":"method-getWeekOfYear","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"isDST","id":"method-isDST","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"isLeapYear","id":"method-isLeapYear","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"isValid","id":"method-isValid","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"now","id":"method-now","meta":{}},{"owner":"Ext.DateExtras","tagname":"method","name":"parse","id":"method-parse","meta":{}}],"event":[],"property":[{"owner":"Ext.DateExtras","tagname":"property","name":"DAY","id":"property-DAY","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"HOUR","id":"property-HOUR","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"MILLI","id":"property-MILLI","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"MINUTE","id":"property-MINUTE","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"MONTH","id":"property-MONTH","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"SECOND","id":"property-SECOND","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"YEAR","id":"property-YEAR","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"dayNames","id":"property-dayNames","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"defaultFormat","id":"property-defaultFormat","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"defaults","id":"property-defaults","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"formatCodes","id":"property-formatCodes","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"formatFunctions","id":"property-formatFunctions","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"monthNames","id":"property-monthNames","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"monthNumbers","id":"property-monthNumbers","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"parseFunctions","id":"property-parseFunctions","meta":{}},{"owner":"Ext.DateExtras","tagname":"property","name":"useStrict","id":"property-useStrict","meta":{}}]},"superclasses":[],"html_meta":{},"private":false,"mixedInto":["Ext.Date"],"name":"Ext.DateExtras","mixins":[],"inheritable":false,"subclasses":[],"id":"class-Ext.DateExtras","html":"<div><pre class=\"hierarchy\"><h4>Mixed into</h4><div class='dependency'><a href='#!/api/Ext.Date' rel='Ext.Date' class='docClass'>Ext.Date</a></div><h4>Files</h4><div class='dependency'><a href='source/DateExtras.html#Ext-DateExtras' target='_blank'>DateExtras.js</a></div></pre><div class='doc-contents'><p>Extra methods to be mixed into <a href=\"#!/api/Ext.Date\" rel=\"Ext.Date\" class=\"docClass\">Ext.Date</a>.</p>\n\n<p>Require this class to get <a href=\"#!/api/Ext.Date\" rel=\"Ext.Date\" class=\"docClass\">Ext.Date</a> with all the methods listed below.</p>\n\n<p>Using <a href=\"#!/api/Ext-method-setup\" rel=\"Ext-method-setup\" class=\"docClass\">Ext.setup</a>:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-setup\" rel=\"Ext-method-setup\" class=\"docClass\">Ext.setup</a>({\n    requires: '<a href=\"#!/api/Ext.DateExtras\" rel=\"Ext.DateExtras\" class=\"docClass\">Ext.DateExtras</a>',\n    onReady: function() {\n        var date = new Date();\n        alert(<a href=\"#!/api/Ext.Date-method-format\" rel=\"Ext.Date-method-format\" class=\"docClass\">Ext.Date.format</a>(date, 'j/d/Y'));\n    }\n});\n</code></pre>\n\n<p>Using <a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-application\" rel=\"Ext-method-application\" class=\"docClass\">Ext.application</a>({\n    requires: '<a href=\"#!/api/Ext.DateExtras\" rel=\"Ext.DateExtras\" class=\"docClass\">Ext.DateExtras</a>',\n    launch: function() {\n        var date = new Date();\n        alert(<a href=\"#!/api/Ext.Date-method-format\" rel=\"Ext.Date-method-format\" class=\"docClass\">Ext.Date.format</a>(date, 'j/d/Y'));\n    }\n});\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-DAY' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-DAY' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-DAY' class='name expandable'>DAY</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Date interval constant ...</div><div class='long'><p>Date interval constant</p>\n<p>Defaults to: <code>&quot;d&quot;</code></p></div></div></div><div id='property-HOUR' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-HOUR' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-HOUR' class='name expandable'>HOUR</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Date interval constant ...</div><div class='long'><p>Date interval constant</p>\n<p>Defaults to: <code>&quot;h&quot;</code></p></div></div></div><div id='property-MILLI' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-MILLI' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-MILLI' class='name expandable'>MILLI</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Date interval constant ...</div><div class='long'><p>Date interval constant</p>\n<p>Defaults to: <code>&quot;ms&quot;</code></p></div></div></div><div id='property-MINUTE' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-MINUTE' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-MINUTE' class='name expandable'>MINUTE</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Date interval constant ...</div><div class='long'><p>Date interval constant</p>\n<p>Defaults to: <code>&quot;mi&quot;</code></p></div></div></div><div id='property-MONTH' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-MONTH' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-MONTH' class='name expandable'>MONTH</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Date interval constant ...</div><div class='long'><p>Date interval constant</p>\n<p>Defaults to: <code>&quot;mo&quot;</code></p></div></div></div><div id='property-SECOND' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-SECOND' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-SECOND' class='name expandable'>SECOND</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Date interval constant ...</div><div class='long'><p>Date interval constant</p>\n<p>Defaults to: <code>&quot;s&quot;</code></p></div></div></div><div id='property-YEAR' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-YEAR' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-YEAR' class='name expandable'>YEAR</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Date interval constant ...</div><div class='long'><p>Date interval constant</p>\n<p>Defaults to: <code>&quot;y&quot;</code></p></div></div></div><div id='property-dayNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-dayNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-dayNames' class='name expandable'>dayNames</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of textual day names. ...</div><div class='long'><p>An array of textual day names.\nOverride these values for international dates.\nExample:</p>\n\n<pre><code><a href=\"#!/api/Ext.Date-property-dayNames\" rel=\"Ext.Date-property-dayNames\" class=\"docClass\">Ext.Date.dayNames</a> = [\n    'SundayInYourLang',\n    'MondayInYourLang',\n    ...\n];\n</code></pre>\n\n<p>Defaults to: <code>[&quot;Sunday&quot;, &quot;Monday&quot;, &quot;Tuesday&quot;, &quot;Wednesday&quot;, &quot;Thursday&quot;, &quot;Friday&quot;, &quot;Saturday&quot;]</code></p></div></div></div><div id='property-defaultFormat' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-defaultFormat' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-defaultFormat' class='name expandable'>defaultFormat</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The date format string that the Ext.util.Format.date function uses. ...</div><div class='long'><p>The date format string that the <a href=\"#!/api/Ext.util.Format-method-date\" rel=\"Ext.util.Format-method-date\" class=\"docClass\">Ext.util.Format.date</a> function uses.\nSee <a href=\"#!/api/Ext.Date\" rel=\"Ext.Date\" class=\"docClass\">Ext.Date</a> for details.</p>\n\n\n<p>This defaults to <code>m/d/Y</code>, but may be overridden in a locale file.</p>\n\n<p>Defaults to: <code>&quot;m/d/Y&quot;</code></p></div></div></div><div id='property-defaults' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-defaults' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-defaults' class='name expandable'>defaults</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object hash containing default date values used during date parsing. ...</div><div class='long'><p>An object hash containing default date values used during date parsing.</p>\n\n\n<p>The following properties are available:<div class=\"mdetail-params\"><ul>\n<li><code>y</code> : Number<div class=\"sub-desc\">The default year value. (defaults to undefined)</div></li>\n<li><code>m</code> : Number<div class=\"sub-desc\">The default 1-based month value. (defaults to undefined)</div></li>\n<li><code>d</code> : Number<div class=\"sub-desc\">The default day value. (defaults to undefined)</div></li>\n<li><code>h</code> : Number<div class=\"sub-desc\">The default hour value. (defaults to undefined)</div></li>\n<li><code>i</code> : Number<div class=\"sub-desc\">The default minute value. (defaults to undefined)</div></li>\n<li><code>s</code> : Number<div class=\"sub-desc\">The default second value. (defaults to undefined)</div></li>\n<li><code>ms</code> : Number<div class=\"sub-desc\">The default millisecond value. (defaults to undefined)</div></li>\n</ul></div></p>\n\n\n<p>Override these properties to customize the default date values used by the <a href=\"#!/api/Ext.DateExtras-method-parse\" rel=\"Ext.DateExtras-method-parse\" class=\"docClass\">parse</a> method.</p>\n\n\n<p><b>Note: In countries which experience Daylight Saving Time (i.e. DST), the <tt>h</tt>, <tt>i</tt>, <tt>s</tt>\nand <tt>ms</tt> properties may coincide with the exact time in which DST takes effect.\nIt is the responsiblity of the developer to account for this.</b></p>\n\n\n<p>Example Usage:</p>\n\n<pre><code>// set default day value to the first day of the month\nExt.Date.defaults.d = 1;\n\n// parse a February date string containing only year and month values.\n// setting the default day value to 1 prevents weird date rollover issues\n// when attempting to parse the following date string on, for example, March 31st 2009.\n<a href=\"#!/api/Ext.Date-method-parse\" rel=\"Ext.Date-method-parse\" class=\"docClass\">Ext.Date.parse</a>('2009-02', 'Y-m'); // returns a Date object representing February 1st 2009\n</code></pre>\n\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-formatCodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-formatCodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-formatCodes' class='name expandable'>formatCodes</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>The base format-code to formatting-function hashmap used by the format method. ...</div><div class='long'><p>The base format-code to formatting-function hashmap used by the <a href=\"#!/api/Ext.DateExtras-method-format\" rel=\"Ext.DateExtras-method-format\" class=\"docClass\">format</a> method.\nFormatting functions are strings (or functions which return strings) which\nwill return the appropriate value when evaluated in the context of the Date object\nfrom which the <a href=\"#!/api/Ext.DateExtras-method-format\" rel=\"Ext.DateExtras-method-format\" class=\"docClass\">format</a> method is called.\nAdd to / override these mappings for custom date formatting.\nNote: <a href=\"#!/api/Ext.Date-method-format\" rel=\"Ext.Date-method-format\" class=\"docClass\">Ext.Date.format</a>() treats characters as literals if an appropriate mapping cannot be found.\nExample:</p>\n\n<pre><code>Ext.Date.formatCodes.x = \"<a href=\"#!/api/Ext.util.Format-method-leftPad\" rel=\"Ext.util.Format-method-leftPad\" class=\"docClass\">Ext.util.Format.leftPad</a>(this.getDate(), 2, '0')\";\nconsole.log(<a href=\"#!/api/Ext.Date-method-format\" rel=\"Ext.Date-method-format\" class=\"docClass\">Ext.Date.format</a>(new Date(), 'X'); // returns the current day of the month\n</code></pre>\n\n</div></div></div><div id='property-formatFunctions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-formatFunctions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-formatFunctions' class='name expandable'>formatFunctions</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object hash in which each property is a date formatting function. ...</div><div class='long'><p>An object hash in which each property is a date formatting function. The property name is the\nformat string which corresponds to the produced formatted date string.</p>\n\n\n<p>This object is automatically populated with date formatting functions as\ndate formats are requested for Ext standard formatting strings.</p>\n\n\n<p>Custom formatting functions may be inserted into this object, keyed by a name which from then on\nmay be used as a format string to <a href=\"#!/api/Ext.DateExtras-method-format\" rel=\"Ext.DateExtras-method-format\" class=\"docClass\">format</a>. Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext.Date-property-formatFunctions\" rel=\"Ext.Date-property-formatFunctions\" class=\"docClass\">Ext.Date.formatFunctions</a>['x-date-format'] = myDateFormatter;\n</code></pre>\n\n\n<p>A formatting function should return a string representation of the passed Date object, and is passed the following parameters:<div class=\"mdetail-params\"><ul>\n<li><code>date</code> : Date<div class=\"sub-desc\">The Date to format.</div></li>\n</ul></div></p>\n\n\n<p>To enable date strings to also be <i>parsed</i> according to that format, a corresponding\nparsing function must be placed into the <a href=\"#!/api/Ext.DateExtras-property-parseFunctions\" rel=\"Ext.DateExtras-property-parseFunctions\" class=\"docClass\">parseFunctions</a> property.\n\n</div></div></div><div id='property-monthNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-monthNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-monthNames' class='name expandable'>monthNames</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of textual month names. ...</div><div class='long'><p>An array of textual month names.\nOverride these values for international dates.\nExample:</p>\n\n<pre><code><a href=\"#!/api/Ext.Date-property-monthNames\" rel=\"Ext.Date-property-monthNames\" class=\"docClass\">Ext.Date.monthNames</a> = [\n    'JanInYourLang',\n    'FebInYourLang',\n    ...\n];\n</code></pre>\n\n<p>Defaults to: <code>[&quot;January&quot;, &quot;February&quot;, &quot;March&quot;, &quot;April&quot;, &quot;May&quot;, &quot;June&quot;, &quot;July&quot;, &quot;August&quot;, &quot;September&quot;, &quot;October&quot;, &quot;November&quot;, &quot;December&quot;]</code></p></div></div></div><div id='property-monthNumbers' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-monthNumbers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-monthNumbers' class='name expandable'>monthNumbers</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object hash of zero-based javascript month numbers (with short month names as keys. ...</div><div class='long'><p>An object hash of zero-based javascript month numbers (with short month names as keys. note: keys are case-sensitive).\nOverride these values for international dates.\nExample:</p>\n\n<pre><code><a href=\"#!/api/Ext.Date-property-monthNumbers\" rel=\"Ext.Date-property-monthNumbers\" class=\"docClass\">Ext.Date.monthNumbers</a> = {\n    'ShortJanNameInYourLang':0,\n    'ShortFebNameInYourLang':1,\n    ...\n};\n</code></pre>\n\n<p>Defaults to: <code>{Jan: 0, Feb: 1, Mar: 2, Apr: 3, May: 4, Jun: 5, Jul: 6, Aug: 7, Sep: 8, Oct: 9, Nov: 10, Dec: 11}</code></p></div></div></div><div id='property-parseFunctions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-parseFunctions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-parseFunctions' class='name expandable'>parseFunctions</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object hash in which each property is a date parsing function. ...</div><div class='long'><p>An object hash in which each property is a date parsing function. The property name is the\nformat string which that function parses.</p>\n\n\n<p>This object is automatically populated with date parsing functions as\ndate formats are requested for Ext standard formatting strings.</p>\n\n\n<p>Custom parsing functions may be inserted into this object, keyed by a name which from then on\nmay be used as a format string to <a href=\"#!/api/Ext.DateExtras-method-parse\" rel=\"Ext.DateExtras-method-parse\" class=\"docClass\">parse</a>.<p>\n<p>Example:</p>\n<pre><code><a href=\"#!/api/Ext.Date-property-parseFunctions\" rel=\"Ext.Date-property-parseFunctions\" class=\"docClass\">Ext.Date.parseFunctions</a>['x-date-format'] = myDateParser;\n</code></pre>\n<p>A parsing function should return a Date object, and is passed the following parameters:<div class=\"mdetail-params\"><ul>\n<li><code>date</code> : String<div class=\"sub-desc\">The date string to parse.</div></li>\n<li><code>strict</code> : Boolean<div class=\"sub-desc\">True to validate date strings while parsing\n(i.e. prevent javascript Date \"rollover\") (The default must be false).\nInvalid date strings should return null when parsed.</div></li>\n</ul></div></p>\n<p>To enable Dates to also be <i>formatted</i> according to that format, a corresponding\nformatting function must be placed into the <a href=\"#!/api/Ext.DateExtras-property-formatFunctions\" rel=\"Ext.DateExtras-property-formatFunctions\" class=\"docClass\">formatFunctions</a> property.\n\n</div></div></div><div id='property-useStrict' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-property-useStrict' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-property-useStrict' class='name expandable'>useStrict</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Global flag which determines if strict date parsing should be used. ...</div><div class='long'><p>Global flag which determines if strict date parsing should be used.\nStrict date parsing will not roll-over invalid dates, which is the\ndefault behaviour of javascript Date objects.\n(see <a href=\"#!/api/Ext.DateExtras-method-parse\" rel=\"Ext.DateExtras-method-parse\" class=\"docClass\">parse</a> for more information)\nDefaults to <tt>false</tt>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-add' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-add' class='name expandable'>add</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> interval, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> value</span> ) : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></div><div class='description'><div class='short'>Provides a convenient method for performing basic date arithmetic. ...</div><div class='long'><p>Provides a convenient method for performing basic date arithmetic. This method\ndoes not modify the Date instance being called - it creates and returns\na new Date instance containing the resulting date value.</p>\n\n<p>Examples:</p>\n\n<pre><code>// Basic usage:\nvar dt = <a href=\"#!/api/Ext.Date-method-add\" rel=\"Ext.Date-method-add\" class=\"docClass\">Ext.Date.add</a>(new Date('10/29/2006'), <a href=\"#!/api/Ext.Date-property-DAY\" rel=\"Ext.Date-property-DAY\" class=\"docClass\">Ext.Date.DAY</a>, 5);\nconsole.log(dt); //returns 'Fri Nov 03 2006 00:00:00'\n\n// Negative values will be subtracted:\nvar dt2 = <a href=\"#!/api/Ext.Date-method-add\" rel=\"Ext.Date-method-add\" class=\"docClass\">Ext.Date.add</a>(new Date('10/1/2006'), <a href=\"#!/api/Ext.Date-property-DAY\" rel=\"Ext.Date-property-DAY\" class=\"docClass\">Ext.Date.DAY</a>, -5);\nconsole.log(dt2); //returns 'Tue Sep 26 2006 00:00:00'\n\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date to modify</p>\n</div></li><li><span class='pre'>interval</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>A valid date interval enum value.</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The amount to add to the current date.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></span><div class='sub-desc'><p>The new Date instance.</p>\n</div></li></ul></div></div></div><div id='method-between' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-between' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-between' class='name expandable'>between</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date, <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> start, <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> end</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if a date falls on or between the given start and end dates. ...</div><div class='long'><p>Checks if a date falls on or between the given start and end dates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date to check</p>\n</div></li><li><span class='pre'>start</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>Start date</p>\n</div></li><li><span class='pre'>end</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>End date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if this date falls on or between the given start and end dates.</p>\n</div></li></ul></div></div></div><div id='method-clearTime' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-clearTime' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-clearTime' class='name expandable'>clearTime</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date, <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> clone</span> ) : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></div><div class='description'><div class='short'>Attempts to clear all time information from this Date by setting the time to midnight of the same day,\nautomatically ...</div><div class='long'><p>Attempts to clear all time information from this Date by setting the time to midnight of the same day,\nautomatically adjusting for Daylight Saving Time (DST) where applicable.\n(note: DST timezone information for the browser's host operating system is assumed to be up-to-date)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li><li><span class='pre'>clone</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>true to create a clone of this date, clear the time and return it (defaults to false).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></span><div class='sub-desc'><p>this or the clone.</p>\n</div></li></ul></div></div></div><div id='method-clone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-clone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-clone' class='name expandable'>clone</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></div><div class='description'><div class='short'>Creates and returns a new Date instance with the exact same date value as the called instance. ...</div><div class='long'><p>Creates and returns a new Date instance with the exact same date value as the called instance.\nDates are copied and passed by reference, so if a copied date variable is modified later, the original\nvariable will also be changed.  When the intention is to create a new variable that will not\nmodify the original instance, you should create a clone.</p>\n\n<p>Example of correctly cloning a date:</p>\n\n<pre><code>//wrong way:\nvar orig = new Date('10/1/2006');\nvar copy = orig;\ncopy.setDate(5);\nconsole.log(orig);  //returns 'Thu Oct 05 2006'!\n\n//correct way:\nvar orig = new Date('10/1/2006'),\n    copy = <a href=\"#!/api/Ext.Date-method-clone\" rel=\"Ext.Date-method-clone\" class=\"docClass\">Ext.Date.clone</a>(orig);\ncopy.setDate(5);\nconsole.log(orig);  //returns 'Thu Oct 01 2006'\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></span><div class='sub-desc'><p>The new Date instance.</p>\n</div></li></ul></div></div></div><div id='method-format' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-format' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-format' class='name expandable'>format</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> format</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Formats a date given the supplied format string. ...</div><div class='long'><p>Formats a date given the supplied format string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date to format</p>\n</div></li><li><span class='pre'>format</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The format string</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The formatted date</p>\n</div></li></ul></div></div></div><div id='method-getDayOfYear' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getDayOfYear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getDayOfYear' class='name expandable'>getDayOfYear</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Get the numeric day number of the year, adjusted for leap year. ...</div><div class='long'><p>Get the numeric day number of the year, adjusted for leap year.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>0 to 364 (365 in leap years).</p>\n</div></li></ul></div></div></div><div id='method-getDaysInMonth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getDaysInMonth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getDaysInMonth' class='name expandable'>getDaysInMonth</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Get the number of days in the current month, adjusted for leap year. ...</div><div class='long'><p>Get the number of days in the current month, adjusted for leap year.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The number of days in the month.</p>\n</div></li></ul></div></div></div><div id='method-getElapsed' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getElapsed' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getElapsed' class='name expandable'>getElapsed</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> dateA, [<a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> dateB]</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the number of milliseconds between two dates ...</div><div class='long'><p>Returns the number of milliseconds between two dates</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>dateA</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The first date</p>\n</div></li><li><span class='pre'>dateB</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> (optional)<div class='sub-desc'><p>The second date, defaults to now</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The difference in milliseconds</p>\n</div></li></ul></div></div></div><div id='method-getFirstDateOfMonth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getFirstDateOfMonth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getFirstDateOfMonth' class='name expandable'>getFirstDateOfMonth</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></div><div class='description'><div class='short'>Get the date of the first day of the month in which this date resides. ...</div><div class='long'><p>Get the date of the first day of the month in which this date resides.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFirstDayOfMonth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getFirstDayOfMonth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getFirstDayOfMonth' class='name expandable'>getFirstDayOfMonth</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Get the first day of the current month, adjusted for leap year. ...</div><div class='long'><p>Get the first day of the current month, adjusted for leap year.  The returned value\nis the numeric day index within the week (0-6) which can be used in conjunction with\nthe <a href=\"#!/api/Ext.DateExtras-property-monthNames\" rel=\"Ext.DateExtras-property-monthNames\" class=\"docClass\">monthNames</a> array to retrieve the textual day name.\nExample:</p>\n\n<pre><code>var dt = new Date('1/10/2007'),\n    firstDay = <a href=\"#!/api/Ext.Date-method-getFirstDayOfMonth\" rel=\"Ext.Date-method-getFirstDayOfMonth\" class=\"docClass\">Ext.Date.getFirstDayOfMonth</a>(dt);\nconsole.log(<a href=\"#!/api/Ext.Date-property-dayNames\" rel=\"Ext.Date-property-dayNames\" class=\"docClass\">Ext.Date.dayNames</a>[firstDay]); //output: 'Monday'\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The day number (0-6).</p>\n</div></li></ul></div></div></div><div id='method-getGMTOffset' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getGMTOffset' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getGMTOffset' class='name expandable'>getGMTOffset</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> colon]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the offset from GMT of the current date (equivalent to the format specifier 'O'). ...</div><div class='long'><p>Get the offset from GMT of the current date (equivalent to the format specifier 'O').</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li><li><span class='pre'>colon</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>true to separate the hours and minutes with a colon (defaults to false).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The 4-character offset string prefixed with + or - (e.g. '-0600').</p>\n</div></li></ul></div></div></div><div id='method-getLastDateOfMonth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getLastDateOfMonth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getLastDateOfMonth' class='name expandable'>getLastDateOfMonth</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></div><div class='description'><div class='short'>Get the date of the last day of the month in which this date resides. ...</div><div class='long'><p>Get the date of the last day of the month in which this date resides.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getLastDayOfMonth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getLastDayOfMonth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getLastDayOfMonth' class='name expandable'>getLastDayOfMonth</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Get the last day of the current month, adjusted for leap year. ...</div><div class='long'><p>Get the last day of the current month, adjusted for leap year.  The returned value\nis the numeric day index within the week (0-6) which can be used in conjunction with\nthe <a href=\"#!/api/Ext.DateExtras-property-monthNames\" rel=\"Ext.DateExtras-property-monthNames\" class=\"docClass\">monthNames</a> array to retrieve the textual day name.\nExample:</p>\n\n<pre><code>var dt = new Date('1/10/2007'),\n    lastDay = <a href=\"#!/api/Ext.Date-method-getLastDayOfMonth\" rel=\"Ext.Date-method-getLastDayOfMonth\" class=\"docClass\">Ext.Date.getLastDayOfMonth</a>(dt);\nconsole.log(<a href=\"#!/api/Ext.Date-property-dayNames\" rel=\"Ext.Date-property-dayNames\" class=\"docClass\">Ext.Date.dayNames</a>[lastDay]); //output: 'Wednesday'\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The day number (0-6).</p>\n</div></li></ul></div></div></div><div id='method-getMonthNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getMonthNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getMonthNumber' class='name expandable'>getMonthNumber</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> name</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Get the zero-based javascript month number for the given short/full month name. ...</div><div class='long'><p>Get the zero-based javascript month number for the given short/full month name.\nOverride this function for international dates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The short/full month name.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The zero-based javascript month number.</p>\n</div></li></ul></div></div></div><div id='method-getShortDayName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getShortDayName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getShortDayName' class='name expandable'>getShortDayName</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> day</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the short day name for the given day number. ...</div><div class='long'><p>Get the short day name for the given day number.\nOverride this function for international dates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>day</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>A zero-based javascript day number.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The short day name.</p>\n</div></li></ul></div></div></div><div id='method-getShortMonthName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getShortMonthName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getShortMonthName' class='name expandable'>getShortMonthName</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> month</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the short month name for the given month number. ...</div><div class='long'><p>Get the short month name for the given month number.\nOverride this function for international dates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>month</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>A zero-based javascript month number.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The short month name.</p>\n</div></li></ul></div></div></div><div id='method-getSuffix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getSuffix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getSuffix' class='name expandable'>getSuffix</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the English ordinal suffix of the current day (equivalent to the format specifier 'S'). ...</div><div class='long'><p>Get the English ordinal suffix of the current day (equivalent to the format specifier 'S').</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>'st, 'nd', 'rd' or 'th'.</p>\n</div></li></ul></div></div></div><div id='method-getTimezone' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getTimezone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getTimezone' class='name expandable'>getTimezone</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Get the timezone abbreviation of the current date (equivalent to the format specifier 'T'). ...</div><div class='long'><p>Get the timezone abbreviation of the current date (equivalent to the format specifier 'T').</p>\n\n<p>Note: The date string returned by the javascript Date object's toString() method varies\nbetween browsers (e.g. FF vs IE) and system region settings (e.g. IE in Asia vs IE in America).\nFor a given date string e.g. \"Thu Oct 25 2007 22:55:35 GMT+0800 (Malay Peninsula Standard Time)\",\ngetTimezone() first tries to get the timezone abbreviation from between a pair of parentheses\n(which may or may not be present), failing which it proceeds to get the timezone abbreviation\nfrom the GMT offset portion of the date string.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The abbreviated timezone name (e.g. 'CST', 'PDT', 'EDT', 'MPST' ...).</p>\n</div></li></ul></div></div></div><div id='method-getWeekOfYear' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-getWeekOfYear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-getWeekOfYear' class='name expandable'>getWeekOfYear</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Get the numeric ISO-8601 week number of the year. ...</div><div class='long'><p>Get the numeric ISO-8601 week number of the year.\n(equivalent to the format specifier 'W', but without a leading zero).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>1 to 53</p>\n</div></li></ul></div></div></div><div id='method-isDST' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-isDST' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-isDST' class='name expandable'>isDST</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if the current date is affected by Daylight Saving Time (DST). ...</div><div class='long'><p>Checks if the current date is affected by Daylight Saving Time (DST).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the current date is affected by DST.</p>\n</div></li></ul></div></div></div><div id='method-isLeapYear' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-isLeapYear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-isLeapYear' class='name expandable'>isLeapYear</a>( <span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a> date</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if the current date falls within a leap year. ...</div><div class='long'><p>Checks if the current date falls within a leap year.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>date</span> : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a><div class='sub-desc'><p>The date</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the current date falls within a leap year, false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-isValid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-isValid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-isValid' class='name expandable'>isValid</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> year, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> month, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> day, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> hour], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> minute], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> second], [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> millisecond]</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if the passed Date parameters will cause a javascript Date \"rollover\". ...</div><div class='long'><p>Checks if the passed Date parameters will cause a javascript Date \"rollover\".</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>year</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>4-digit year</p>\n</div></li><li><span class='pre'>month</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>1-based month-of-year</p>\n</div></li><li><span class='pre'>day</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>Day of month</p>\n</div></li><li><span class='pre'>hour</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Hour</p>\n</div></li><li><span class='pre'>minute</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Minute</p>\n</div></li><li><span class='pre'>second</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Second</p>\n</div></li><li><span class='pre'>millisecond</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Millisecond</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>true if the passed parameters do not cause a Date \"rollover\", false otherwise.</p>\n</div></li></ul></div></div></div><div id='method-now' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-now' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-now' class='name expandable'>now</a>( <span class='pre'></span> ) : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></div><div class='description'><div class='short'>Returns the current timestamp ...</div><div class='long'><p>Returns the current timestamp</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></span><div class='sub-desc'><p>The current timestamp</p>\n</div></li></ul></div></div></div><div id='method-parse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.DateExtras'>Ext.DateExtras</span><br/><a href='source/DateExtras.html#Ext-DateExtras-method-parse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.DateExtras-method-parse' class='name expandable'>parse</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> input, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> format, [<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> strict]</span> ) : <a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></div><div class='description'><div class='short'>Parses the passed string using the specified date format. ...</div><div class='long'><p>Parses the passed string using the specified date format.\nNote that this function expects normal calendar dates, meaning that months are 1-based (i.e. 1 = January).\nThe <a href=\"#!/api/Ext.DateExtras-property-defaults\" rel=\"Ext.DateExtras-property-defaults\" class=\"docClass\">defaults</a> hash will be used for any date value (i.e. year, month, day, hour, minute, second or millisecond)\nwhich cannot be found in the passed string. If a corresponding default date value has not been specified in the <a href=\"#!/api/Ext.DateExtras-property-defaults\" rel=\"Ext.DateExtras-property-defaults\" class=\"docClass\">defaults</a> hash,\nthe current date's year, month, day or DST-adjusted zero-hour time value will be used instead.\nKeep in mind that the input date string must precisely match the specified format string\nin order for the parse operation to be successful (failed parse operations return a null value).</p>\n\n<p>Example:</p>\n\n\n<pre><code>//dt = Fri May 25 2007 (current date)\nvar dt = new Date();\n\n//dt = Thu May 25 2006 (today&#39;s month/day in 2006)\ndt = <a href=\"#!/api/Ext.Date-method-parse\" rel=\"Ext.Date-method-parse\" class=\"docClass\">Ext.Date.parse</a>(\"2006\", \"Y\");\n\n//dt = Sun Jan 15 2006 (all date parts specified)\ndt = <a href=\"#!/api/Ext.Date-method-parse\" rel=\"Ext.Date-method-parse\" class=\"docClass\">Ext.Date.parse</a>(\"2006-01-15\", \"Y-m-d\");\n\n//dt = Sun Jan 15 2006 15:20:01\ndt = <a href=\"#!/api/Ext.Date-method-parse\" rel=\"Ext.Date-method-parse\" class=\"docClass\">Ext.Date.parse</a>(\"2006-01-15 3:20:01 PM\", \"Y-m-d g:i:s A\");\n\n// attempt to parse Sun Feb 29 2006 03:20:01 in strict mode\ndt = <a href=\"#!/api/Ext.Date-method-parse\" rel=\"Ext.Date-method-parse\" class=\"docClass\">Ext.Date.parse</a>(\"2006-02-29 03:20:01\", \"Y-m-d H:i:s\", true); // returns null\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>input</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The raw date string.</p>\n</div></li><li><span class='pre'>format</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The expected date string format.</p>\n</div></li><li><span class='pre'>strict</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to validate date strings while parsing (i.e. prevents javascript Date \"rollover\")</p>\n\n<pre><code>                    (defaults to false). Invalid date strings will return null when parsed.\n</code></pre>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Date\" rel=\"Date\" class=\"docClass\">Date</a></span><div class='sub-desc'><p>The parsed Date.</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"requires":[],"meta":{},"files":[{"href":"DateExtras.html#Ext-DateExtras","filename":"DateExtras.js"}]});