Ext.data.JsonP.Ext_app_Controller({"inheritdoc":null,"aliases":{},"extends":"Ext.Base","alternateClassNames":[],"uses":[],"singleton":false,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[{"owner":"Ext.Base","tagname":"method","name":"addConfig","id":"static-method-addConfig","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"addInheritableStatics","id":"static-method-addInheritableStatics","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"addMember","id":"static-method-addMember","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"addMembers","id":"static-method-addMembers","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"addStatics","id":"static-method-addStatics","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"addXtype","id":"static-method-addXtype","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"borrow","id":"static-method-borrow","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"callParent","id":"static-method-callParent","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"create","id":"static-method-create","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"createAlias","id":"static-method-createAlias","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"extend","id":"static-method-extend","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"getName","id":"static-method-getName","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"implement","id":"static-method-implement","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"mixin","id":"static-method-mixin","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"onExtended","id":"static-method-onExtended","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"override","id":"static-method-override","meta":{"deprecated":{"version":"4.1.0","text":"Use {@link Ext#define Ext.define} instead"},"static":true}},{"owner":"Ext.Base","tagname":"method","name":"triggerExtended","id":"static-method-triggerExtended","meta":{"static":true,"private":true}}],"event":[],"property":[{"owner":"Ext.Base","tagname":"property","name":"$onExtended","id":"static-property-S-onExtended","meta":{"static":true,"private":true}}]},"component":false,"tagname":"class","code_type":"ext_define","members":{"css_var":[],"css_mixin":[],"cfg":[{"owner":"Ext.app.Controller","tagname":"cfg","name":"application","id":"cfg-application","meta":{}},{"owner":"Ext.app.Controller","tagname":"cfg","name":"before","id":"cfg-before","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"cfg","name":"bubbleEvents","id":"cfg-bubbleEvents","meta":{}},{"owner":"Ext.app.Controller","tagname":"cfg","name":"control","id":"cfg-control","meta":{}},{"owner":"Ext.app.Controller","tagname":"cfg","name":"init","id":"cfg-init","meta":{}},{"owner":"Ext.app.Controller","tagname":"cfg","name":"launch","id":"cfg-launch","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"cfg","name":"listeners","id":"cfg-listeners","meta":{}},{"owner":"Ext.app.Controller","tagname":"cfg","name":"refs","id":"cfg-refs","meta":{}},{"owner":"Ext.app.Controller","tagname":"cfg","name":"routes","id":"cfg-routes","meta":{}}],"method":[{"owner":"Ext.app.Controller","tagname":"method","name":"constructor","id":"method-constructor","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"addListener","id":"method-addListener","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"applyBefore","id":"method-applyBefore","meta":{"private":true}},{"owner":"Ext.app.Controller","tagname":"method","name":"applyControl","id":"method-applyControl","meta":{"private":true}},{"owner":"Ext.app.Controller","tagname":"method","name":"applyRefs","id":"method-applyRefs","meta":{"private":true}},{"owner":"Ext.app.Controller","tagname":"method","name":"applyRoutes","id":"method-applyRoutes","meta":{"private":true}},{"owner":"Ext.Base","tagname":"method","name":"callOverridden","id":"method-callOverridden","meta":{"deprecated":{"text":"as of 4.1. Use {@link #callParent} instead."},"protected":true}},{"owner":"Ext.Base","tagname":"method","name":"callParent","id":"method-callParent","meta":{"protected":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"changeListener","id":"method-changeListener","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"clearListeners","id":"method-clearListeners","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"control","id":"method-control","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"createEventRelayer","id":"method-createEventRelayer","meta":{"private":true}},{"owner":"Ext.Base","tagname":"method","name":"destroy","id":"method-destroy","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"doAddListener","id":"method-doAddListener","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"enableBubble","id":"method-enableBubble","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"execute","id":"method-execute","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"fireAction","id":"method-fireAction","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"fireEvent","id":"method-fireEvent","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"getApplication","id":"method-getApplication","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"getBefore","id":"method-getBefore","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"getBubbleEvents","id":"method-getBubbleEvents","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"getConfig","id":"method-getConfig","meta":{"private":true}},{"owner":"Ext.app.Controller","tagname":"method","name":"getControl","id":"method-getControl","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"getController","id":"method-getController","meta":{"deprecated":{"text":"2.0.0\nReturns a reference to another Controller. Deprecated and considered bad practice - if you need to do this\nplease use this.getApplication().getController() instead"}}},{"owner":"Ext.Base","tagname":"method","name":"getCurrentConfig","id":"method-getCurrentConfig","meta":{"private":true}},{"owner":"Ext.mixin.Identifiable","tagname":"method","name":"getId","id":"method-getId","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"getInitialConfig","id":"method-getInitialConfig","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"getListeners","id":"method-getListeners","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"getModel","id":"method-getModel","meta":{"deprecated":{"text":"2.0.0\nReturns a reference to a Model. Deprecated and considered bad practice - please just use the Model name instead\n(e.g. MyApp.model.User vs this.getModel('User'))."}}},{"owner":"Ext.app.Controller","tagname":"method","name":"getRef","id":"method-getRef","meta":{"private":true}},{"owner":"Ext.app.Controller","tagname":"method","name":"getRefs","id":"method-getRefs","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"getRoutes","id":"method-getRoutes","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"hasConfig","id":"method-hasConfig","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"hasListener","id":"method-hasListener","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"hasRef","id":"method-hasRef","meta":{"private":true}},{"owner":"Ext.Base","tagname":"method","name":"initConfig","id":"method-initConfig","meta":{"protected":true}},{"owner":"Ext.Base","tagname":"method","name":"onConfigUpdate","id":"method-onConfigUpdate","meta":{"private":true}},{"owner":"Ext.app.Controller","tagname":"method","name":"redirectTo","id":"method-redirectTo","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"ref","id":"method-ref","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"relayEvent","id":"method-relayEvent","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"relayEvents","id":"method-relayEvents","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"removeListener","id":"method-removeListener","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"resumeEvents","id":"method-resumeEvents","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"setApplication","id":"method-setApplication","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"setBefore","id":"method-setBefore","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"setBubbleEvents","id":"method-setBubbleEvents","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"setConfig","id":"method-setConfig","meta":{"private":true}},{"owner":"Ext.app.Controller","tagname":"method","name":"setControl","id":"method-setControl","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"setListeners","id":"method-setListeners","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"setRefs","id":"method-setRefs","meta":{}},{"owner":"Ext.app.Controller","tagname":"method","name":"setRoutes","id":"method-setRoutes","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"statics","id":"method-statics","meta":{"protected":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"suspendEvents","id":"method-suspendEvents","meta":{}}],"event":[],"property":[{"owner":"Ext.Base","tagname":"property","name":"self","id":"property-self","meta":{"protected":true}}]},"superclasses":["Ext.Base","Ext.app.Controller"],"html_meta":{"author":null},"private":false,"mixedInto":[],"name":"Ext.app.Controller","mixins":["Ext.mixin.Observable"],"inheritable":false,"subclasses":["Ext.app.Application"],"id":"class-Ext.app.Controller","html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><strong>Ext.app.Controller</strong></div></div><h4>Mixins</h4><div class='dependency'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='docClass'>Ext.mixin.Observable</a></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.app.Application' rel='Ext.app.Application' class='docClass'>Ext.app.Application</a></div><h4>Files</h4><div class='dependency'><a href='source/Controller2.html#Ext-app-Controller' target='_blank'>Controller.js</a></div></pre><div class='doc-contents'><p>Controllers are responsible for responding to events that occur within your app. If your app contains a Logout\n<a href=\"#!/api/Ext.Button\" rel=\"Ext.Button\" class=\"docClass\">button</a> that your user can tap on, a Controller would listen to the Button's tap event and take\nthe appropriate action. It allows the View classes to handle the display of data and the Model classes to handle the\nloading and saving of data - the Controller is the glue that binds them together.</p>\n\n<h2>Relation to <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a></h2>\n\n<p>Controllers exist within the context of an <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Application</a>. An Application usually consists\nof a number of Controllers, each of which handle a specific part of the app. For example, an Application that\nhandles the orders for an online shopping site might have controllers for Orders, Customers and Products.</p>\n\n<p>All of the Controllers that an Application uses are specified in the Application's\n<a href=\"#!/api/Ext.app.Application-cfg-controllers\" rel=\"Ext.app.Application-cfg-controllers\" class=\"docClass\">Ext.app.Application.controllers</a> config. The Application automatically instantiates each Controller and keeps\nreferences to each, so it is unusual to need to instantiate Controllers directly. By convention each Controller is\nnamed after the thing (usually the Model) that it deals with primarily, usually in the plural - for example if your\napp is called 'MyApp' and you have a Controller that manages Products, convention is to create a\nMyApp.controller.Products class in the file app/controller/Products.js.</p>\n\n<h2>Refs and Control</h2>\n\n<p>The centerpiece of Controllers is the twin configurations <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a> and <a href=\"#!/api/Ext.app.Controller-cfg-control\" rel=\"Ext.app.Controller-cfg-control\" class=\"docClass\">control</a>. These are used to\neasily gain references to Components inside your app and to take action on them based on events that they fire.\nLet's look at <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a> first:</p>\n\n<h3>Refs</h3>\n\n<p>Refs leverage the powerful <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> syntax to easily locate Components on your\npage. We can define as many refs as we like for each Controller, for example here we define a ref called 'nav' that\nfinds a Component on the page with the ID 'mainNav'. We then use that ref in the addLogoutButton beneath it:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Main', {\n    extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n    config: {\n        refs: {\n            nav: '#mainNav'\n        }\n    },\n\n    addLogoutButton: function() {\n        this.getNav().add({\n            text: 'Logout'\n        });\n    }\n});\n</code></pre>\n\n<p>Usually, a ref is just a key/value pair - the key ('nav' in this case) is the name of the reference that will be\ngenerated, the value ('#mainNav' in this case) is the <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selector that will\nbe used to find the Component.</p>\n\n<p>Underneath that, we have created a simple function called addLogoutButton which uses this ref via its generated\n'getNav' function. These getter functions are generated based on the refs you define and always follow the same\nformat - 'get' followed by the capitalized ref name. In this case we're treating the nav reference as though it's a\n<a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Toolbar</a>, and adding a Logout button to it when our function is called. This ref would recognize\na Toolbar like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Toolbar\" rel=\"Ext.Toolbar\" class=\"docClass\">Ext.Toolbar</a>', {\n    id: 'mainNav',\n\n    items: [\n        {\n            text: 'Some Button'\n        }\n    ]\n});\n</code></pre>\n\n<p>Assuming this Toolbar has already been created by the time we run our 'addLogoutButton' function (we'll see how that\nis invoked later), it will get the second button added to it.</p>\n\n<h3>Advanced Refs</h3>\n\n<p>Refs can also be passed a couple of additional options, beyond name and selector. These are autoCreate and xtype,\nwhich are almost always used together:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Main', {\n    extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n    config: {\n        refs: {\n            nav: '#mainNav',\n\n            infoPanel: {\n                selector: 'tabpanel panel[name=fish] infopanel',\n                xtype: 'infopanel',\n                autoCreate: true\n            }\n        }\n    }\n});\n</code></pre>\n\n<p>We've added a second ref to our Controller. Again the name is the key, 'infoPanel' in this case, but this time we've\npassed an object as the value instead. This time we've used a slightly more complex selector query - in this example\nimagine that your app contains a <a href=\"#!/api/Ext.tab.Panel\" rel=\"Ext.tab.Panel\" class=\"docClass\">tab panel</a> and that one of the items in the tab panel has been\ngiven the name 'fish'. Our selector matches any Component with the xtype 'infopanel' inside that tab panel item.</p>\n\n<p>The difference here is that if that infopanel does not exist already inside the 'fish' panel, it will be\nautomatically created when you call this.getInfoPanel inside your Controller. The Controller is able to do this\nbecause we provided the xtype to instantiate with in the event that the selector did not return anything.</p>\n\n<h3>Control</h3>\n\n<p>The sister config to <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a> is <a href=\"#!/api/Ext.app.Controller-cfg-control\" rel=\"Ext.app.Controller-cfg-control\" class=\"docClass\">control</a>. <a href=\"#!/api/Ext.app.Controller-cfg-control\" rel=\"Ext.app.Controller-cfg-control\" class=\"docClass\">Control</a> is the means by which your listen\nto events fired by Components and have your Controller react in some way. Control accepts both ComponentQuery\nselectors and refs as its keys, and listener objects as values - for example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Main', {\n    extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n    config: {\n        control: {\n            loginButton: {\n                tap: 'doLogin'\n            },\n            'button[action=logout]': {\n                tap: 'doLogout'\n            }\n        },\n\n        refs: {\n            loginButton: 'button[action=login]'\n        }\n    },\n\n    doLogin: function() {\n        //called whenever the Login button is tapped\n    },\n\n    doLogout: function() {\n        //called whenever any Button with action=logout is tapped\n    }\n});\n</code></pre>\n\n<p>Here we have set up two control declarations - one for our loginButton ref and the other for any Button on the page\nthat has been given the action 'logout'. For each declaration we passed in a single event handler - in each case\nlistening for the 'tap' event, specifying the action that should be called when that Button fires the tap event.\nNote that we specified the 'doLogin' and 'doLogout' methods as strings inside the control block - this is important.</p>\n\n<p>You can listen to as many events as you like in each control declaration, and mix and match ComponentQuery selectors\nand refs as the keys.</p>\n\n<h2>Routes</h2>\n\n<p>As of Sencha Touch 2, Controllers can now directly specify which routes they are interested in. This enables us to\nprovide history support within our app, as well as the ability to deeply link to any part of the application that we\nprovide a route for.</p>\n\n<p>For example, let's say we have a Controller responsible for logging in and viewing user profiles, and want to make\nthose screens accessible via urls. We could achieve that like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Users', {\n    extend: '<a href=\"#!/api/Ext.app.Controller\" rel=\"Ext.app.Controller\" class=\"docClass\">Ext.app.Controller</a>',\n\n    config: {\n        routes: {\n            'login': 'showLogin',\n            'user/:id': 'showUserById'\n        },\n\n        refs: {\n            main: '#mainTabPanel'\n        }\n    },\n\n    //uses our 'main' ref above to add a loginpanel to our main TabPanel (note that\n    //'loginpanel' is a custom xtype created for this application)\n    showLogin: function() {\n        this.getMain().add({\n            xtype: 'loginpanel'\n        });\n    },\n\n    //Loads the User then adds a 'userprofile' view to the main TabPanel\n    showUserById: function(id) {\n        MyApp.model.User.load(id, {\n            scope: this,\n            success: function(user) {\n                this.getMain().add({\n                    xtype: 'userprofile',\n                    user: user\n                });\n            }\n        });\n    }\n});\n</code></pre>\n\n<p>The routes we specified above simply map the contents of the browser address bar to a Controller function to call\nwhen that route is matched. The routes can be simple text like the login route, which matches against\nhttp://myapp.com/#login, or contain wildcards like the 'user/:id' route, which matches urls like\nhttp://myapp.com/#user/123. Whenever the address changes the Controller automatically calls the function specified.</p>\n\n<p>Note that in the showUserById function we had to first load the User instance. Whenever you use a route, the\nfunction that is called by that route is completely responsible for loading its data and restoring state. This is\nbecause your user could either send that url to another person or simply refresh the page, which we wipe clear any\ncached data you had already loaded. There is a more thorough discussion of restoring state with routes in the\napplication architecture guides.</p>\n\n<h2>Advanced Usage</h2>\n\n<p>See <a href=\"#!/guide/controllers\">the Controllers guide</a> for advanced Controller usage including before filters\nand customizing for different devices.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-application' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-application' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-cfg-application' class='name expandable'>application</a><span> : <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a></span></div><div class='description'><div class='short'>The Application instance this Controller is attached to. ...</div><div class='long'><p>The Application instance this Controller is attached to. This is\nautomatically provided when using the MVC architecture so should rarely need to be set directly.</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='cfg-before' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-before' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-cfg-before' class='name expandable'>before</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Provides a mapping of Controller functions to filter functions that are run before them\nwhen dispatched to from a route. ...</div><div class='long'><p>Provides a mapping of Controller functions to filter functions that are run before them\nwhen dispatched to from a route. These are usually used to run pre-processing functions like authentication\nbefore a certain function is executed. They are only called when dispatching from a route. Example usage:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.controller.Products', {\n    config: {\n        before: {\n            editProduct: 'authenticate'\n        },\n\n        routes: {\n            'product/edit/:id': 'editProduct'\n        }\n    },\n\n    //this is not directly because our before filter is called first\n    editProduct: function() {\n        //... performs the product editing logic\n    },\n\n    //this is run before editProduct\n    authenticate: function(action) {\n        MyApp.authenticate({\n            success: function() {\n                action.resume();\n            },\n            failure: function() {\n                <a href=\"#!/api/Ext.Msg-method-alert\" rel=\"Ext.Msg-method-alert\" class=\"docClass\">Ext.Msg.alert</a>('Not Logged In', \"You can't do that, you're not logged in\");\n            }\n        });\n    }\n});\n</code></pre>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='cfg-bubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-cfg-bubbleEvents' class='name expandable'>bubbleEvents</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'>The event name to bubble, or an Array of event names. ...</div><div class='long'><p>The event name to bubble, or an Array of event names.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-control' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-control' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-cfg-control' class='name expandable'>control</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Provides a mapping of Controller functions that should be called whenever certain\nComponent events are fired. ...</div><div class='long'><p>Provides a mapping of Controller functions that should be called whenever certain\nComponent events are fired. The Components can be specified using <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a>\nselectors or <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a>. Example usage:</p>\n\n<pre><code>control: {\n    'button[action=logout]': {\n        tap: 'doLogout'\n    },\n    main: {\n        activeitemchange: 'doUpdate'\n    }\n}\n</code></pre>\n\n<p>The first item uses a ComponentQuery selector to run the Controller's doLogout function whenever any Button\nwith action=logout is tapped on. The second calls the Controller's doUpdate function whenever the\nactiveitemchange event is fired by the Component referenced by our 'main' ref. In this case main is a tab\npanel (see <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a> for how to set that reference up).</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='cfg-init' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-init' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-cfg-init' class='name expandable'>init</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Called by the Controller's application to initialize the Controller. ...</div><div class='long'><p>Called by the Controller's <a href=\"#!/api/Ext.app.Controller-cfg-application\" rel=\"Ext.app.Controller-cfg-application\" class=\"docClass\">application</a> to initialize the Controller. This is always called before the\n<a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Application</a> launches, giving the Controller a chance to run any pre-launch logic.\nSee also <a href=\"#!/api/Ext.app.Controller-cfg-launch\" rel=\"Ext.app.Controller-cfg-launch\" class=\"docClass\">launch</a>, which is called after the <a href=\"#!/api/Ext.app.Application-cfg-launch\" rel=\"Ext.app.Application-cfg-launch\" class=\"docClass\">Application's launch function</a></p>\n</div></div></div><div id='cfg-launch' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-launch' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-cfg-launch' class='name expandable'>launch</a><span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span></div><div class='description'><div class='short'>Called by the Controller's application immediately after the Application's own\nlaunch function has been called. ...</div><div class='long'><p>Called by the Controller's <a href=\"#!/api/Ext.app.Controller-cfg-application\" rel=\"Ext.app.Controller-cfg-application\" class=\"docClass\">application</a> immediately after the Application's own\n<a href=\"#!/api/Ext.app.Application-cfg-launch\" rel=\"Ext.app.Application-cfg-launch\" class=\"docClass\">launch function</a> has been called. This is usually a good place to run any\nlogic that has to run after the app UI is initialized. See also <a href=\"#!/api/Ext.app.Controller-cfg-init\" rel=\"Ext.app.Controller-cfg-init\" class=\"docClass\">init</a>, which is called before the\n<a href=\"#!/api/Ext.app.Application-cfg-launch\" rel=\"Ext.app.Application-cfg-launch\" class=\"docClass\">Application's launch function</a>.</p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>A config object containing one or more event handlers to be added to this object during initialization. ...</div><div class='long'><p>A config object containing one or more event handlers to be added to this object during initialization. This\nshould be a valid listeners config object as specified in the <a href=\"#!/api/Ext.mixin.Observable-method-addListener\" rel=\"Ext.mixin.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching\nmultiple handlers at once.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-refs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-refs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-cfg-refs' class='name expandable'>refs</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>A collection of named ComponentQuery selectors that makes it\neasy to get references to key Components on your page. ...</div><div class='long'><p>A collection of named <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">ComponentQuery</a> selectors that makes it\neasy to get references to key Components on your page. Example usage:</p>\n\n<pre><code>refs: {\n    main: '#mainTabPanel',\n    loginButton: '#loginWindow button[action=login]',\n\n    infoPanel: {\n        selector: 'infopanel',\n        xtype: 'infopanel',\n        autoCreate: true\n    }\n}\n</code></pre>\n\n<p>The first two are simple ComponentQuery selectors, the third (infoPanel) also passes in the autoCreate and\nxtype options, which will first run the ComponentQuery to see if a Component matching that selector exists\non the page. If not, it will automatically create one using the xtype provided:</p>\n\n<pre><code>someControllerFunction: function() {\n    //if the info panel didn't exist before, calling its getter will instantiate\n    //it automatically and return the new instance\n    this.getInfoPanel().show();\n}\n</code></pre>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='cfg-routes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-routes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-cfg-routes' class='name expandable'>routes</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Provides a mapping of urls to Controller actions. ...</div><div class='long'><p>Provides a mapping of urls to Controller actions. Whenever the specified url is matched\nin the address bar, the specified Controller action is called. Example usage:</p>\n\n<pre><code>routes: {\n    'login': 'showLogin',\n    'users/:id': 'showUserById'\n}\n</code></pre>\n\n<p>The first route will match against http://myapp.com/#login and call the Controller's showLogin function. The\nsecond route contains a wildcard (':id') and will match all urls like http://myapp.com/#users/123, calling\nthe showUserById function with the matched ID as the first argument.</p>\n<p>Defaults to: <code>{}</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Properties</h3><div id='property-self' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-self' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependentOL on 'this'\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='static-property-S-onExtended' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-property-S-onExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-property-S-onExtended' class='name expandable'>$onExtended</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.app.Controller-method-constructor' class='name expandable'>Ext.app.Controller</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Constructs a new Controller instance ...</div><div class='long'><p>Constructs a new Controller instance</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for. May also be an object who's property names are\nevent names.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.  Will be called with arguments given to\n<a href=\"#!/api/Ext.mixin.Observable-method-fireEvent\" rel=\"Ext.mixin.Observable-method-fireEvent\" class=\"docClass\">fireEvent</a> plus the <code>options</code> parameter described below.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If\nomitted, defaults to the object which fired the event.</strong></p>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n\n<p>This object may contain any of the following properties:</p>\n\n<ul>\n<li><p><strong>scope</strong> : Object</p>\n\n<p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If omitted, defaults to the object\nwhich fired the event.</strong></p></li>\n<li><p><strong>delay</strong> : Number</p>\n\n<p>The number of milliseconds to delay the invocation of the handler after the event fires.</p></li>\n<li><p><strong>single</strong> : Boolean</p>\n\n<p>True to add a handler to handle just the next firing of the event, and then remove itself.</p></li>\n<li><p><strong>order</strong> : String</p>\n\n<p>The order of when the listener should be added into the listener queue.</p>\n\n<p>If you set an order of <code>before</code> and the event you are listening to is preventable, you can return <code>false</code> and it will stop the event.</p>\n\n<p>Available options are <code>before</code>, <code>current</code> and <code>after</code>. Defaults to <code>current</code>.</p></li>\n<li><p><strong>buffer</strong> : Number</p>\n\n<p>Causes the handler to be delayed by the specified number of milliseconds. If the event fires again within that\ntime, the original handler is <em>not</em> invoked, but the new handler is scheduled in its place.</p></li>\n<li><p><strong>delegate</strong> : String</p>\n\n<p>Uses <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> to delegate events to a specified query selector within this item.</p>\n\n<pre><code>// Create a container with a two children; a button and a toolbar\nvar container = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>', {\n    items: [\n        {\n           xtype: 'toolbar',\n           docked: 'top',\n           title: 'My Toolbar'\n        },\n        {\n           xtype: 'button',\n           text: 'My Button'\n        }\n    ]\n});\n\ncontainer.on({\n    // Ext.Buttons have an xtype of 'button', so we use that are a selector for our delegate\n    delegate: 'button',\n\n    tap: function() {\n        alert('Button tapped!');\n    }\n});\n</code></pre></li>\n</ul>\n\n\n<p><strong>Combining Options</strong></p>\n\n<p>Using the options argument, it is possible to combine different types of listeners:</p>\n\n<p>A delayed, one-time listener.</p>\n\n<pre><code>container.on('tap', this.handleTap, this, {\n    single: true,\n    delay: 100\n});\n</code></pre>\n\n<p><strong>Attaching multiple handlers in 1 call</strong></p>\n\n<p>The method also allows for a single argument to be passed which is a config object containing properties which\nspecify multiple events. For example:</p>\n\n<pre><code>container.on({\n    tap  : this.onTap,\n    swipe: this.onSwipe,\n\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n<p>One can also specify options for each event handler separately:</p>\n\n<pre><code>container.on({\n    tap  : { fn: this.onTap, scope: this, single: true },\n    swipe: { fn: button.onSwipe, scope: button }\n});\n</code></pre>\n</div></li></ul></div></div></div><div id='method-applyBefore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-applyBefore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-applyBefore' class='name expandable'>applyBefore</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> before</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Massages the before filters into an array of function references for each controller action ...</div><div class='long'><p>Massages the before filters into an array of function references for each controller action</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>before</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyControl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-applyControl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-applyControl' class='name expandable'>applyControl</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyRefs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-applyRefs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-applyRefs' class='name expandable'>applyRefs</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> refs</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>refs</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyRoutes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-applyRoutes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-applyRoutes' class='name expandable'>applyRoutes</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> routes</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Adds any routes specified in this Controller to the global Application router ...</div><div class='long'><p>Adds any routes specified in this Controller to the global Application router</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>routes</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-callOverridden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callOverridden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated signature'>deprecated</strong><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>as of 4.1. Use <a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a> instead.</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callOverridden(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Call the \"parent\" method of the current method. ...</div><div class='long'><p>Call the \"parent\" method of the current method. That is the method previously\noverridden by derivation or by an override (see <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>).</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Base', {\n     constructor: function (x) {\n         this.x = x;\n     },\n\n     statics: {\n         method: function (x) {\n             return x;\n         }\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived', {\n     extend: 'My.Base',\n\n     constructor: function () {\n         this.callParent([21]);\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // alerts 21\n</code></pre>\n\n<p>This can be used with an override as follows:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.DerivedOverride', {\n     override: 'My.Derived',\n\n     constructor: function (x) {\n         this.callParent([x*2]); // calls original My.Derived constructor\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // now alerts 42\n</code></pre>\n\n<p>This also works with static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2', {\n     extend: 'My.Base',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Base.method\n         }\n     }\n });\n\n alert(My.Base.method(10);     // alerts 10\n alert(My.Derived2.method(10); // alerts 20\n</code></pre>\n\n<p>Lastly, it also works with overridden static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2Override', {\n     override: 'My.Derived2',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Derived2.method\n         }\n     }\n });\n\n alert(My.Derived2.method(10); // now alerts 40\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the parent method</p>\n</div></li></ul></div></div></div><div id='method-changeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-changeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-changeListener' class='name expandable'>changeListener</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> operation, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eventName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> order</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>operation</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eventName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>order</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-clearListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-clearListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-clearListeners' class='name expandable'>clearListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object. ...</div><div class='long'><p>Removes all listeners for this object.</p>\n</div></div></div><div id='method-control' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-control' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-control' class='name expandable'>control</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> selectors</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>selectors</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createEventRelayer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-createEventRelayer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-createEventRelayer' class='name expandable'>createEventRelayer</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> newName</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Creates an event handling function which refires the event from this object as the passed event name. ...</div><div class='long'><p>Creates an event handling function which refires the event from this object as the passed event name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.Component-method-destroy' rel='Ext.Component-method-destroy' class='docClass'>Ext.Component.destroy</a></p></div></div></div><div id='method-doAddListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-doAddListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-doAddListener' class='name expandable'>doAddListener</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling this.getBubbleTarget() if\npresent. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling <code>this.getBubbleTarget()</code> if\npresent. There is no implementation in the Observable base class.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-execute' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-execute' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-execute' class='name expandable'>execute</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> action, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> skipFilters</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Executes an Ext.app.Action by giving it the correct before filters and kicking off execution ...</div><div class='long'><p>Executes an <a href=\"#!/api/Ext.app.Action\" rel=\"Ext.app.Action\" class=\"docClass\">Ext.app.Action</a> by giving it the correct before filters and kicking off execution</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>action</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>skipFilters</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-fireAction' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-fireAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-fireAction' class='name expandable'>fireAction</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> args, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )</div><div class='description'><div class='short'>Fires the specified event with the passed parameters and execute a function (action)\nat the end if there are no liste...</div><div class='long'><p>Fires the specified event with the passed parameters and execute a function (action)\nat the end if there are no listeners that return false.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Arguments to pass to handers</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Action</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>scope of fn</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... args</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name, plus the options object passed\nto addList...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name, plus the <code>options</code> object passed\nto <a href=\"#!/api/Ext.mixin.Observable-method-addListener\" rel=\"Ext.mixin.Observable-method-addListener\" class=\"docClass\">addListener</a>).</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy by calling <a href=\"#!/api/Ext.mixin.Observable-method-enableBubble\" rel=\"Ext.mixin.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-getApplication' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-application' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-getApplication' class='name expandable'>getApplication</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a></div><div class='description'><div class='short'>Returns the value of application. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-application\" rel=\"Ext.app.Controller-cfg-application\" class=\"docClass\">application</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getBefore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-before' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-getBefore' class='name expandable'>getBefore</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the value of before. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-before\" rel=\"Ext.app.Controller-cfg-before\" class=\"docClass\">before</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getBubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-getBubbleEvents' class='name expandable'>getBubbleEvents</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</div><div class='description'><div class='short'>Returns the value of bubbleEvents. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.mixin.Observable-cfg-bubbleEvents\" rel=\"Ext.mixin.Observable-cfg-bubbleEvents\" class=\"docClass\">bubbleEvents</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getConfig' class='name expandable'>getConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getControl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-control' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-getControl' class='name expandable'>getControl</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the value of control. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-control\" rel=\"Ext.app.Controller-cfg-control\" class=\"docClass\">control</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getController' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-getController' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-getController' class='name expandable'>getController</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> controllerName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> profile</span> )<strong class='deprecated signature'>deprecated</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>2.0.0\nReturns a reference to another Controller. Deprecated and considered bad practice - if you need to do this\nplease use this.getApplication().getController() instead</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>controllerName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>profile</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getCurrentConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getCurrentConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getCurrentConfig' class='name expandable'>getCurrentConfig</a>( <span class='pre'></span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Identifiable' rel='Ext.mixin.Identifiable' class='defined-in docClass'>Ext.mixin.Identifiable</a><br/><a href='source/Identifiable.html#Ext-mixin-Identifiable-method-getId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Identifiable-method-getId' class='name expandable'>getId</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Retrieves the id of this component. ...</div><div class='long'><p>Retrieves the id of this component. Will autogenerate an id if one has not already been set.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>id</p>\n</div></li></ul></div></div></div><div id='method-getInitialConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getInitialConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getInitialConfig' class='name expandable'>getInitialConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-getListeners' class='name expandable'>getListeners</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the value of listeners. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.mixin.Observable-cfg-listeners\" rel=\"Ext.mixin.Observable-cfg-listeners\" class=\"docClass\">listeners</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getModel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-getModel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-getModel' class='name expandable'>getModel</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> modelName</span> )<strong class='deprecated signature'>deprecated</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>2.0.0\nReturns a reference to a Model. Deprecated and considered bad practice - please just use the Model name instead\n(e.g. MyApp.model.User vs this.getModel('User')).</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>modelName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRef' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-getRef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-getRef' class='name expandable'>getRef</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> ref, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> info, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ref</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>info</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRefs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-refs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-getRefs' class='name expandable'>getRefs</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the value of refs. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getRoutes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-routes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-getRoutes' class='name expandable'>getRoutes</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the value of routes. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.app.Controller-cfg-routes\" rel=\"Ext.app.Controller-cfg-routes\" class=\"docClass\">routes</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-hasConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-hasConfig' class='name expandable'>hasConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-hasRef' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-hasRef' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-hasRef' class='name expandable'>hasRef</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> ref</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>ref</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-initConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> instanceConfig</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instanceConfig</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-onConfigUpdate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-onConfigUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-onConfigUpdate' class='name expandable'>onConfigUpdate</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> names, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> callback, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>names</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-redirectTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-redirectTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-redirectTo' class='name expandable'>redirectTo</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> place</span> )</div><div class='description'><div class='short'>Convenient way to redirect to a new url. ...</div><div class='long'><p>Convenient way to redirect to a new url. See <a href=\"#!/api/Ext.app.Application-method-redirectTo\" rel=\"Ext.app.Application-method-redirectTo\" class=\"docClass\">Ext.app.Application.redirectTo</a> for full usage information</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>place</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-ref' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-method-ref' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-ref' class='name expandable'>ref</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> refs</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>1.x-inspired ref implementation ...</div><div class='long'><p>1.x-inspired ref implementation</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>refs</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-relayEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-relayEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-relayEvent' class='name expandable'>relayEvent</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> args, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <code><b>this</b></code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <strong>This must be a reference to the function passed into the\n<a href=\"#!/api/Ext.mixin.Observable-method-addListener\" rel=\"Ext.mixin.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</strong></p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope originally specified for the handler. It must be the same as the\nscope argument specified in the original call to <a href=\"#!/api/Ext.mixin.Observable-method-addListener\" rel=\"Ext.mixin.Observable-method-addListener\" class=\"docClass\">addListener</a> or the listener will not be removed.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resumes firing events (see suspendEvents). ...</div><div class='long'><p>Resumes firing events (see <a href=\"#!/api/Ext.mixin.Observable-method-suspendEvents\" rel=\"Ext.mixin.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>).</p>\n\n<p>If events were suspended using the <code>queueSuspended</code> parameter, then all events fired\nduring event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setApplication' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-application' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-setApplication' class='name expandable'>setApplication</a>( <span class='pre'><a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a> application</span> )</div><div class='description'><div class='short'>Sets the value of application. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-application\" rel=\"Ext.app.Controller-cfg-application\" class=\"docClass\">application</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>application</span> : <a href=\"#!/api/Ext.app.Application\" rel=\"Ext.app.Application\" class=\"docClass\">Ext.app.Application</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setBefore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-before' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-setBefore' class='name expandable'>setBefore</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> before</span> )</div><div class='description'><div class='short'>Sets the value of before. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-before\" rel=\"Ext.app.Controller-cfg-before\" class=\"docClass\">before</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>before</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setBubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-setBubbleEvents' class='name expandable'>setBubbleEvents</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] bubbleEvents</span> )</div><div class='description'><div class='short'>Sets the value of bubbleEvents. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.mixin.Observable-cfg-bubbleEvents\" rel=\"Ext.mixin.Observable-cfg-bubbleEvents\" class=\"docClass\">bubbleEvents</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bubbleEvents</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-setConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-setConfig' class='name expandable'>setConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> applyIfNotSet</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>applyIfNotSet</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setControl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-control' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-setControl' class='name expandable'>setControl</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> control</span> )</div><div class='description'><div class='short'>Sets the value of control. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-control\" rel=\"Ext.app.Controller-cfg-control\" class=\"docClass\">control</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>control</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-setListeners' class='name expandable'>setListeners</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> listeners</span> )</div><div class='description'><div class='short'>Sets the value of listeners. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.mixin.Observable-cfg-listeners\" rel=\"Ext.mixin.Observable-cfg-listeners\" class=\"docClass\">listeners</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>listeners</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setRefs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-refs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-setRefs' class='name expandable'>setRefs</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> refs</span> )</div><div class='description'><div class='short'>Sets the value of refs. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-refs\" rel=\"Ext.app.Controller-cfg-refs\" class=\"docClass\">refs</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>refs</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setRoutes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.app.Controller'>Ext.app.Controller</span><br/><a href='source/Controller2.html#Ext-app-Controller-cfg-routes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.app.Controller-method-setRoutes' class='name expandable'>setRoutes</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> routes</span> )</div><div class='description'><div class='short'>Sets the value of routes. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.app.Controller-cfg-routes\" rel=\"Ext.app.Controller-cfg-routes\" class=\"docClass\">routes</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>routes</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-statics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> queueSuspended</span> )</div><div class='description'><div class='short'>Suspends the firing of all events. ...</div><div class='long'><p>Suspends the firing of all events. (see <a href=\"#!/api/Ext.mixin.Observable-method-resumeEvents\" rel=\"Ext.mixin.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.mixin.Observable-method-resumeEvents\" rel=\"Ext.mixin.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events.</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-addConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addConfig' class='name expandable'>addConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fullMerge</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fullMerge</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addInheritableStatics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addInheritableStatics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addInheritableStatics' class='name expandable'>addInheritableStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addMember' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addMember' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addMember' class='name expandable'>addMember</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> member</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>member</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addMembers' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addMembers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addMembers' class='name expandable'>addMembers</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static signature'>static</strong></div><div class='description'><div class='short'>Add methods / properties to the prototype of this class. ...</div><div class='long'><p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.implement({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addStatics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addStatics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addStatics' class='name expandable'>addStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static signature'>static</strong></div><div class='description'><div class='short'>Add / override static properties of this class. ...</div><div class='long'><p>Add / override static properties of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-addXtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addXtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addXtype' class='name expandable'>addXtype</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> xtype</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-borrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-borrow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-borrow' class='name expandable'>borrow</a>( <span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a> fromClass, <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Borrow another class' members to the prototype of this class. ...</div><div class='long'><p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromClass</span> : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><div class='sub-desc'><p>The class to borrow members from</p>\n</div></li><li><span class='pre'>members</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The names of the members to borrow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-callParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> args</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-create' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-create' class='name expandable'>create</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static signature'>static</strong></div><div class='description'><div class='short'>Create a new instance of this Class. ...</div><div class='long'><p>Create a new instance of this Class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the created instance.</p>\n</div></li></ul></div></div></div><div id='static-method-createAlias' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-createAlias' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-createAlias' class='name expandable'>createAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> alias, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> origin</span> )<strong class='static signature'>static</strong></div><div class='description'><div class='short'>Create aliases for existing prototype methods. ...</div><div class='long'><p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new method name, or an object to set multiple aliases. See\n<a href=\"#!/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n</div></li><li><span class='pre'>origin</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The original method name</p>\n</div></li></ul></div></div></div><div id='static-method-extend' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-extend' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-extend' class='name expandable'>extend</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> parent</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>parent</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-getName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static signature'>static</strong></div><div class='description'><div class='short'>Get the current class' name in string format. ...</div><div class='long'><p>Get the current class' name in string format.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='static-method-implement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-implement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-implement' class='name expandable'>implement</a>( <span class='pre'></span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='static-method-mixin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-mixin' class='name expandable'>mixin</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> mixinClass</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Used internally by the mixins pre-processor ...</div><div class='long'><p>Used internally by the mixins pre-processor</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>mixinClass</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-onExtended' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-onExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-onExtended' class='name expandable'>onExtended</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-override' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-override' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-override' class='name expandable'>override</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='deprecated signature'>deprecated</strong><strong class='static signature'>static</strong></div><div class='description'><div class='short'>Override members of this class. ...</div><div class='long'><p>Override members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a>.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n\n<p>As of 4.1, direct use of this method is deprecated. Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>\ninstead:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.CatOverride', {\n    override: 'My.Cat',\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n</code></pre>\n\n<p>The above accomplishes the same result but can be managed by the <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a>\nwhich can properly order the override and its target class and the build process\ncan determine whether the override is needed based on the required state of the\ntarget class (My.Cat).</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> since 4.1.0</p>\n        <p>Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a> instead</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The properties to add to this class. This should be\nspecified as an object literal containing one or more properties.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this class</p>\n</div></li></ul></div></div></div><div id='static-method-triggerExtended' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-triggerExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-triggerExtended' class='name expandable'>triggerExtended</a>( <span class='pre'></span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div></div></div></div></div>","allMixins":["Ext.mixin.Observable"],"requires":[],"meta":{"author":["Ed Spencer"]},"files":[{"href":"Controller2.html#Ext-app-Controller","filename":"Controller.js"}]});