Ext.data.JsonP.Ext_data_Model({"inheritdoc":null,"aliases":{},"extends":"Ext.Base","alternateClassNames":["Ext.data.Record"],"uses":[],"singleton":false,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[{"owner":"Ext.Base","tagname":"method","name":"addConfig","id":"static-method-addConfig","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"addInheritableStatics","id":"static-method-addInheritableStatics","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"addMember","id":"static-method-addMember","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"addMembers","id":"static-method-addMembers","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"addStatics","id":"static-method-addStatics","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"addXtype","id":"static-method-addXtype","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"borrow","id":"static-method-borrow","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"callParent","id":"static-method-callParent","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"create","id":"static-method-create","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"createAlias","id":"static-method-createAlias","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"extend","id":"static-method-extend","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"getName","id":"static-method-getName","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"implement","id":"static-method-implement","meta":{"static":true,"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"load","id":"static-method-load","meta":{"static":true}},{"owner":"Ext.Base","tagname":"method","name":"mixin","id":"static-method-mixin","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"onExtended","id":"static-method-onExtended","meta":{"static":true,"private":true}},{"owner":"Ext.Base","tagname":"method","name":"override","id":"static-method-override","meta":{"deprecated":{"version":"4.1.0","text":"Use {@link Ext#define Ext.define} instead"},"static":true}},{"owner":"Ext.Base","tagname":"method","name":"triggerExtended","id":"static-method-triggerExtended","meta":{"static":true,"private":true}}],"event":[],"property":[{"owner":"Ext.Base","tagname":"property","name":"$onExtended","id":"static-property-S-onExtended","meta":{"static":true,"private":true}}]},"component":false,"tagname":"class","code_type":"ext_define","members":{"css_var":[],"css_mixin":[],"cfg":[{"owner":"Ext.data.Model","tagname":"cfg","name":"associations","id":"cfg-associations","meta":{}},{"owner":"Ext.data.Model","tagname":"cfg","name":"belongsTo","id":"cfg-belongsTo","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"cfg","name":"bubbleEvents","id":"cfg-bubbleEvents","meta":{}},{"owner":"Ext.data.Model","tagname":"cfg","name":"clientIdProperty","id":"cfg-clientIdProperty","meta":{}},{"owner":"Ext.data.Model","tagname":"cfg","name":"fields","id":"cfg-fields","meta":{}},{"owner":"Ext.data.Model","tagname":"cfg","name":"hasMany","id":"cfg-hasMany","meta":{}},{"owner":"Ext.data.Model","tagname":"cfg","name":"hasOne","id":"cfg-hasOne","meta":{}},{"owner":"Ext.data.Model","tagname":"cfg","name":"idProperty","id":"cfg-idProperty","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"cfg","name":"listeners","id":"cfg-listeners","meta":{}},{"owner":"Ext.data.Model","tagname":"cfg","name":"proxy","id":"cfg-proxy","meta":{}},{"owner":"Ext.data.Model","tagname":"cfg","name":"validations","id":"cfg-validations","meta":{}}],"method":[{"owner":"Ext.data.Model","tagname":"method","name":"constructor","id":"method-constructor","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"addListener","id":"method-addListener","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"afterCommit","id":"method-afterCommit","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"afterEdit","id":"method-afterEdit","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"afterReject","id":"method-afterReject","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"beginEdit","id":"method-beginEdit","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"callOverridden","id":"method-callOverridden","meta":{"deprecated":{"text":"as of 4.1. Use {@link #callParent} instead."},"protected":true}},{"owner":"Ext.Base","tagname":"method","name":"callParent","id":"method-callParent","meta":{"protected":true}},{"owner":"Ext.data.Model","tagname":"method","name":"cancelEdit","id":"method-cancelEdit","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"changeListener","id":"method-changeListener","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"changedWhileEditing","id":"method-changedWhileEditing","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"clearListeners","id":"method-clearListeners","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"commit","id":"method-commit","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"copy","id":"method-copy","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"createEventRelayer","id":"method-createEventRelayer","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"destroy","id":"method-destroy","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"doAddListener","id":"method-doAddListener","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"enableBubble","id":"method-enableBubble","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"endEdit","id":"method-endEdit","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"erase","id":"method-erase","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"fireAction","id":"method-fireAction","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"fireEvent","id":"method-fireEvent","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"get","id":"method-get","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"getAssociatedData","id":"method-getAssociatedData","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"getBubbleEvents","id":"method-getBubbleEvents","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"getChanges","id":"method-getChanges","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"getClientIdProperty","id":"method-getClientIdProperty","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"getConfig","id":"method-getConfig","meta":{"private":true}},{"owner":"Ext.Base","tagname":"method","name":"getCurrentConfig","id":"method-getCurrentConfig","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"getData","id":"method-getData","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"getFieldName","id":"method-getFieldName","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"getFields","id":"method-getFields","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"getId","id":"method-getId","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"getInitialConfig","id":"method-getInitialConfig","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"getIsErased","id":"method-getIsErased","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"getListeners","id":"method-getListeners","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"getProxy","id":"method-getProxy","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"hasConfig","id":"method-hasConfig","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"hasListener","id":"method-hasListener","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"initConfig","id":"method-initConfig","meta":{"protected":true}},{"owner":"Ext.data.Model","tagname":"method","name":"isEqual","id":"method-isEqual","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"isModified","id":"method-isModified","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"isValid","id":"method-isValid","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"join","id":"method-join","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"mergeData","id":"method-mergeData","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"notifyStores","id":"method-notifyStores","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"onClassExtended","id":"method-onClassExtended","meta":{"private":true}},{"owner":"Ext.Base","tagname":"method","name":"onConfigUpdate","id":"method-onConfigUpdate","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"prepareAssociatedData","id":"method-prepareAssociatedData","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"reject","id":"method-reject","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"relayEvent","id":"method-relayEvent","meta":{"private":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"relayEvents","id":"method-relayEvents","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"removeListener","id":"method-removeListener","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"resumeEvents","id":"method-resumeEvents","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"save","id":"method-save","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"set","id":"method-set","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"setBubbleEvents","id":"method-setBubbleEvents","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"setClientIdProperty","id":"method-setClientIdProperty","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"setConfig","id":"method-setConfig","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"setConvertedData","id":"method-setConvertedData","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"setData","id":"method-setData","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"setDirty","id":"method-setDirty","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"setFields","id":"method-setFields","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"setId","id":"method-setId","meta":{}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"setListeners","id":"method-setListeners","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"setProxy","id":"method-setProxy","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"sortConvertFields","id":"method-sortConvertFields","meta":{"private":true}},{"owner":"Ext.Base","tagname":"method","name":"statics","id":"method-statics","meta":{"protected":true}},{"owner":"Ext.mixin.Observable","tagname":"method","name":"suspendEvents","id":"method-suspendEvents","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"toUrl","id":"method-toUrl","meta":{}},{"owner":"Ext.data.Model","tagname":"method","name":"unjoin","id":"method-unjoin","meta":{"private":true}},{"owner":"Ext.data.Model","tagname":"method","name":"validate","id":"method-validate","meta":{}}],"event":[],"property":[{"owner":"Ext.data.Model","tagname":"property","name":"associations","id":"property-associations","meta":{}},{"owner":"Ext.data.Model","tagname":"property","name":"dirty","id":"property-dirty","meta":{}},{"owner":"Ext.data.Model","tagname":"property","name":"editing","id":"property-editing","meta":{}},{"owner":"Ext.data.Model","tagname":"property","name":"fields","id":"property-fields","meta":{}},{"owner":"Ext.data.Model","tagname":"property","name":"modified","id":"property-modified","meta":{}},{"owner":"Ext.data.Model","tagname":"property","name":"phantom","id":"property-phantom","meta":{}},{"owner":"Ext.data.Model","tagname":"property","name":"raw","id":"property-raw","meta":{}},{"owner":"Ext.Base","tagname":"property","name":"self","id":"property-self","meta":{"protected":true}},{"owner":"Ext.data.Model","tagname":"property","name":"stores","id":"property-stores","meta":{}},{"owner":"Ext.data.Model","tagname":"property","name":"validations","id":"property-validations","meta":{}}]},"superclasses":["Ext.Base","Ext.data.Model"],"html_meta":{"author":null},"private":false,"mixedInto":[],"name":"Ext.data.Model","mixins":["Ext.mixin.Observable"],"inheritable":false,"subclasses":[],"id":"class-Ext.data.Model","html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>Ext.data.Record</div><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><strong>Ext.data.Model</strong></div></div><h4>Mixins</h4><div class='dependency'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='docClass'>Ext.mixin.Observable</a></div><h4>Requires</h4><div class='dependency'><a href='#!/api/Ext.data.Errors' rel='Ext.data.Errors' class='docClass'>Ext.data.Errors</a></div><div class='dependency'><a href='#!/api/Ext.data.Field' rel='Ext.data.Field' class='docClass'>Ext.data.Field</a></div><div class='dependency'><a href='#!/api/Ext.data.ModelManager' rel='Ext.data.ModelManager' class='docClass'>Ext.data.ModelManager</a></div><div class='dependency'><a href='#!/api/Ext.data.association.BelongsTo' rel='Ext.data.association.BelongsTo' class='docClass'>Ext.data.association.BelongsTo</a></div><div class='dependency'><a href='#!/api/Ext.data.association.HasMany' rel='Ext.data.association.HasMany' class='docClass'>Ext.data.association.HasMany</a></div><div class='dependency'><a href='#!/api/Ext.data.association.HasOne' rel='Ext.data.association.HasOne' class='docClass'>Ext.data.association.HasOne</a></div><div class='dependency'><a href='#!/api/Ext.data.identifier.Simple' rel='Ext.data.identifier.Simple' class='docClass'>Ext.data.identifier.Simple</a></div><div class='dependency'><a href='#!/api/Ext.data.proxy.Ajax' rel='Ext.data.proxy.Ajax' class='docClass'>Ext.data.proxy.Ajax</a></div><div class='dependency'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='docClass'>Ext.util.Collection</a></div><h4>Files</h4><div class='dependency'><a href='source/Model.html#Ext-data-Model' target='_blank'>Model.js</a></div></pre><div class='doc-contents'><p>A Model represents some object that your application manages. For example, one might define a Model for Users,\nProducts, Cars, or any other real-world object that we want to model in the system. Models are registered via the\n<a href=\"#!/api/Ext.data.ModelManager\" rel=\"Ext.data.ModelManager\" class=\"docClass\">model manager</a>, and are used by <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">stores</a>, which are in turn used by many\nof the data-bound components in Ext.</p>\n\n<p>Models are defined as a set of fields and any arbitrary methods and properties relevant to the model. For example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n\n    config: {\n        fields: [\n            {name: 'name',  type: 'string'},\n            {name: 'age',   type: 'int'},\n            {name: 'phone', type: 'string'},\n            {name: 'alive', type: 'boolean', defaultValue: true}\n        ]\n    },\n\n    changeName: function() {\n        var oldName = this.get('name'),\n            newName = oldName + \" The Barbarian\";\n\n        this.set('name', newName);\n    }\n});\n</code></pre>\n\n<p>The fields array is turned into a <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">MixedCollection</a> automatically by the <a href=\"#!/api/Ext.data.ModelManager\" rel=\"Ext.data.ModelManager\" class=\"docClass\">ModelManager</a>, and all other functions and properties are copied to the new Model's prototype.</p>\n\n<p>Now we can create instances of our User model and call any model logic we defined:</p>\n\n<pre><code>var user = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {\n    name : 'Conan',\n    age  : 24,\n    phone: '555-555-5555'\n});\n\nuser.changeName();\nuser.get('name'); //returns \"Conan The Barbarian\"\n</code></pre>\n\n<h1>Validations</h1>\n\n<p>Models have built-in support for validations, which are executed against the validator functions in <a href=\"#!/api/Ext.data.Validations\" rel=\"Ext.data.Validations\" class=\"docClass\">Ext.data.validations</a> (<a href=\"#!/api/Ext.data.Validations\" rel=\"Ext.data.Validations\" class=\"docClass\">see all validation functions</a>). Validations are easy to add to\nmodels:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n\n    config: {\n        fields: [\n            {name: 'name',     type: 'string'},\n            {name: 'age',      type: 'int'},\n            {name: 'phone',    type: 'string'},\n            {name: 'gender',   type: 'string'},\n            {name: 'username', type: 'string'},\n            {name: 'alive',    type: 'boolean', defaultValue: true}\n        ],\n\n        validations: [\n            {type: 'presence',  field: 'age'},\n            {type: 'length',    field: 'name',     min: 2},\n            {type: 'inclusion', field: 'gender',   list: ['Male', 'Female']},\n            {type: 'exclusion', field: 'username', list: ['Admin', 'Operator']},\n            {type: 'format',    field: 'username', matcher: /([a-z]+)[0-9]{2,3}/}\n        ]\n    }\n});\n</code></pre>\n\n<p>The validations can be run by simply calling the <a href=\"#!/api/Ext.data.Model-method-validate\" rel=\"Ext.data.Model-method-validate\" class=\"docClass\">validate</a> function, which returns a <a href=\"#!/api/Ext.data.Errors\" rel=\"Ext.data.Errors\" class=\"docClass\">Ext.data.Errors</a>\nobject:</p>\n\n<pre><code>var instance = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {\n    name: 'Ed',\n    gender: 'Male',\n    username: 'edspencer'\n});\n\nvar errors = instance.validate();\n</code></pre>\n\n<h1>Associations</h1>\n\n<p>Models can have associations with other Models via <a href=\"#!/api/Ext.data.association.HasOne\" rel=\"Ext.data.association.HasOne\" class=\"docClass\">Ext.data.association.HasOne</a>,\n<a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">belongsTo</a> and <a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">hasMany</a> associations.\nFor example, let's say we're writing a blog administration application which deals with Users, Posts and Comments.\nWe can express the relationships between these models like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Post', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n\n    config: {\n        fields: ['id', 'user_id'],\n        belongsTo: 'User',\n        hasMany  : {model: 'Comment', name: 'comments'}\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Comment', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n\n    config: {\n        fields: ['id', 'user_id', 'post_id'],\n        belongsTo: 'Post'\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n\n    config: {\n        fields: ['id'],\n        hasMany: [\n            'Post',\n            {model: 'Comment', name: 'comments'}\n        ]\n    }\n});\n</code></pre>\n\n<p>See the docs for <a href=\"#!/api/Ext.data.association.HasOne\" rel=\"Ext.data.association.HasOne\" class=\"docClass\">Ext.data.association.HasOne</a>, <a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">Ext.data.association.BelongsTo</a> and\n<a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">Ext.data.association.HasMany</a> for details on the usage and configuration of associations.\nNote that associations can also be specified like this:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n\n    config: {\n        fields: ['id'],\n        associations: [\n            {type: 'hasMany', model: 'Post',    name: 'posts'},\n            {type: 'hasMany', model: 'Comment', name: 'comments'}\n        ]\n    }\n});\n</code></pre>\n\n<h1>Using a Proxy</h1>\n\n<p>Models are great for representing types of data and relationships, but sooner or later we're going to want to load or\nsave that data somewhere. All loading and saving of data is handled via a <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Proxy</a>, which\ncan be set directly on the Model:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n\n    config: {\n        fields: ['id', 'name', 'email'],\n        proxy: {\n            type: 'rest',\n            url : '/users'\n        }\n    }\n});\n</code></pre>\n\n<p>Here we've set up a <a href=\"#!/api/Ext.data.proxy.Rest\" rel=\"Ext.data.proxy.Rest\" class=\"docClass\">Rest Proxy</a>, which knows how to load and save data to and from a\nRESTful backend. Let's see how this works:</p>\n\n<pre><code>var user = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {name: 'Ed Spencer', email: 'ed@sencha.com'});\n\nuser.save(); //POST /users\n</code></pre>\n\n<p>Calling <a href=\"#!/api/Ext.data.Model-method-save\" rel=\"Ext.data.Model-method-save\" class=\"docClass\">save</a> on the new Model instance tells the configured RestProxy that we wish to persist this Model's\ndata onto our server. RestProxy figures out that this Model hasn't been saved before because it doesn't have an id,\nand performs the appropriate action - in this case issuing a POST request to the url we configured (/users). We\nconfigure any Proxy on any Model and always follow this API - see <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Ext.data.proxy.Proxy</a> for a full list.</p>\n\n<p>Loading data via the Proxy is equally easy:</p>\n\n<pre><code>//get a reference to the User model class\nvar User = <a href=\"#!/api/Ext.data.ModelManager-method-getModel\" rel=\"Ext.data.ModelManager-method-getModel\" class=\"docClass\">Ext.ModelManager.getModel</a>('User');\n\n//Uses the configured RestProxy to make a GET request to /users/123\nUser.load(123, {\n    success: function(user) {\n        console.log(user.getId()); //logs 123\n    }\n});\n</code></pre>\n\n<p>Models can also be updated and destroyed easily:</p>\n\n<pre><code>//the user Model we loaded in the last snippet:\nuser.set('name', 'Edward Spencer');\n\n//tells the Proxy to save the Model. In this case it will perform a PUT request to /users/123 as this Model already has an id\nuser.save({\n    success: function() {\n        console.log('The User was updated');\n    }\n});\n\n//tells the Proxy to destroy the Model. Performs a DELETE request to /users/123\nuser.destroy({\n    success: function() {\n        console.log('The User was destroyed!');\n    }\n});\n</code></pre>\n\n<h1>Usage in Stores</h1>\n\n<p>It is very common to want to load a set of Model instances to be displayed and manipulated in the UI. We do this by\ncreating a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>:</p>\n\n<pre><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'User'\n});\n\n//uses the Proxy we set up on Model to load the Store data\nstore.load();\n</code></pre>\n\n<p>A Store is just a collection of Model instances - usually loaded from a server somewhere. Store can also maintain a\nset of added, updated and removed Model instances to be synchronized with the server via the Proxy. See the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store docs</a> for more information on Stores.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-associations' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-associations' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-associations' class='name expandable'>associations</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'>An array of associations for this model. ...</div><div class='long'><p>An array of <a href=\"#!/api/Ext.data.association.Association\" rel=\"Ext.data.association.Association\" class=\"docClass\">associations</a> for this model.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-belongsTo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-belongsTo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-belongsTo' class='name expandable'>belongsTo</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'>One or more BelongsTo associations for this model. ...</div><div class='long'><p>One or more <a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">BelongsTo associations</a> for this model.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-bubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-cfg-bubbleEvents' class='name expandable'>bubbleEvents</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'>The event name to bubble, or an Array of event names. ...</div><div class='long'><p>The event name to bubble, or an Array of event names.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-clientIdProperty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-clientIdProperty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-clientIdProperty' class='name expandable'>clientIdProperty</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of a property that is used for submitting this Model's unique client-side identifier\nto the server when mult...</div><div class='long'><p>The name of a property that is used for submitting this Model's unique client-side identifier\nto the server when multiple phantom records are saved as part of the same <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Operation</a>.\nIn such a case, the server response should include the client id for each record\nso that the server response data can be used to update the client-side records if necessary.\nThis property cannot have the same name as any of this Model's fields.\nDefaults to 'clientId'.</p>\n<p>Defaults to: <code>&quot;clientId&quot;</code></p></div></div></div><div id='cfg-fields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-fields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-fields' class='name expandable'>fields</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span></div><div class='description'><div class='short'>The field definitions for all instances of this Model. ...</div><div class='long'><p>The field definitions for all instances of this Model. <strong>Note:</strong> this does not set the <em>values</em> of each\nfield on an instance, it sets the collection of fields itself. Sample usage:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('MyApp.model.User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n\n    config: {\n        fields: [\n            'id',\n            {name: 'age', type: 'int'},\n            {name: 'taxRate', type: 'float'}\n        ]\n    }\n});\n</code></pre>\n</div></div></div><div id='cfg-hasMany' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-hasMany' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-hasMany' class='name expandable'>hasMany</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'>One or more HasMany associations for this model. ...</div><div class='long'><p>One or more <a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">HasMany associations</a> for this model.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-hasOne' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-hasOne' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-hasOne' class='name expandable'>hasOne</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'>One or more HasOne associations for this model. ...</div><div class='long'><p>One or more <a href=\"#!/api/Ext.data.association.HasOne\" rel=\"Ext.data.association.HasOne\" class=\"docClass\">HasOne associations</a> for this model.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-idProperty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-idProperty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-idProperty' class='name expandable'>idProperty</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the field treated as this Model's unique id. ...</div><div class='long'><p>The name of the field treated as this Model's unique id. Defaults to 'id'. Note that this field\nneeds to have a type of 'auto'. Setting the field type to anything else will be undone by the\nframework. This is because new records that are created without an id, will have one generated.\nThis generated id is a string.</p>\n<p>Defaults to: <code>&quot;id&quot;</code></p></div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>A config object containing one or more event handlers to be added to this object during initialization. ...</div><div class='long'><p>A config object containing one or more event handlers to be added to this object during initialization. This\nshould be a valid listeners config object as specified in the <a href=\"#!/api/Ext.mixin.Observable-method-addListener\" rel=\"Ext.mixin.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching\nmultiple handlers at once.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-proxy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-proxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-proxy' class='name expandable'>proxy</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Ext.data.Proxy</a></span></div><div class='description'><div class='short'>The string type of the default Model Proxy. ...</div><div class='long'><p>The string type of the default Model Proxy. Defaults to null.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-validations' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-validations' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-cfg-validations' class='name expandable'>validations</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'>An array of validations for this model. ...</div><div class='long'><p>An array of <a href=\"#!/api/Ext.data.Validations\" rel=\"Ext.data.Validations\" class=\"docClass\">validations</a> for this model.</p>\n<p>Defaults to: <code>null</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Properties</h3><div id='property-associations' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-associations' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-associations' class='name not-expandable'>associations</a><span> : <a href=\"#!/api/Ext.util.Collection\" rel=\"Ext.util.Collection\" class=\"docClass\">Ext.util.Collection</a></span></div><div class='description'><div class='short'><p>The associations defined on this model.</p>\n</div><div class='long'><p>The associations defined on this model.</p>\n</div></div></div><div id='property-dirty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-dirty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-dirty' class='name expandable'>dirty</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True if this Record has been modified. ...</div><div class='long'><p>True if this Record has been modified. Read-only.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-editing' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-editing' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-editing' class='name expandable'>editing</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>Internal flag used to track whether or not the model instance is currently being edited. ...</div><div class='long'><p>Internal flag used to track whether or not the model instance is currently being edited. Read-only.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-fields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-fields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-fields' class='name not-expandable'>fields</a><span> : <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></span></div><div class='description'><div class='short'><p>The fields defined on this model.</p>\n</div><div class='long'><p>The fields defined on this model.</p>\n</div></div></div><div id='property-modified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-modified' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-modified' class='name expandable'>modified</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>key/value pairs of all fields whose values have changed. ...</div><div class='long'><p>key/value pairs of all fields whose values have changed.\nThe value is the original value for the field.</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-phantom' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-phantom' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-phantom' class='name expandable'>phantom</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True when the record does not yet exist in a server-side database (see setDirty). ...</div><div class='long'><p>True when the record does not yet exist in a server-side database (see <a href=\"#!/api/Ext.data.Model-method-setDirty\" rel=\"Ext.data.Model-method-setDirty\" class=\"docClass\">setDirty</a>).\nAny record which has a real database pk set as its id property is NOT a phantom -- it's real.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='property-raw' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-raw' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-raw' class='name not-expandable'>raw</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'><p>The raw data used to create this model if created via a reader.</p>\n</div><div class='long'><p>The raw data used to create this model if created via a reader.</p>\n</div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-self' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependentOL on 'this'\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div><div id='property-stores' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-stores' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-stores' class='name expandable'>stores</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array of Ext.data.Store objects that this record is bound to. ...</div><div class='long'><p>An array of <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> objects that this record is bound to.</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-validations' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-property-validations' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-property-validations' class='name not-expandable'>validations</a><span> : <a href=\"#!/api/Ext.util.Collection\" rel=\"Ext.util.Collection\" class=\"docClass\">Ext.util.Collection</a></span></div><div class='description'><div class='short'><p>The validations defined on this model.</p>\n</div><div class='long'><p>The validations defined on this model.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Properties</h3><div id='static-property-S-onExtended' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-property-S-onExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-property-S-onExtended' class='name expandable'>$onExtended</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.Model-method-constructor' class='name expandable'>Ext.data.Model</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> data, [<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> id]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates new Model instance. ...</div><div class='long'><p>Creates new Model instance.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>An object containing keys corresponding to this model's fields, and their associated values</p>\n</div></li><li><span class='pre'>id</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> (optional)<div class='sub-desc'><p>Unique ID to assign to this model instance</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope], [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for. May also be an object who's property names are\nevent names.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.  Will be called with arguments given to\n<a href=\"#!/api/Ext.mixin.Observable-method-fireEvent\" rel=\"Ext.mixin.Observable-method-fireEvent\" class=\"docClass\">fireEvent</a> plus the <code>options</code> parameter described below.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If\nomitted, defaults to the object which fired the event.</strong></p>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n\n<p>This object may contain any of the following properties:</p>\n\n<ul>\n<li><p><strong>scope</strong> : Object</p>\n\n<p>The scope (<code>this</code> reference) in which the handler function is executed. <strong>If omitted, defaults to the object\nwhich fired the event.</strong></p></li>\n<li><p><strong>delay</strong> : Number</p>\n\n<p>The number of milliseconds to delay the invocation of the handler after the event fires.</p></li>\n<li><p><strong>single</strong> : Boolean</p>\n\n<p>True to add a handler to handle just the next firing of the event, and then remove itself.</p></li>\n<li><p><strong>order</strong> : String</p>\n\n<p>The order of when the listener should be added into the listener queue.</p>\n\n<p>If you set an order of <code>before</code> and the event you are listening to is preventable, you can return <code>false</code> and it will stop the event.</p>\n\n<p>Available options are <code>before</code>, <code>current</code> and <code>after</code>. Defaults to <code>current</code>.</p></li>\n<li><p><strong>buffer</strong> : Number</p>\n\n<p>Causes the handler to be delayed by the specified number of milliseconds. If the event fires again within that\ntime, the original handler is <em>not</em> invoked, but the new handler is scheduled in its place.</p></li>\n<li><p><strong>delegate</strong> : String</p>\n\n<p>Uses <a href=\"#!/api/Ext.ComponentQuery\" rel=\"Ext.ComponentQuery\" class=\"docClass\">Ext.ComponentQuery</a> to delegate events to a specified query selector within this item.</p>\n\n<pre><code>// Create a container with a two children; a button and a toolbar\nvar container = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.Container\" rel=\"Ext.Container\" class=\"docClass\">Ext.Container</a>', {\n    items: [\n        {\n           xtype: 'toolbar',\n           docked: 'top',\n           title: 'My Toolbar'\n        },\n        {\n           xtype: 'button',\n           text: 'My Button'\n        }\n    ]\n});\n\ncontainer.on({\n    // Ext.Buttons have an xtype of 'button', so we use that are a selector for our delegate\n    delegate: 'button',\n\n    tap: function() {\n        alert('Button tapped!');\n    }\n});\n</code></pre></li>\n</ul>\n\n\n<p><strong>Combining Options</strong></p>\n\n<p>Using the options argument, it is possible to combine different types of listeners:</p>\n\n<p>A delayed, one-time listener.</p>\n\n<pre><code>container.on('tap', this.handleTap, this, {\n    single: true,\n    delay: 100\n});\n</code></pre>\n\n<p><strong>Attaching multiple handlers in 1 call</strong></p>\n\n<p>The method also allows for a single argument to be passed which is a config object containing properties which\nspecify multiple events. For example:</p>\n\n<pre><code>container.on({\n    tap  : this.onTap,\n    swipe: this.onSwipe,\n\n    scope: this // Important. Ensure \"this\" is correct during handler execution\n});\n</code></pre>\n\n<p>One can also specify options for each event handler separately:</p>\n\n<pre><code>container.on({\n    tap  : { fn: this.onTap, scope: this, single: true },\n    swipe: { fn: button.onSwipe, scope: button }\n});\n</code></pre>\n</div></li></ul></div></div></div><div id='method-afterCommit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-afterCommit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-afterCommit' class='name expandable'>afterCommit</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> modified</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>If this Model instance has been joined to a store, the store's\nafterCommit method is called ...</div><div class='long'><p>If this Model instance has been <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">joined</a> to a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a>, the store's\nafterCommit method is called</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>modified</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-afterEdit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-afterEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-afterEdit' class='name expandable'>afterEdit</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] modifiedFieldNames</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>If this Model instance has been joined to a store, the store's\nafterEdit method is called ...</div><div class='long'><p>If this Model instance has been <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">joined</a> to a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a>, the store's\nafterEdit method is called</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>modifiedFieldNames</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>Array of field names changed during edit.</p>\n</div></li></ul></div></div></div><div id='method-afterReject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-afterReject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-afterReject' class='name expandable'>afterReject</a>( <span class='pre'></span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>If this Model instance has been joined to a store, the store's\nafterReject method is called ...</div><div class='long'><p>If this Model instance has been <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">joined</a> to a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a>, the store's\nafterReject method is called</p>\n</div></div></div><div id='method-beginEdit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-beginEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-beginEdit' class='name expandable'>beginEdit</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Begins an edit. ...</div><div class='long'><p>Begins an edit. While in edit mode, no events (e.g.. the <code>update</code> event) are relayed to the containing store.\nWhen an edit has begun, it must be followed by either <a href=\"#!/api/Ext.data.Model-method-endEdit\" rel=\"Ext.data.Model-method-endEdit\" class=\"docClass\">endEdit</a> or <a href=\"#!/api/Ext.data.Model-method-cancelEdit\" rel=\"Ext.data.Model-method-cancelEdit\" class=\"docClass\">cancelEdit</a>.</p>\n</div></div></div><div id='method-callOverridden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callOverridden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated signature'>deprecated</strong><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>as of 4.1. Use <a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a> instead.</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callOverridden(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Call the \"parent\" method of the current method. ...</div><div class='long'><p>Call the \"parent\" method of the current method. That is the method previously\noverridden by derivation or by an override (see <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>).</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Base', {\n     constructor: function (x) {\n         this.x = x;\n     },\n\n     statics: {\n         method: function (x) {\n             return x;\n         }\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived', {\n     extend: 'My.Base',\n\n     constructor: function () {\n         this.callParent([21]);\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // alerts 21\n</code></pre>\n\n<p>This can be used with an override as follows:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.DerivedOverride', {\n     override: 'My.Derived',\n\n     constructor: function (x) {\n         this.callParent([x*2]); // calls original My.Derived constructor\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // now alerts 42\n</code></pre>\n\n<p>This also works with static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2', {\n     extend: 'My.Base',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Base.method\n         }\n     }\n });\n\n alert(My.Base.method(10);     // alerts 10\n alert(My.Derived2.method(10); // alerts 20\n</code></pre>\n\n<p>Lastly, it also works with overridden static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2Override', {\n     override: 'My.Derived2',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Derived2.method\n         }\n     }\n });\n\n alert(My.Derived2.method(10); // now alerts 40\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the parent method</p>\n</div></li></ul></div></div></div><div id='method-cancelEdit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-cancelEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-cancelEdit' class='name expandable'>cancelEdit</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Cancels all changes made in the current edit operation. ...</div><div class='long'><p>Cancels all changes made in the current edit operation.</p>\n</div></div></div><div id='method-changeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-changeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-changeListener' class='name expandable'>changeListener</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> operation, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> eventName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> order</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>operation</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>eventName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>order</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-changedWhileEditing' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-changedWhileEditing' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-changedWhileEditing' class='name expandable'>changedWhileEditing</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Checks if the underlying data has changed during an edit. ...</div><div class='long'><p>Checks if the underlying data has changed during an edit. This doesn't necessarily\nmean the record is dirty, however we still need to notify the store since it may need\nto update any views.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the underlying data has changed during an edit.</p>\n</div></li></ul></div></div></div><div id='method-clearListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-clearListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-clearListeners' class='name expandable'>clearListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object. ...</div><div class='long'><p>Removes all listeners for this object.</p>\n</div></div></div><div id='method-commit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-commit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-commit' class='name expandable'>commit</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> silent]</span> )</div><div class='description'><div class='short'>Usually called by the Ext.data.Store which owns the model instance. ...</div><div class='long'><p>Usually called by the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> which owns the model instance. Commits all changes made to the\ninstance since either creation or the last commit operation.</p>\n\n<p>Developers should subscribe to the <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Ext.data.Store.update</a> event to have their code notified of commit\noperations.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to skip notification of the owning store of the change.\nDefaults to false.</p>\n</div></li></ul></div></div></div><div id='method-copy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-copy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-copy' class='name expandable'>copy</a>( <span class='pre'>[<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id]</span> ) : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></div><div class='description'><div class='short'>Creates a copy (clone) of this Model instance. ...</div><div class='long'><p>Creates a copy (clone) of this Model instance.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>A new id, defaults to the id of the instance being copied.\nTo generate a phantom instance with a new id use:</p>\n\n<pre><code>var rec = record.copy(); // clone the record\nExt.data.Model.id(rec); // automatically generate a unique sequential id\n</code></pre>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createEventRelayer' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-createEventRelayer' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-createEventRelayer' class='name expandable'>createEventRelayer</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> newName</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Creates an event handling function which refires the event from this object as the passed event name. ...</div><div class='long'><p>Creates an event handling function which refires the event from this object as the passed event name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newName</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Destroys this model instance. ...</div><div class='long'><p>Destroys this model instance. Note that this doesn't do a 'destroy' operation. If you want to destroy\nthe record in your localstorage or on the server you should use the <a href=\"#!/api/Ext.data.Model-method-erase\" rel=\"Ext.data.Model-method-erase\" class=\"docClass\">erase</a> method.</p>\n<p>Overrides: <a href='#!/api/Ext.Base-method-destroy' rel='Ext.Base-method-destroy' class='docClass'>Ext.Base.destroy</a></p></div></div></div><div id='method-doAddListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-doAddListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-doAddListener' class='name expandable'>doAddListener</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling this.getBubbleTarget() if\npresent. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling <code>this.getBubbleTarget()</code> if\npresent. There is no implementation in the Observable base class.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-endEdit' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-endEdit' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-endEdit' class='name expandable'>endEdit</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> silent, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] modifiedFieldNames</span> )</div><div class='description'><div class='short'>Ends an edit. ...</div><div class='long'><p>Ends an edit. If any data was modified, the containing store is notified (ie, the store's <code>update</code> event will\nfire).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>True to not notify the store of the change</p>\n</div></li><li><span class='pre'>modifiedFieldNames</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>Array of field names changed during edit.</p>\n</div></li></ul></div></div></div><div id='method-erase' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-erase' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-erase' class='name expandable'>erase</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options</span> ) : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></div><div class='description'><div class='short'>Destroys the record using the configured proxy. ...</div><div class='long'><p>Destroys the record using the configured proxy. This will create a 'destroy' operation.\nNote that this doesn't destroy this instance after the server comes back with a response.\nIt will however call afterErase on any Stores it is joined to. Stores by default will\nautomatically remove this instance from their data collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Options to pass to the proxy. Config object for <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Ext.data.Operation</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></span><div class='sub-desc'><p>The Model instance</p>\n</div></li></ul></div></div></div><div id='method-fireAction' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-fireAction' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-fireAction' class='name expandable'>fireAction</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> args, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )</div><div class='description'><div class='short'>Fires the specified event with the passed parameters and execute a function (action)\nat the end if there are no liste...</div><div class='long'><p>Fires the specified event with the passed parameters and execute a function (action)\nat the end if there are no listeners that return false.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Arguments to pass to handers</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>Action</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>scope of fn</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... args</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Fires the specified event with the passed parameters (minus the event name, plus the options object passed\nto addList...</div><div class='long'><p>Fires the specified event with the passed parameters (minus the event name, plus the <code>options</code> object passed\nto <a href=\"#!/api/Ext.mixin.Observable-method-addListener\" rel=\"Ext.mixin.Observable-method-addListener\" class=\"docClass\">addListener</a>).</p>\n\n<p>An event may be set to bubble up an Observable parent hierarchy by calling <a href=\"#!/api/Ext.mixin.Observable-method-enableBubble\" rel=\"Ext.mixin.Observable-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul></div></div></div><div id='method-get' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-get' class='name expandable'>get</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> fieldName</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the value of the given field ...</div><div class='long'><p>Returns the value of the given field</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The field to fetch the value for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The value</p>\n</div></li></ul></div></div></div><div id='method-getAssociatedData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-getAssociatedData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getAssociatedData' class='name expandable'>getAssociatedData</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Gets all of the data from this Models loaded associations. ...</div><div class='long'><p>Gets all of the data from this Models <em>loaded</em> associations. It does this recursively - for example if we have a\nUser which hasMany Orders, and each Order hasMany OrderItems, it will return an object like this:</p>\n\n<pre><code>{\n    orders: [\n        {\n            id: 123,\n            status: 'shipped',\n            orderItems: [\n                ...\n            ]\n        }\n    ]\n}\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The nested data set for the Model's loaded associations</p>\n</div></li></ul></div></div></div><div id='method-getBubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-getBubbleEvents' class='name expandable'>getBubbleEvents</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</div><div class='description'><div class='short'>Returns the value of bubbleEvents. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.mixin.Observable-cfg-bubbleEvents\" rel=\"Ext.mixin.Observable-cfg-bubbleEvents\" class=\"docClass\">bubbleEvents</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getChanges' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-getChanges' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getChanges' class='name expandable'>getChanges</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Gets a hash of only the fields that have been modified since this Model was created or commited. ...</div><div class='long'><p>Gets a hash of only the fields that have been modified since this Model was created or commited.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getClientIdProperty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-clientIdProperty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getClientIdProperty' class='name expandable'>getClientIdProperty</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the value of clientIdProperty. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.data.Model-cfg-clientIdProperty\" rel=\"Ext.data.Model-cfg-clientIdProperty\" class=\"docClass\">clientIdProperty</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getConfig' class='name expandable'>getConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getCurrentConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getCurrentConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getCurrentConfig' class='name expandable'>getCurrentConfig</a>( <span class='pre'></span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-getData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getData' class='name expandable'>getData</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns the current field data for this Model instance. ...</div><div class='long'><p>Returns the current field data for this Model instance.</p>\n</div></div></div><div id='method-getFieldName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-getFieldName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getFieldName' class='name expandable'>getFieldName</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> field</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>This method is used by the fields collection to retrieve the key for a field\nbased on it's name. ...</div><div class='long'><p>This method is used by the fields collection to retrieve the key for a field\nbased on it's name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-fields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getFields' class='name expandable'>getFields</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</div><div class='description'><div class='short'>Returns the value of fields. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.data.Model-cfg-fields\" rel=\"Ext.data.Model-cfg-fields\" class=\"docClass\">fields</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-getId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getId' class='name expandable'>getId</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the unique ID allocated to this model instance as defined by idProperty. ...</div><div class='long'><p>Returns the unique ID allocated to this model instance as defined by <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">idProperty</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The id</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.mixin.Identifiable-method-getId' rel='Ext.mixin.Identifiable-method-getId' class='docClass'>Ext.mixin.Identifiable.getId</a></p></div></div></div><div id='method-getInitialConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getInitialConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getInitialConfig' class='name expandable'>getInitialConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getIsErased' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-getIsErased' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getIsErased' class='name expandable'>getIsErased</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Returns true if the record has been erased on the server. ...</div><div class='long'><p>Returns true if the record has been erased on the server.</p>\n</div></div></div><div id='method-getListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-getListeners' class='name expandable'>getListeners</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the value of listeners. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.mixin.Observable-cfg-listeners\" rel=\"Ext.mixin.Observable-cfg-listeners\" class=\"docClass\">listeners</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getProxy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-proxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-getProxy' class='name expandable'>getProxy</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Ext.data.Proxy</a></div><div class='description'><div class='short'>Returns the value of proxy. ...</div><div class='long'><p>Returns the value of <a href=\"#!/api/Ext.data.Model-cfg-proxy\" rel=\"Ext.data.Model-cfg-proxy\" class=\"docClass\">proxy</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Ext.data.Proxy</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-hasConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-hasConfig' class='name expandable'>hasConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-initConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> instanceConfig</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instanceConfig</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-isEqual' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-isEqual' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-isEqual' class='name expandable'>isEqual</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> a, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> b</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Checks if two values are equal, taking into account certain\nspecial factors, for example dates. ...</div><div class='long'><p>Checks if two values are equal, taking into account certain\nspecial factors, for example dates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>a</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The first value</p>\n</div></li><li><span class='pre'>b</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The second value</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the values are equal</p>\n</div></li></ul></div></div></div><div id='method-isModified' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-isModified' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-isModified' class='name expandable'>isModified</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> fieldName</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the passed field name has been modified since the load or last commit. ...</div><div class='long'><p>Returns true if the passed field name has been <code><a href=\"#!/api/Ext.data.Model-property-modified\" rel=\"Ext.data.Model-property-modified\" class=\"docClass\">modified</a></code> since the load or last commit.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p><a href=\"#!/api/Ext.data.Field-cfg-name\" rel=\"Ext.data.Field-cfg-name\" class=\"docClass\">Ext.data.Field.name</a></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isValid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-isValid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-isValid' class='name expandable'>isValid</a>( <span class='pre'></span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Checks if the model is valid. ...</div><div class='long'><p>Checks if the model is valid. See <a href=\"#!/api/Ext.data.Model-method-validate\" rel=\"Ext.data.Model-method-validate\" class=\"docClass\">validate</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the model is valid.</p>\n</div></li></ul></div></div></div><div id='method-join' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-join' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-join' class='name expandable'>join</a>( <span class='pre'><a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> store</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Tells this model instance that it has been added to a store. ...</div><div class='long'><p>Tells this model instance that it has been added to a store.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><div class='sub-desc'><p>The store to which this model has been added.</p>\n</div></li></ul></div></div></div><div id='method-mergeData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-mergeData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-mergeData' class='name expandable'>mergeData</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> data</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Private function that is used when you create a record that already exists in the model cache. ...</div><div class='long'><p>Private function that is used when you create a record that already exists in the model cache.\nIn this case we loop over each field, and apply any data to the current instance that is not already\nmarked as being dirty on that instance.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-notifyStores' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-notifyStores' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-notifyStores' class='name expandable'>notifyStores</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> fn</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Helper function used by afterEdit, afterReject and afterCommit. ...</div><div class='long'><p>Helper function used by afterEdit, afterReject and afterCommit. Calls the given method on the\n<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">store</a> that this instance has <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">joined</a>, if any. The store function\nwill always be called with the model instance as its single argument.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The function to call on the store</p>\n</div></li></ul></div></div></div><div id='method-onClassExtended' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-onClassExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-onClassExtended' class='name expandable'>onClassExtended</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> cls, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> data, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> hooks</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>WARNING: Only Jacky Nguyen and Tommy Maintz (might) understand this. ...</div><div class='long'><p>WARNING: Only Jacky Nguyen and Tommy Maintz (might) understand this.\nPlease don't read this code. If you do, don't judge us.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>cls</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>hooks</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onConfigUpdate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-onConfigUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-onConfigUpdate' class='name expandable'>onConfigUpdate</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> names, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> callback, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>names</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-prepareAssociatedData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-prepareAssociatedData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-prepareAssociatedData' class='name expandable'>prepareAssociatedData</a>( <span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> record, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] ids, [<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> associationType]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>This complex-looking method takes a given Model instance and returns an object containing all data from\nall of that M...</div><div class='long'><p>This complex-looking method takes a given Model instance and returns an object containing all data from\nall of that Model's <em>loaded</em> associations. See <a href=\"#!/api/Ext.data.Model-method-getAssociatedData\" rel=\"Ext.data.Model-method-getAssociatedData\" class=\"docClass\">getAssociatedData</a></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a><div class='sub-desc'><p>The Model instance</p>\n</div></li><li><span class='pre'>ids</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'><p>PRIVATE. The set of Model instance internalIds that have already been loaded</p>\n</div></li><li><span class='pre'>associationType</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The name of the type of association to limit to.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The nested data set for the Model's loaded associations</p>\n</div></li></ul></div></div></div><div id='method-reject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-reject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-reject' class='name expandable'>reject</a>( <span class='pre'>[<a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> silent]</span> )</div><div class='description'><div class='short'>Usually called by the Ext.data.Store to which this model instance has been joined. ...</div><div class='long'><p>Usually called by the <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> to which this model instance has been <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">joined</a>. Rejects\nall changes made to the model instance since either creation, or the last commit operation. Modified fields are\nreverted to their original values.</p>\n\n<p>Developers should subscribe to the <a href=\"#!/api/Ext.data.Store-event-update\" rel=\"Ext.data.Store-event-update\" class=\"docClass\">Ext.data.Store.update</a> event to have their code notified of reject\noperations.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> (optional)<div class='sub-desc'><p>True to skip notification of the owning store of the change.\nDefaults to false.</p>\n</div></li></ul></div></div></div><div id='method-relayEvent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-relayEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-relayEvent' class='name expandable'>relayEvent</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> args, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> object, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <code><b>this</b></code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>object</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> eventName, <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <strong>This must be a reference to the function passed into the\n<a href=\"#!/api/Ext.mixin.Observable-method-addListener\" rel=\"Ext.mixin.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</strong></p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>The scope originally specified for the handler. It must be the same as the\nscope argument specified in the original call to <a href=\"#!/api/Ext.mixin.Observable-method-addListener\" rel=\"Ext.mixin.Observable-method-addListener\" class=\"docClass\">addListener</a> or the listener will not be removed.</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resumes firing events (see suspendEvents). ...</div><div class='long'><p>Resumes firing events (see <a href=\"#!/api/Ext.mixin.Observable-method-suspendEvents\" rel=\"Ext.mixin.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>).</p>\n\n<p>If events were suspended using the <code>queueSuspended</code> parameter, then all events fired\nduring event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-save' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-save' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-save' class='name expandable'>save</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> options</span> ) : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></div><div class='description'><div class='short'>Saves the model instance using the configured proxy. ...</div><div class='long'><p>Saves the model instance using the configured proxy.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>options</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Options to pass to the proxy. Config object for <a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">Ext.data.Operation</a>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></span><div class='sub-desc'><p>The Model instance</p>\n</div></li></ul></div></div></div><div id='method-set' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-set' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-set' class='name expandable'>set</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fieldName, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> )</div><div class='description'><div class='short'>Sets the given field to the given value, marks the instance as dirty ...</div><div class='long'><p>Sets the given field to the given value, marks the instance as dirty</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The field to set, or an object containing key/value pairs</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to set</p>\n</div></li></ul></div></div></div><div id='method-setBubbleEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-bubbleEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-setBubbleEvents' class='name expandable'>setBubbleEvents</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[] bubbleEvents</span> )</div><div class='description'><div class='short'>Sets the value of bubbleEvents. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.mixin.Observable-cfg-bubbleEvents\" rel=\"Ext.mixin.Observable-cfg-bubbleEvents\" class=\"docClass\">bubbleEvents</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bubbleEvents</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setClientIdProperty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-clientIdProperty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-setClientIdProperty' class='name expandable'>setClientIdProperty</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> clientIdProperty</span> )</div><div class='description'><div class='short'>Sets the value of clientIdProperty. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.data.Model-cfg-clientIdProperty\" rel=\"Ext.data.Model-cfg-clientIdProperty\" class=\"docClass\">clientIdProperty</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clientIdProperty</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-setConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-setConfig' class='name expandable'>setConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> applyIfNotSet</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>applyIfNotSet</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setConvertedData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-setConvertedData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-setConvertedData' class='name expandable'>setConvertedData</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> data</span> )</div><div class='description'><div class='short'>This sets the data directly without converting and applying default values. ...</div><div class='long'><p>This sets the data directly without converting and applying default values.\nThis method is used when a Record gets instantiated by a Reader. Only use\nthis when you are sure you are passing correctly converted data.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>data</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-setData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-setData' class='name expandable'>setData</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> rawData</span> ) : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></div><div class='description'><div class='short'>This method is used to set the data for this Record instance. ...</div><div class='long'><p>This method is used to set the data for this Record instance.\nNote that the existing data is removed. If a field is not specified\nin the passed data it will use the field's default value. If a convert\nmethod is specified for the field it will be called on the value.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>rawData</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a></span><div class='sub-desc'><p>this This Record</p>\n</div></li></ul></div></div></div><div id='method-setDirty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-setDirty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-setDirty' class='name expandable'>setDirty</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Marks this Record as dirty. ...</div><div class='long'><p>Marks this <strong>Record</strong> as <code><a href=\"#!/api/Ext.data.Model-property-dirty\" rel=\"Ext.data.Model-property-dirty\" class=\"docClass\">dirty</a></code>. This method is used interally when adding <code><a href=\"#!/api/Ext.data.Model-property-phantom\" rel=\"Ext.data.Model-property-phantom\" class=\"docClass\">phantom</a></code> records\nto a <a href=\"#!/api/Ext.data.proxy.Server-cfg-writer\" rel=\"Ext.data.proxy.Server-cfg-writer\" class=\"docClass\">writer enabled store</a>.</p>\n\n<p>Marking a record <code><a href=\"#!/api/Ext.data.Model-property-dirty\" rel=\"Ext.data.Model-property-dirty\" class=\"docClass\">dirty</a></code> causes the phantom to be returned by <a href=\"#!/api/Ext.data.Store-method-getUpdatedRecords\" rel=\"Ext.data.Store-method-getUpdatedRecords\" class=\"docClass\">Ext.data.Store.getUpdatedRecords</a>\nwhere it will have a create action composed for it during <a href=\"#!/api/Ext.data.Model-method-save\" rel=\"Ext.data.Model-method-save\" class=\"docClass\">model save</a> operations.</p>\n</div></div></div><div id='method-setFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-setFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-setFields' class='name expandable'>setFields</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Updates the collection of Fields that all instances of this Model use. ...</div><div class='long'><p>Updates the collection of Fields that all instances of this Model use. <strong>Does not</strong> update field values in a Model\ninstance (use <a href=\"#!/api/Ext.data.Model-method-set\" rel=\"Ext.data.Model-method-set\" class=\"docClass\">set</a> for that), instead this updates which fields are available on the Model class. This\nis normally used when creating or updating Model definitions dynamically, for example if you allow your users to\ndefine their own Models and save the fields configuration to a database, this method allows you to change those\nfields later.</p>\n</div></div></div><div id='method-setId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-setId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-setId' class='name expandable'>setId</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> id</span> )</div><div class='description'><div class='short'>Sets the model instance's id field to the given id. ...</div><div class='long'><p>Sets the model instance's id field to the given id.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new id</p>\n</div></li></ul></div></div></div><div id='method-setListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-setListeners' class='name expandable'>setListeners</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> listeners</span> )</div><div class='description'><div class='short'>Sets the value of listeners. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.mixin.Observable-cfg-listeners\" rel=\"Ext.mixin.Observable-cfg-listeners\" class=\"docClass\">listeners</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>listeners</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setProxy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-cfg-proxy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-setProxy' class='name expandable'>setProxy</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Ext.data.Proxy</a> proxy</span> )</div><div class='description'><div class='short'>Sets the value of proxy. ...</div><div class='long'><p>Sets the value of <a href=\"#!/api/Ext.data.Model-cfg-proxy\" rel=\"Ext.data.Model-cfg-proxy\" class=\"docClass\">proxy</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>proxy</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">Ext.data.Proxy</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-sortConvertFields' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-sortConvertFields' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-sortConvertFields' class='name expandable'>sortConvertFields</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> field1, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> field2</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>This method is being used to sort the fields based on their convert method. ...</div><div class='long'><p>This method is being used to sort the fields based on their convert method. If\na field has a custom convert method, we ensure its more to the bottom of the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>field1</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>field2</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-statics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.mixin.Observable' rel='Ext.mixin.Observable' class='defined-in docClass'>Ext.mixin.Observable</a><br/><a href='source/Observable.html#Ext-mixin-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.mixin.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a> queueSuspended</span> )</div><div class='description'><div class='short'>Suspends the firing of all events. ...</div><div class='long'><p>Suspends the firing of all events. (see <a href=\"#!/api/Ext.mixin.Observable-method-resumeEvents\" rel=\"Ext.mixin.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a><div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.mixin.Observable-method-resumeEvents\" rel=\"Ext.mixin.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events.</p>\n</div></li></ul></div></div></div><div id='method-toUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-toUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-toUrl' class='name expandable'>toUrl</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns a url-suitable string for this model instance. ...</div><div class='long'><p>Returns a url-suitable string for this model instance. By default this just returns the name of the Model class\nfollowed by the instance ID - for example an instance of MyApp.model.User with ID 123 will return 'user/123'.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The url string for this model instance</p>\n</div></li></ul></div></div></div><div id='method-unjoin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-unjoin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-unjoin' class='name expandable'>unjoin</a>( <span class='pre'><a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> store</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Tells this model instance that it has been removed from the store. ...</div><div class='long'><p>Tells this model instance that it has been removed from the store.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a><div class='sub-desc'><p>The store from which this model has been removed.</p>\n</div></li></ul></div></div></div><div id='method-validate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-method-validate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-method-validate' class='name expandable'>validate</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.data.Errors\" rel=\"Ext.data.Errors\" class=\"docClass\">Ext.data.Errors</a></div><div class='description'><div class='short'>Validates the current data against all of its configured validations. ...</div><div class='long'><p>Validates the current data against all of its configured <a href=\"#!/api/Ext.data.Model-cfg-validations\" rel=\"Ext.data.Model-cfg-validations\" class=\"docClass\">validations</a>.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Errors\" rel=\"Ext.data.Errors\" class=\"docClass\">Ext.data.Errors</a></span><div class='sub-desc'><p>The errors object</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-addConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addConfig' class='name expandable'>addConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fullMerge</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>fullMerge</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addInheritableStatics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addInheritableStatics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addInheritableStatics' class='name expandable'>addInheritableStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addMember' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addMember' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addMember' class='name expandable'>addMember</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> member</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>member</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addMembers' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addMembers' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addMembers' class='name expandable'>addMembers</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> )<strong class='static signature'>static</strong></div><div class='description'><div class='short'>Add methods / properties to the prototype of this class. ...</div><div class='long'><p>Add methods / properties to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Cat', {\n    constructor: function() {\n        ...\n    }\n});\n\n My.awesome.Cat.implement({\n     meow: function() {\n        alert('Meowww...');\n     }\n });\n\n var kitty = new My.awesome.Cat;\n kitty.meow();\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-addStatics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addStatics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addStatics' class='name expandable'>addStatics</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static signature'>static</strong></div><div class='description'><div class='short'>Add / override static properties of this class. ...</div><div class='long'><p>Add / override static properties of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.addStatics({\n    someProperty: 'someValue',      // My.cool.Class.someProperty = 'someValue'\n    method1: function() { ... },    // My.cool.Class.method1 = function() { ... };\n    method2: function() { ... }     // My.cool.Class.method2 = function() { ... };\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-addXtype' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-addXtype' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-addXtype' class='name expandable'>addXtype</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> xtype</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>xtype</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-borrow' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-borrow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-borrow' class='name expandable'>borrow</a>( <span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a> fromClass, <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Borrow another class' members to the prototype of this class. ...</div><div class='long'><p>Borrow another class' members to the prototype of this class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Bank', {\n    money: '$$$',\n    printMoney: function() {\n        alert('$$$$$$$');\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Thief', {\n    ...\n});\n\nThief.borrow(Bank, ['money', 'printMoney']);\n\nvar steve = new Thief();\n\nalert(steve.money); // alerts '$$$'\nsteve.printMoney(); // alerts '$$$$$$$'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fromClass</span> : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><div class='sub-desc'><p>The class to borrow members from</p>\n</div></li><li><span class='pre'>members</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The names of the members to borrow</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='static-method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-callParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> args</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-create' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-create' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-create' class='name expandable'>create</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='static signature'>static</strong></div><div class='description'><div class='short'>Create a new instance of this Class. ...</div><div class='long'><p>Create a new instance of this Class.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    ...\n});\n\nMy.cool.Class.create({\n    someConfig: true\n});\n</code></pre>\n\n<p>All parameters are passed to the constructor of the class.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the created instance.</p>\n</div></li></ul></div></div></div><div id='static-method-createAlias' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-createAlias' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-createAlias' class='name expandable'>createAlias</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> alias, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> origin</span> )<strong class='static signature'>static</strong></div><div class='description'><div class='short'>Create aliases for existing prototype methods. ...</div><div class='long'><p>Create aliases for existing prototype methods. Example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    method1: function() { ... },\n    method2: function() { ... }\n});\n\nvar test = new My.cool.Class();\n\nMy.cool.Class.createAlias({\n    method3: 'method1',\n    method4: 'method2'\n});\n\ntest.method3(); // test.method1()\n\nMy.cool.Class.createAlias('method5', 'method3');\n\ntest.method5(); // test.method3() -&gt; test.method1()\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>alias</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The new method name, or an object to set multiple aliases. See\n<a href=\"#!/api/Ext.Function-method-flexSetter\" rel=\"Ext.Function-method-flexSetter\" class=\"docClass\">flexSetter</a></p>\n</div></li><li><span class='pre'>origin</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The original method name</p>\n</div></li></ul></div></div></div><div id='static-method-extend' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-extend' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-extend' class='name expandable'>extend</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> parent</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>parent</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-getName' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-getName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-getName' class='name expandable'>getName</a>( <span class='pre'></span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><strong class='static signature'>static</strong></div><div class='description'><div class='short'>Get the current class' name in string format. ...</div><div class='long'><p>Get the current class' name in string format.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.cool.Class', {\n    constructor: function() {\n        alert(this.self.getName()); // alerts 'My.cool.Class'\n    }\n});\n\nMy.cool.Class.getName(); // 'My.cool.Class'\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>className</p>\n</div></li></ul></div></div></div><div id='static-method-implement' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-implement' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-implement' class='name expandable'>implement</a>( <span class='pre'></span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='static-method-load' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Model'>Ext.data.Model</span><br/><a href='source/Model.html#Ext-data-Model-static-method-load' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Model-static-method-load' class='name expandable'>load</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> id, [<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config]</span> )<strong class='static signature'>static</strong></div><div class='description'><div class='short'>Asynchronously loads a model instance by id. ...</div><div class='long'><p>Asynchronously loads a model instance by id. Sample usage:</p>\n\n<pre><code>MyApp.User = <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'id', type: 'int'},\n        {name: 'name', type: 'string'}\n    ]\n});\n\nMyApp.User.load(10, {\n    scope: this,\n    failure: function(record, operation) {\n        //do something if the load failed\n    },\n    success: function(record, operation) {\n        //do something if the load succeeded\n    },\n    callback: function(record, operation) {\n        //do something whether the load succeeded or failed\n    }\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The id of the model to load</p>\n</div></li><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>config object containing success, failure and callback functions, plus\noptional scope</p>\n</div></li></ul></div></div></div><div id='static-method-mixin' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-mixin' class='name expandable'>mixin</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> mixinClass</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Used internally by the mixins pre-processor ...</div><div class='long'><p>Used internally by the mixins pre-processor</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>mixinClass</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-onExtended' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-onExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-onExtended' class='name expandable'>onExtended</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='static-method-override' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-override' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-override' class='name expandable'>override</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> members</span> ) : <a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a><strong class='deprecated signature'>deprecated</strong><strong class='static signature'>static</strong></div><div class='description'><div class='short'>Override members of this class. ...</div><div class='long'><p>Override members of this class. Overridden methods can be invoked via\n<a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a>.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n\n<p>As of 4.1, direct use of this method is deprecated. Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>\ninstead:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.CatOverride', {\n    override: 'My.Cat',\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callParent(arguments);\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n</code></pre>\n\n<p>The above accomplishes the same result but can be managed by the <a href=\"#!/api/Ext.Loader\" rel=\"Ext.Loader\" class=\"docClass\">Ext.Loader</a>\nwhich can properly order the override and its target class and the build process\ncan determine whether the override is needed based on the required state of the\ntarget class (My.Cat).</p>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> since 4.1.0</p>\n        <p>Use <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a> instead</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>members</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The properties to add to this class. This should be\nspecified as an object literal containing one or more properties.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Base\" rel=\"Ext.Base\" class=\"docClass\">Ext.Base</a></span><div class='sub-desc'><p>this class</p>\n</div></li></ul></div></div></div><div id='static-method-triggerExtended' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-static-method-triggerExtended' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-static-method-triggerExtended' class='name expandable'>triggerExtended</a>( <span class='pre'></span> )<strong class='static signature'>static</strong><strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div></div></div></div></div>","allMixins":["Ext.mixin.Observable"],"requires":["Ext.util.Collection","Ext.data.Field","Ext.data.identifier.Simple","Ext.data.ModelManager","Ext.data.proxy.Ajax","Ext.data.association.HasMany","Ext.data.association.BelongsTo","Ext.data.association.HasOne","Ext.data.Errors"],"meta":{"author":["Ed Spencer"]},"files":[{"href":"Model.html#Ext-data-Model","filename":"Model.js"}]});