Ext.data.JsonP.Ext_data_StoreManager({"inheritdoc":null,"aliases":{},"extends":"Ext.util.Collection","alternateClassNames":["Ext.StoreMgr","Ext.data.StoreMgr","Ext.StoreManager"],"uses":["Ext.data.ArrayStore"],"singleton":true,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[],"property":[]},"component":false,"tagname":"class","code_type":"ext_define","members":{"css_var":[],"css_mixin":[],"cfg":[{"owner":"Ext.util.Collection","tagname":"cfg","name":"filters","id":"cfg-filters","meta":{}},{"owner":"Ext.data.StoreManager","tagname":"cfg","name":"listeners","id":"cfg-listeners","meta":{"private":true}},{"owner":"Ext.util.Collection","tagname":"cfg","name":"sorters","id":"cfg-sorters","meta":{}}],"method":[{"owner":"Ext.util.Collection","tagname":"method","name":"add","id":"method-add","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"addAll","id":"method-addAll","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"callOverridden","id":"method-callOverridden","meta":{"deprecated":{"text":"as of 4.1. Use {@link #callParent} instead."},"protected":true}},{"owner":"Ext.Base","tagname":"method","name":"callParent","id":"method-callParent","meta":{"protected":true}},{"owner":"Ext.util.Collection","tagname":"method","name":"clear","id":"method-clear","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"clone","id":"method-clone","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"contains","id":"method-contains","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"containsKey","id":"method-containsKey","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"destroy","id":"method-destroy","meta":{"private":true}},{"owner":"Ext.util.Collection","tagname":"method","name":"each","id":"method-each","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"eachKey","id":"method-eachKey","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"filterBy","id":"method-filterBy","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"findBy","id":"method-findBy","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"findIndexBy","id":"method-findIndexBy","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"first","id":"method-first","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"get","id":"method-get","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"getAt","id":"method-getAt","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"getByKey","id":"method-getByKey","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"getConfig","id":"method-getConfig","meta":{"private":true}},{"owner":"Ext.util.Collection","tagname":"method","name":"getCount","id":"method-getCount","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"getCurrentConfig","id":"method-getCurrentConfig","meta":{"private":true}},{"owner":"Ext.Base","tagname":"method","name":"getInitialConfig","id":"method-getInitialConfig","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"getKey","id":"method-getKey","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"getRange","id":"method-getRange","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"hasConfig","id":"method-hasConfig","meta":{"private":true}},{"owner":"Ext.util.Collection","tagname":"method","name":"indexOf","id":"method-indexOf","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"indexOfKey","id":"method-indexOfKey","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"initConfig","id":"method-initConfig","meta":{"protected":true}},{"owner":"Ext.util.Collection","tagname":"method","name":"insert","id":"method-insert","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"last","id":"method-last","meta":{}},{"owner":"Ext.data.StoreManager","tagname":"method","name":"lookup","id":"method-lookup","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"onConfigUpdate","id":"method-onConfigUpdate","meta":{"private":true}},{"owner":"Ext.data.StoreManager","tagname":"method","name":"register","id":"method-register","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"remove","id":"method-remove","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"removeAll","id":"method-removeAll","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"removeAt","id":"method-removeAt","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"removeAtKey","id":"method-removeAtKey","meta":{}},{"owner":"Ext.util.Collection","tagname":"method","name":"replace","id":"method-replace","meta":{}},{"owner":"Ext.Base","tagname":"method","name":"setConfig","id":"method-setConfig","meta":{"private":true}},{"owner":"Ext.Base","tagname":"method","name":"statics","id":"method-statics","meta":{"protected":true}},{"owner":"Ext.data.StoreManager","tagname":"method","name":"unregister","id":"method-unregister","meta":{}}],"event":[],"property":[{"owner":"Ext.util.Collection","tagname":"property","name":"all","id":"property-all","meta":{}},{"owner":"Ext.util.Collection","tagname":"property","name":"indices","id":"property-indices","meta":{}},{"owner":"Ext.util.Collection","tagname":"property","name":"items","id":"property-items","meta":{}},{"owner":"Ext.util.Collection","tagname":"property","name":"keys","id":"property-keys","meta":{}},{"owner":"Ext.util.Collection","tagname":"property","name":"length","id":"property-length","meta":{}},{"owner":"Ext.util.Collection","tagname":"property","name":"map","id":"property-map","meta":{}},{"owner":"Ext.Base","tagname":"property","name":"self","id":"property-self","meta":{"protected":true}}]},"superclasses":["Ext.Base","Ext.util.Collection","Ext.data.StoreManager"],"html_meta":{"docauthor":null},"private":false,"mixedInto":[],"name":"Ext.data.StoreManager","mixins":[],"inheritable":false,"subclasses":[],"id":"class-Ext.data.StoreManager","html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>Ext.StoreManager</div><div class='alternate-class-name'>Ext.StoreMgr</div><div class='alternate-class-name'>Ext.data.StoreMgr</div><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Base' rel='Ext.Base' class='docClass'>Ext.Base</a><div class='subclass '><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='docClass'>Ext.util.Collection</a><div class='subclass '><strong>Ext.data.StoreManager</strong></div></div></div><h4>Uses</h4><div class='dependency'><a href='#!/api/Ext.data.ArrayStore' rel='Ext.data.ArrayStore' class='docClass'>Ext.data.ArrayStore</a></div><h4>Files</h4><div class='dependency'><a href='source/StoreManager.html#Ext-data-StoreManager' target='_blank'>StoreManager.js</a></div></pre><div class='doc-contents'><p>Contains a collection of all stores that are created that have an identifier. An identifier can be assigned by\nsetting the <a href=\"#!/api/Ext.data.Store-cfg-storeId\" rel=\"Ext.data.Store-cfg-storeId\" class=\"docClass\">storeId</a> property. When a store is in the StoreManager, it can be\nreferred to via it's identifier:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'SomeModel',\n    storeId: 'myStore'\n});\n\nvar store = <a href=\"#!/api/Ext.data.StoreManager-method-lookup\" rel=\"Ext.data.StoreManager-method-lookup\" class=\"docClass\">Ext.data.StoreManager.lookup</a>('myStore');\n</code></pre>\n\n<p>Also note that the <a href=\"#!/api/Ext.data.StoreManager-method-lookup\" rel=\"Ext.data.StoreManager-method-lookup\" class=\"docClass\">lookup</a> method is aliased to <a href=\"#!/api/Ext-method-getStore\" rel=\"Ext-method-getStore\" class=\"docClass\">Ext.getStore</a> for convenience.</p>\n\n<p>If a store is registered with the StoreManager, you can also refer to the store by it's identifier when registering\nit with any Component that consumes data from a store:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'SomeModel',\n    storeId: 'myStore'\n});\n\n<a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('Ext.view.View', {\n    store: 'myStore',\n    // other configuration here\n});\n</code></pre>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-filters' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-cfg-filters' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-cfg-filters' class='name not-expandable'>filters</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'><p>Array of <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Filters</a> for this collection.</p>\n</div><div class='long'><p>Array of <a href=\"#!/api/Ext.util.Filter\" rel=\"Ext.util.Filter\" class=\"docClass\">Filters</a> for this collection.</p>\n</div></div></div><div id='cfg-listeners' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.StoreManager'>Ext.data.StoreManager</span><br/><a href='source/StoreManager.html#Ext-data-StoreManager-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.StoreManager-cfg-listeners' class='name not-expandable'>listeners</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><strong class='private signature'>private</strong></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div><div id='cfg-sorters' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-cfg-sorters' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-cfg-sorters' class='name not-expandable'>sorters</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>[]</span></div><div class='description'><div class='short'><p>Array of <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Sorters</a> for this collection.</p>\n</div><div class='long'><p>Array of <a href=\"#!/api/Ext.util.Sorter\" rel=\"Ext.util.Sorter\" class=\"docClass\">Sorters</a> for this collection.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-all' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-property-all' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-property-all' class='name expandable'>all</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array containing all the items (unsorted, unfiltered) ...</div><div class='long'><p>An array containing all the items (unsorted, unfiltered)</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-indices' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-property-indices' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-property-indices' class='name expandable'>indices</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object used as map to get a sorted and filtered index of an item ...</div><div class='long'><p>An object used as map to get a sorted and filtered index of an item</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-items' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-property-items' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-property-items' class='name expandable'>items</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array containing the filtered items (sorted) ...</div><div class='long'><p>An array containing the filtered items (sorted)</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-keys' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-property-keys' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-property-keys' class='name expandable'>keys</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>An array containing all the filtered keys (sorted) ...</div><div class='long'><p>An array containing all the filtered keys (sorted)</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-length' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-property-length' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-property-length' class='name expandable'>length</a><span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span></div><div class='description'><div class='short'>The count of items in the collection filtered and sorted ...</div><div class='long'><p>The count of items in the collection filtered and sorted</p>\n<p>Defaults to: <code>0</code></p></div></div></div><div id='property-map' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-property-map' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-property-map' class='name expandable'>map</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>An object used as map to get an object based on its key ...</div><div class='long'><p>An object used as map to get an object based on its key</p>\n<p>Defaults to: <code>{}</code></p></div></div></div><div id='property-self' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-property-self' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-property-self' class='name expandable'>self</a><span> : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the current class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the current class from which this object was instantiated. Unlike <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>,\n<code>this.self</code> is scope-dependent and it's meant to be used for dynamic inheritance. See <a href=\"#!/api/Ext.Base-method-statics\" rel=\"Ext.Base-method-statics\" class=\"docClass\">statics</a>\nfor a detailed comparison</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        alert(this.self.speciesName); / dependentOL on 'this'\n    },\n\n    clone: function() {\n        return new this.self();\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n    statics: {\n        speciesName: 'Snow Leopard'         // My.SnowLeopard.speciesName = 'Snow Leopard'\n    }\n});\n\nvar cat = new My.Cat();                     // alerts 'Cat'\nvar snowLeopard = new My.SnowLeopard();     // alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));             // alerts 'My.SnowLeopard'\n</code></pre>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-add' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-add' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-add' class='name expandable'>add</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> key, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> item</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Adds an item to the collection. ...</div><div class='long'><p>Adds an item to the collection. Fires the <a href=\"#!/api/Ext.util.Collection-method-add\" rel=\"Ext.util.Collection-method-add\" class=\"docClass\">add</a> event when complete.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key to associate with the item, or the new item.</p>\n\n<p>If a <a href=\"#!/api/Ext.util.Collection-method-getKey\" rel=\"Ext.util.Collection-method-getKey\" class=\"docClass\">getKey</a> implementation was specified for this MixedCollection, or if the key of the stored items is\nin a property called <strong>id</strong>, the MixedCollection will be able to <em>derive</em> the key for the new item. In this case\njust pass the new item in this parameter.</p>\n</div></li><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The item to add.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The item added.</p>\n</div></li></ul></div></div></div><div id='method-addAll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-addAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-addAll' class='name expandable'>addAll</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> objs</span> )</div><div class='description'><div class='short'>Adds all elements of an Array or an Object to the collection. ...</div><div class='long'><p>Adds all elements of an Array or an Object to the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objs</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>An Object containing properties which will be added to the collection, or an Array of\nvalues, each of which are added to the collection. Functions references will be added to the collection if <a href=\"#!/api/Ext.util.MixedCollection-cfg-allowFunctions\" rel=\"Ext.util.MixedCollection-cfg-allowFunctions\" class=\"docClass\">allowFunctions</a> has been set to true.</p>\n</div></li></ul></div></div></div><div id='method-callOverridden' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callOverridden' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callOverridden' class='name expandable'>callOverridden</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='deprecated signature'>deprecated</strong><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Call the original method that was previously overridden with override\n\nExt.define('My.Cat', {\n    constructor: functi...</div><div class='long'><p>Call the original method that was previously overridden with <a href=\"#!/api/Ext.Base-static-method-override\" rel=\"Ext.Base-static-method-override\" class=\"docClass\">override</a></p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    constructor: function() {\n        alert(\"I'm a cat!\");\n    }\n});\n\nMy.Cat.override({\n    constructor: function() {\n        alert(\"I'm going to be a cat!\");\n\n        var instance = this.callOverridden();\n\n        alert(\"Meeeeoooowwww\");\n\n        return instance;\n    }\n});\n\nvar kitty = new My.Cat(); // alerts \"I'm going to be a cat!\"\n                          // alerts \"I'm a cat!\"\n                          // alerts \"Meeeeoooowwww\"\n</code></pre>\n        <div class='signature-box deprecated'>\n        <p>This method has been <strong>deprecated</strong> </p>\n        <p>as of 4.1. Use <a href=\"#!/api/Ext.Base-method-callParent\" rel=\"Ext.Base-method-callParent\" class=\"docClass\">callParent</a> instead.</p>\n\n        </div>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callOverridden(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the overridden method</p>\n</div></li></ul></div></div></div><div id='method-callParent' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-callParent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-callParent' class='name expandable'>callParent</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments args</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Call the \"parent\" method of the current method. ...</div><div class='long'><p>Call the \"parent\" method of the current method. That is the method previously\noverridden by derivation or by an override (see <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>).</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Base', {\n     constructor: function (x) {\n         this.x = x;\n     },\n\n     statics: {\n         method: function (x) {\n             return x;\n         }\n     }\n });\n\n <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived', {\n     extend: 'My.Base',\n\n     constructor: function () {\n         this.callParent([21]);\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // alerts 21\n</code></pre>\n\n<p>This can be used with an override as follows:</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.DerivedOverride', {\n     override: 'My.Derived',\n\n     constructor: function (x) {\n         this.callParent([x*2]); // calls original My.Derived constructor\n     }\n });\n\n var obj = new My.Derived();\n\n alert(obj.x);  // now alerts 42\n</code></pre>\n\n<p>This also works with static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2', {\n     extend: 'My.Base',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Base.method\n         }\n     }\n });\n\n alert(My.Base.method(10);     // alerts 10\n alert(My.Derived2.method(10); // alerts 20\n</code></pre>\n\n<p>Lastly, it also works with overridden static methods.</p>\n\n<pre><code> <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Derived2Override', {\n     override: 'My.Derived2',\n\n     statics: {\n         method: function (x) {\n             return this.callParent([x*2]); // calls My.Derived2.method\n         }\n     }\n });\n\n alert(My.Derived2.method(10); // now alerts 40\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a>/Arguments<div class='sub-desc'><p>The arguments, either an array or the <code>arguments</code> object\nfrom the current method, for example: <code>this.callParent(arguments)</code></p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>Returns the result of calling the parent method</p>\n</div></li></ul></div></div></div><div id='method-clear' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-clear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-clear' class='name expandable'>clear</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all items from the collection. ...</div><div class='long'><p>Removes all items from the collection. Fires the <a href=\"#!/api/Ext.util.Collection-method-clear\" rel=\"Ext.util.Collection-method-clear\" class=\"docClass\">clear</a> event when complete.</p>\n</div></div></div><div id='method-clone' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-clone' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-clone' class='name expandable'>clone</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></div><div class='description'><div class='short'>Creates a shallow copy of this collection ...</div><div class='long'><p>Creates a shallow copy of this collection</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-contains' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-contains' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-contains' class='name expandable'>contains</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> item</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the collection contains the passed Object as an item. ...</div><div class='long'><p>Returns true if the collection contains the passed Object as an item.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The Object to look for in the collection.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the collection contains the Object as an item.</p>\n</div></li></ul></div></div></div><div id='method-containsKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-containsKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-containsKey' class='name expandable'>containsKey</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> key</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the collection contains the passed Object as a key. ...</div><div class='long'><p>Returns true if the collection contains the passed Object as a key.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key to look for in the collection.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the collection contains the Object as a key.</p>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-destroy' class='name expandable'>destroy</a>( <span class='pre'></span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Overrides: <a href='#!/api/Ext.Component-method-destroy' rel='Ext.Component-method-destroy' class='docClass'>Ext.Component.destroy</a></p></div></div></div><div id='method-each' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-each' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-each' class='name expandable'>each</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )</div><div class='description'><div class='short'>Executes the specified function once for every item in the collection, passing the following arguments:\n\n\nitem : Mixe...</div><div class='long'><p>Executes the specified function once for every item in the collection, passing the following arguments:</p>\n\n<ul>\n<li><strong>item</strong> : Mixed</li>\n</ul>\n\n\n<p>The collection item</p>\n\n<ul>\n<li><strong>index</strong> : Number</li>\n</ul>\n\n\n<p>The item's index</p>\n\n<ul>\n<li><strong>length</strong> : Number</li>\n</ul>\n\n\n<p>The total number of items in the collection</p>\n\n<p>The function should return a boolean value. Returning false from the function will stop the iteration.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to execute for each item.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the current\nitem in the iteration.</p>\n</div></li></ul></div></div></div><div id='method-eachKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-eachKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-eachKey' class='name expandable'>eachKey</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )</div><div class='description'><div class='short'>Executes the specified function once for every key in the collection, passing each key, and its associated item\nas th...</div><div class='long'><p>Executes the specified function once for every key in the collection, passing each key, and its associated item\nas the first two parameters.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to execute for each item.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the browser\nwindow.</p>\n</div></li></ul></div></div></div><div id='method-filterBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-filterBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-filterBy' class='name expandable'>filterBy</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> ) : <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></div><div class='description'><div class='short'>Filter by a function. ...</div><div class='long'><p>Filter by a function. Returns a <em>new</em> collection that has been filtered. The passed function will be called with\neach object in the collection. If the function returns true, the value is included otherwise it is filtered.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called, it will receive the args o (the object), k (the key)</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to this\nMixedCollection.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></span><div class='sub-desc'><p>The new filtered collection</p>\n</div></li></ul></div></div></div><div id='method-findBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-findBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-findBy' class='name expandable'>findBy</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the first item in the collection which elicits a true return value from the passed selection function. ...</div><div class='long'><p>Returns the first item in the collection which elicits a true return value from the passed selection function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The selection function to execute for each item.</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the browser\nwindow.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The first item in the collection which returned true from the selection function.</p>\n</div></li></ul></div></div></div><div id='method-findIndexBy' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-findIndexBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-findIndexBy' class='name expandable'>findIndexBy</a>( <span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a> fn, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> start</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Find the index of the first matching object in this collection by a function. ...</div><div class='long'><p>Find the index of the first matching object in this collection by a function. If the function returns <em>true</em> it\nis considered a match.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to be called, it will receive the args o (the object), k (the key).</p>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to this\nMixedCollection.</p>\n</div></li><li><span class='pre'>start</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index to start searching at (defaults to 0).</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The matched index or -1</p>\n</div></li></ul></div></div></div><div id='method-first' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-first' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-first' class='name expandable'>first</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the first item in the collection. ...</div><div class='long'><p>Returns the first item in the collection.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the first item in the collection..</p>\n</div></li></ul></div></div></div><div id='method-get' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-get' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-get' class='name expandable'>get</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> key</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the item associated with the passed key OR index. ...</div><div class='long'><p>Returns the item associated with the passed key OR index. Key has priority over index. This is the equivalent of\ncalling <a href=\"#!/api/Ext.util.Collection-method-getByKey\" rel=\"Ext.util.Collection-method-getByKey\" class=\"docClass\">getByKey</a> first, then if nothing matched calling <a href=\"#!/api/Ext.util.Collection-method-getAt\" rel=\"Ext.util.Collection-method-getAt\" class=\"docClass\">getAt</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The key or index of the item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>If the item is found, returns the item. If the item was not found, returns undefined. If an item\nwas found, but is a Class, returns null.</p>\n</div></li></ul></div></div></div><div id='method-getAt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-getAt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-getAt' class='name expandable'>getAt</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> index</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the item at the specified index. ...</div><div class='long'><p>Returns the item at the specified index.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index of the item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The item at the specified index.</p>\n</div></li></ul></div></div></div><div id='method-getByKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-getByKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-getByKey' class='name expandable'>getByKey</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> key</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the item associated with the passed key. ...</div><div class='long'><p>Returns the item associated with the passed key.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The key of the item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The item associated with the passed key.</p>\n</div></li></ul></div></div></div><div id='method-getConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getConfig' class='name expandable'>getConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getCount' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-getCount' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-getCount' class='name expandable'>getCount</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the number of items in the collection. ...</div><div class='long'><p>Returns the number of items in the collection.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>the number of items in the collection.</p>\n</div></li></ul></div></div></div><div id='method-getCurrentConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getCurrentConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getCurrentConfig' class='name expandable'>getCurrentConfig</a>( <span class='pre'></span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-getInitialConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-getInitialConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-getInitialConfig' class='name expandable'>getInitialConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )</div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-getKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-getKey' class='name expandable'>getKey</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> item</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>MixedCollection has a generic way to fetch keys if you implement getKey. ...</div><div class='long'><p>MixedCollection has a generic way to fetch keys if you implement getKey. The default implementation simply\nreturns <strong><code>item.id</code></strong> but you can provide your own implementation to return a different value as in the following\nexamples:</p>\n\n<pre><code>// normal way\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\nmc.add(someEl.dom.id, someEl);\nmc.add(otherEl.dom.id, otherEl);\n//and so on\n\n// using getKey\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>();\nmc.getKey = function(el){\n   return el.dom.id;\n};\nmc.add(someEl);\nmc.add(otherEl);\n\n// or via the constructor\nvar mc = new <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a>(false, function(el){\n   return el.dom.id;\n});\nmc.add(someEl);\nmc.add(otherEl);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The item for which to find the key.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The key for the passed item.</p>\n</div></li></ul></div></div></div><div id='method-getRange' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-getRange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-getRange' class='name expandable'>getRange</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> startIndex, <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> endIndex</span> ) : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></div><div class='description'><div class='short'>Returns a range of items in this collection ...</div><div class='long'><p>Returns a range of items in this collection</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The starting index. Defaults to 0.</p>\n</div></li><li><span class='pre'>endIndex</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The ending index. Defaults to the last item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span><div class='sub-desc'><p>An array of items</p>\n</div></li></ul></div></div></div><div id='method-hasConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-hasConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-hasConfig' class='name expandable'>hasConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> name</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>name</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-indexOf' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-indexOf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-indexOf' class='name expandable'>indexOf</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> item</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns index within the collection of the passed Object. ...</div><div class='long'><p>Returns index within the collection of the passed Object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The item to find the index of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>index of the item. Returns -1 if not found.</p>\n</div></li></ul></div></div></div><div id='method-indexOfKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-indexOfKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-indexOfKey' class='name expandable'>indexOfKey</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> key</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns index within the collection of the passed key. ...</div><div class='long'><p>Returns index within the collection of the passed key.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key to find the index of.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>index of the key.</p>\n</div></li></ul></div></div></div><div id='method-initConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-initConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-initConfig' class='name expandable'>initConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> instanceConfig</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Initialize configuration for this class. ...</div><div class='long'><p>Initialize configuration for this class. a typical example:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.awesome.Class', {\n    // The default config\n    config: {\n        name: 'Awesome',\n        isAwesome: true\n    },\n\n    constructor: function(config) {\n        this.initConfig(config);\n    }\n});\n\nvar awesome = new My.awesome.Class({\n    name: 'Super Awesome'\n});\n\nalert(awesome.getName()); // 'Super Awesome'\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>instanceConfig</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>mixins The mixin prototypes as key - value pairs</p>\n</div></li></ul></div></div></div><div id='method-insert' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-insert' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-insert' class='name expandable'>insert</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> index, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> key, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> item</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Inserts an item at the specified index in the collection. ...</div><div class='long'><p>Inserts an item at the specified index in the collection. Fires the <a href=\"#!/api/Ext.util.Collection-method-add\" rel=\"Ext.util.Collection-method-add\" class=\"docClass\">add</a> event when complete.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index to insert the item at.</p>\n</div></li><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key to associate with the new item, or the item itself.</p>\n</div></li><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>If the second parameter was a key, the new item.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The item inserted.</p>\n</div></li></ul></div></div></div><div id='method-last' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-last' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-last' class='name expandable'>last</a>( <span class='pre'></span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Returns the last item in the collection. ...</div><div class='long'><p>Returns the last item in the collection.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>the last item in the collection..</p>\n</div></li></ul></div></div></div><div id='method-lookup' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.StoreManager'>Ext.data.StoreManager</span><br/><a href='source/StoreManager.html#Ext-data-StoreManager-method-lookup' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.StoreManager-method-lookup' class='name expandable'>lookup</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> store</span> ) : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a></div><div class='description'><div class='short'>Gets a registered Store by id ...</div><div class='long'><p>Gets a registered Store by id</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>store</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The id of the Store, or a Store instance, or a store configuration</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-onConfigUpdate' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-onConfigUpdate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-onConfigUpdate' class='name expandable'>onConfigUpdate</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> names, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> callback, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> scope</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>names</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>callback</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>scope</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-register' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.StoreManager'>Ext.data.StoreManager</span><br/><a href='source/StoreManager.html#Ext-data-StoreManager-method-register' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.StoreManager-method-register' class='name expandable'>register</a>( <span class='pre'><a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>... stores</span> )</div><div class='description'><div class='short'>Registers one or more Stores with the StoreManager. ...</div><div class='long'><p>Registers one or more Stores with the StoreManager. You do not normally need to register stores manually. Any\nstore initialized with a <a href=\"#!/api/Ext.data.Store-cfg-storeId\" rel=\"Ext.data.Store-cfg-storeId\" class=\"docClass\">Ext.data.Store.storeId</a> will be auto-registered.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>stores</span> : <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>...<div class='sub-desc'><p>Any number of Store instances</p>\n</div></li></ul></div></div></div><div id='method-remove' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-remove' class='name expandable'>remove</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> item</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Remove an item from the collection. ...</div><div class='long'><p>Remove an item from the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The item to remove.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The item removed or false if no item was removed.</p>\n</div></li></ul></div></div></div><div id='method-removeAll' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-removeAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-removeAll' class='name expandable'>removeAll</a>( <span class='pre'><a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> items</span> ) : <a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></div><div class='description'><div class='short'>Remove all items in the passed array from the collection. ...</div><div class='long'><p>Remove all items in the passed array from the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>items</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>An array of items to be removed.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.util.MixedCollection\" rel=\"Ext.util.MixedCollection\" class=\"docClass\">Ext.util.MixedCollection</a></span><div class='sub-desc'><p>this object</p>\n</div></li></ul></div></div></div><div id='method-removeAt' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-removeAt' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-removeAt' class='name expandable'>removeAt</a>( <span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a> index</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Remove an item from a specified index in the collection. ...</div><div class='long'><p>Remove an item from a specified index in the collection. Fires the <a href=\"#!/api/Ext.util.Collection-method-remove\" rel=\"Ext.util.Collection-method-remove\" class=\"docClass\">remove</a> event when complete.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index within the collection of the item to remove.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The item removed or false if no item was removed.</p>\n</div></li></ul></div></div></div><div id='method-removeAtKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-removeAtKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-removeAtKey' class='name expandable'>removeAtKey</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> key</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Removed an item associated with the passed key fom the collection. ...</div><div class='long'><p>Removed an item associated with the passed key fom the collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>key</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key of the item to remove.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The item removed or false if no item was removed.</p>\n</div></li></ul></div></div></div><div id='method-replace' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Collection' rel='Ext.util.Collection' class='defined-in docClass'>Ext.util.Collection</a><br/><a href='source/Collection.html#Ext-util-Collection-method-replace' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Collection-method-replace' class='name expandable'>replace</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> oldKey, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> item</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Replaces an item in the collection. ...</div><div class='long'><p>Replaces an item in the collection. Fires the <a href=\"#!/api/Ext.util.Collection-method-replace\" rel=\"Ext.util.Collection-method-replace\" class=\"docClass\">replace</a> event when complete.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oldKey</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The key associated with the item to replace, or the replacement item.</p>\n\n<p>If you supplied a <a href=\"#!/api/Ext.util.Collection-method-getKey\" rel=\"Ext.util.Collection-method-getKey\" class=\"docClass\">getKey</a> implementation for this MixedCollection, or if the key of your stored items is\nin a property called <strong>id</strong>, then the MixedCollection will be able to <em>derive</em> the key of the replacement item.\nIf you want to replace an item with one having the same key value, then just pass the replacement item in this\nparameter.</p>\n</div></li><li><span class='pre'>item</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>{Object} item (optional) If the first parameter passed was a key, the item to associate with\nthat key.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'><p>The new item.</p>\n</div></li></ul></div></div></div><div id='method-setConfig' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-setConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-setConfig' class='name expandable'>setConfig</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> applyIfNotSet</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li><li><span class='pre'>applyIfNotSet</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-statics' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Base' rel='Ext.Base' class='defined-in docClass'>Ext.Base</a><br/><a href='source/Base.html#Ext-Base-method-statics' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Base-method-statics' class='name expandable'>statics</a>( <span class='pre'></span> ) : <a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a><strong class='protected signature'>protected</strong></div><div class='description'><div class='short'>Get the reference to the class from which this object was instantiated. ...</div><div class='long'><p>Get the reference to the class from which this object was instantiated. Note that unlike <a href=\"#!/api/Ext.Base-property-self\" rel=\"Ext.Base-property-self\" class=\"docClass\">self</a>,\n<code>this.statics()</code> is scope-independent and it always returns the class from which it was called, regardless of what\n<code>this</code> points to during run-time</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.Cat', {\n    statics: {\n        totalCreated: 0,\n        speciesName: 'Cat' // My.Cat.speciesName = 'Cat'\n    },\n\n    constructor: function() {\n        var statics = this.statics();\n\n        alert(statics.speciesName);     // always equals to 'Cat' no matter what 'this' refers to\n                                        // equivalent to: My.Cat.speciesName\n\n        alert(this.self.speciesName);   // dependent on 'this'\n\n        statics.totalCreated++;\n    },\n\n    clone: function() {\n        var cloned = new this.self;                      // dependent on 'this'\n\n        cloned.groupName = this.statics().speciesName;   // equivalent to: My.Cat.speciesName\n\n        return cloned;\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('My.SnowLeopard', {\n    extend: 'My.Cat',\n\n    statics: {\n        speciesName: 'Snow Leopard'     // My.SnowLeopard.speciesName = 'Snow Leopard'\n    },\n\n    constructor: function() {\n        this.callParent();\n    }\n});\n\nvar cat = new My.Cat();                 // alerts 'Cat', then alerts 'Cat'\n\nvar snowLeopard = new My.SnowLeopard(); // alerts 'Cat', then alerts 'Snow Leopard'\n\nvar clone = snowLeopard.clone();\nalert(<a href=\"#!/api/Ext-method-getClassName\" rel=\"Ext-method-getClassName\" class=\"docClass\">Ext.getClassName</a>(clone));         // alerts 'My.SnowLeopard'\nalert(clone.groupName);                 // alerts 'Cat'\n\nalert(My.Cat.totalCreated);             // alerts 3\n</code></pre>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Class\" rel=\"Ext.Class\" class=\"docClass\">Ext.Class</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-unregister' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.StoreManager'>Ext.data.StoreManager</span><br/><a href='source/StoreManager.html#Ext-data-StoreManager-method-unregister' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.StoreManager-method-unregister' class='name expandable'>unregister</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>... stores</span> )</div><div class='description'><div class='short'>Unregisters one or more Stores with the StoreManager ...</div><div class='long'><p>Unregisters one or more Stores with the StoreManager</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>stores</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a>...<div class='sub-desc'><p>Any number of Store instances or ID-s</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"requires":[],"meta":{"docauthor":["Evan Trimboli <evan@sencha.com>"]},"files":[{"href":"StoreManager.html#Ext-data-StoreManager","filename":"StoreManager.js"}]});