Ext.data.JsonP.Ext_data_Validations({"inheritdoc":null,"aliases":{},"extends":null,"alternateClassNames":["Ext.data.validations"],"uses":[],"singleton":true,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[],"property":[]},"component":false,"tagname":"class","code_type":"ext_define","members":{"css_var":[],"css_mixin":[],"cfg":[],"method":[{"owner":"Ext.data.Validations","tagname":"method","name":"email","id":"method-email","meta":{}},{"owner":"Ext.data.Validations","tagname":"method","name":"exclusion","id":"method-exclusion","meta":{}},{"owner":"Ext.data.Validations","tagname":"method","name":"format","id":"method-format","meta":{}},{"owner":"Ext.data.Validations","tagname":"method","name":"getMessage","id":"method-getMessage","meta":{}},{"owner":"Ext.data.Validations","tagname":"method","name":"inclusion","id":"method-inclusion","meta":{}},{"owner":"Ext.data.Validations","tagname":"method","name":"length","id":"method-length","meta":{}},{"owner":"Ext.data.Validations","tagname":"method","name":"presence","id":"method-presence","meta":{}}],"event":[],"property":[{"owner":"Ext.data.Validations","tagname":"property","name":"emailMessage","id":"property-emailMessage","meta":{}},{"owner":"Ext.data.Validations","tagname":"property","name":"emailRe","id":"property-emailRe","meta":{}},{"owner":"Ext.data.Validations","tagname":"property","name":"exclusionMessage","id":"property-exclusionMessage","meta":{}},{"owner":"Ext.data.Validations","tagname":"property","name":"formatMessage","id":"property-formatMessage","meta":{}},{"owner":"Ext.data.Validations","tagname":"property","name":"inclusionMessage","id":"property-inclusionMessage","meta":{}},{"owner":"Ext.data.Validations","tagname":"property","name":"lengthMessage","id":"property-lengthMessage","meta":{}},{"owner":"Ext.data.Validations","tagname":"property","name":"presenceMessage","id":"property-presenceMessage","meta":{}}]},"superclasses":[],"html_meta":{"author":null},"private":false,"mixedInto":[],"name":"Ext.data.Validations","mixins":[],"inheritable":false,"subclasses":[],"id":"class-Ext.data.Validations","html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>Ext.data.validations</div><h4>Files</h4><div class='dependency'><a href='source/Validations.html#Ext-data-Validations' target='_blank'>Validations.js</a></div></pre><div class='doc-contents'><p>This singleton contains a set of validation functions that can be used to validate any type of data. They are most\noften used in <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Models</a>, where they are automatically set up and executed.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-emailMessage' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-property-emailMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-property-emailMessage' class='name expandable'>emailMessage</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default error message used when an email validation fails ...</div><div class='long'><p>The default error message used when an email validation fails</p>\n<p>Defaults to: <code>&quot;is not a valid email address&quot;</code></p></div></div></div><div id='property-emailRe' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-property-emailRe' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-property-emailRe' class='name expandable'>emailRe</a><span> : <a href=\"#!/api/RegExp\" rel=\"RegExp\" class=\"docClass\">RegExp</a></span></div><div class='description'><div class='short'>The regular expression used to validate email addresses ...</div><div class='long'><p>The regular expression used to validate email addresses</p>\n<p>Defaults to: <code>/^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$/</code></p></div></div></div><div id='property-exclusionMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-property-exclusionMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-property-exclusionMessage' class='name expandable'>exclusionMessage</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default error message used when an exclusion validation fails. ...</div><div class='long'><p>The default error message used when an exclusion validation fails.</p>\n<p>Defaults to: <code>&quot;is not an acceptable value&quot;</code></p></div></div></div><div id='property-formatMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-property-formatMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-property-formatMessage' class='name expandable'>formatMessage</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>The default error message used when a format validation fails. ...</div><div class='long'><p>The default error message used when a format validation fails.</p>\n<p>Defaults to: <code>&quot;is the wrong format&quot;</code></p></div></div></div><div id='property-inclusionMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-property-inclusionMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-property-inclusionMessage' class='name expandable'>inclusionMessage</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default error message used when an inclusion validation fails. ...</div><div class='long'><p>The default error message used when an inclusion validation fails.</p>\n<p>Defaults to: <code>&quot;is not included in the list of acceptable values&quot;</code></p></div></div></div><div id='property-lengthMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-property-lengthMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-property-lengthMessage' class='name expandable'>lengthMessage</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default error message used when a length validation fails. ...</div><div class='long'><p>The default error message used when a length validation fails.</p>\n<p>Defaults to: <code>&quot;is the wrong length&quot;</code></p></div></div></div><div id='property-presenceMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-property-presenceMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-property-presenceMessage' class='name expandable'>presenceMessage</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The default error message used when a presence validation fails. ...</div><div class='long'><p>The default error message used when a presence validation fails.</p>\n<p>Defaults to: <code>&quot;must be present&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-email' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-method-email' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-method-email' class='name expandable'>email</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> email</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Validates that an email string is in the correct format ...</div><div class='long'><p>Validates that an email string is in the correct format</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Config object</p>\n</div></li><li><span class='pre'>email</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The email address</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the value passes validation</p>\n</div></li></ul></div></div></div><div id='method-exclusion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-method-exclusion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-method-exclusion' class='name expandable'>exclusion</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Validates that the given value is present in the configured list. ...</div><div class='long'><p>Validates that the given value is present in the configured <code>list</code>.\nFor example:</p>\n\n<pre><code>validations: [{type: 'exclusion', field: 'username', list: ['Admin', 'Operator']}]\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Config object</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value to validate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the value is not present in the list</p>\n</div></li></ul></div></div></div><div id='method-format' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-method-format' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-method-format' class='name expandable'>format</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the given value passes validation against the configured matcher regex. ...</div><div class='long'><p>Returns true if the given value passes validation against the configured <code>matcher</code> regex.\nFor example:</p>\n\n<pre><code>validations: [{type: 'format', field: 'username', matcher: /([a-z]+)[0-9]{2,3}/}]\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Config object</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value to validate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the value passes the format validation</p>\n</div></li></ul></div></div></div><div id='method-getMessage' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-method-getMessage' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-method-getMessage' class='name expandable'>getMessage</a>( <span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> type</span> )</div><div class='description'><div class='short'>Returns the configured error message for any of the validation types. ...</div><div class='long'><p>Returns the configured error message for any of the validation types.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>type</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of validation you want to get the error message for.</p>\n</div></li></ul></div></div></div><div id='method-inclusion' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-method-inclusion' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-method-inclusion' class='name expandable'>inclusion</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Validates that the given value is present in the configured list. ...</div><div class='long'><p>Validates that the given value is present in the configured <code>list</code>.\nFor example:</p>\n\n<pre><code>validations: [{type: 'inclusion', field: 'gender', list: ['Male', 'Female']}]\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Config object</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value to validate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the value is present in the list</p>\n</div></li></ul></div></div></div><div id='method-length' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-method-length' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-method-length' class='name expandable'>length</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Returns true if the given value is between the configured min and max values. ...</div><div class='long'><p>Returns true if the given value is between the configured min and max values.\nFor example:</p>\n\n<pre><code>validations: [{type: 'length', field: 'name', min: 2}]\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Config object</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The value to validate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if the value passes validation</p>\n</div></li></ul></div></div></div><div id='method-presence' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Validations'>Ext.data.Validations</span><br/><a href='source/Validations.html#Ext-data-Validations-method-presence' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Validations-method-presence' class='name expandable'>presence</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> value</span> ) : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></div><div class='description'><div class='short'>Validates that the given value is present. ...</div><div class='long'><p>Validates that the given value is present.\nFor example:</p>\n\n<pre><code>validations: [{type: 'presence', field: 'age'}]\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>Config object</p>\n</div></li><li><span class='pre'>value</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The value to validate</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span><div class='sub-desc'><p>True if validation passed</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"requires":[],"meta":{"author":["Ed Spencer"]},"files":[{"href":"Validations.html#Ext-data-Validations","filename":"Validations.js"}]});