Ext.data.JsonP.Ext_data_association_Association({"inheritdoc":null,"aliases":{},"extends":null,"alternateClassNames":["Ext.data.Association"],"uses":[],"singleton":false,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[],"property":[]},"component":false,"tagname":"class","code_type":"ext_define","members":{"css_var":[],"css_mixin":[],"cfg":[{"owner":"Ext.data.association.Association","tagname":"cfg","name":"associatedModel","id":"cfg-associatedModel","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"associationKey","id":"cfg-associationKey","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"ownerModel","id":"cfg-ownerModel","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"primaryKey","id":"cfg-primaryKey","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"reader","id":"cfg-reader","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"type","id":"cfg-type","meta":{}}],"method":[{"owner":"Ext.data.association.Association","tagname":"method","name":"constructor","id":"method-constructor","meta":{}}],"event":[],"property":[]},"superclasses":[],"html_meta":{"author":null},"private":false,"mixedInto":[],"name":"Ext.data.association.Association","mixins":[],"inheritable":false,"subclasses":["Ext.data.association.BelongsTo","Ext.data.association.HasMany","Ext.data.association.HasOne"],"id":"class-Ext.data.association.Association","html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>Ext.data.Association</div><h4>Requires</h4><div class='dependency'><a href='#!/api/Ext.data.ModelManager' rel='Ext.data.ModelManager' class='docClass'>Ext.data.ModelManager</a></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.data.association.BelongsTo' rel='Ext.data.association.BelongsTo' class='docClass'>Ext.data.association.BelongsTo</a></div><div class='dependency'><a href='#!/api/Ext.data.association.HasMany' rel='Ext.data.association.HasMany' class='docClass'>Ext.data.association.HasMany</a></div><div class='dependency'><a href='#!/api/Ext.data.association.HasOne' rel='Ext.data.association.HasOne' class='docClass'>Ext.data.association.HasOne</a></div><h4>Files</h4><div class='dependency'><a href='source/Association.html#Ext-data-association-Association' target='_blank'>Association.js</a></div></pre><div class='doc-contents'><p>Associations enable you to express relationships between different <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Models</a>. Let's say we're\nwriting an ecommerce system where Users can make Orders - there's a relationship between these Models that we can\nexpress like this:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    config: {\n        fields: ['id', 'name', 'email'],\n        hasMany: {model: 'Order', name: 'orders'}\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Order', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    config: {\n        fields: ['id', 'user_id', 'status', 'price'],\n        belongsTo: 'User'\n    }\n});\n</code></pre>\n\n\n\n\n<p>We've set up two models - User and Order - and told them about each other. You can set up as many associations on\neach Model as you need using the two default types - <a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">hasMany</a> and\n<a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">belongsTo</a>. There's much more detail on the usage of each of those inside their\ndocumentation pages. If you're not familiar with Models already, <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">there is plenty on those too</a>.</p>\n\n\n\n\n<p><u>Further Reading</u></p>\n\n\n\n\n<ul style=\"list-style-type: disc; padding-left: 20px;\">\n  <li><a href=\"#!/api/Ext.data.association.HasMany\" rel=\"Ext.data.association.HasMany\" class=\"docClass\">hasMany associations</a></li>\n  <li><a href=\"#!/api/Ext.data.association.BelongsTo\" rel=\"Ext.data.association.BelongsTo\" class=\"docClass\">belongsTo associations</a></li>\n  <li><a href=\"#!/api/Ext.data.association.HasOne\" rel=\"Ext.data.association.HasOne\" class=\"docClass\">hasOne associations</a></li>\n  <li><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">using Models</a></li>\n</ul>\n\n\n<p><b>Self association models</b></p>\n\n<p>We can also have models that create parent/child associations between the same type. Below is an example, where\ngroups can be nested inside other groups:</p>\n\n\n<pre><code>\n// Server Data\n{\n    \"groups\": {\n        \"id\": 10,\n        \"parent_id\": 100,\n        \"name\": \"Main Group\",\n        \"parent_group\": {\n            \"id\": 100,\n            \"parent_id\": null,\n            \"name\": \"Parent Group\"\n        },\n        \"child_groups\": [{\n            \"id\": 2,\n            \"parent_id\": 10,\n            \"name\": \"Child Group 1\"\n        },{\n            \"id\": 3,\n            \"parent_id\": 10,\n            \"name\": \"Child Group 2\"\n        },{\n            \"id\": 4,\n            \"parent_id\": 10,\n            \"name\": \"Child Group 3\"\n        }]\n    }\n}\n\n// Client code\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Group', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    config: {\n        fields: ['id', 'parent_id', 'name'],\n        proxy: {\n            type: 'ajax',\n            url: 'data.json',\n            reader: {\n                type: 'json',\n                root: 'groups'\n            }\n        },\n        associations: [{\n            type: 'hasMany',\n            model: 'Group',\n            primaryKey: 'id',\n            foreignKey: 'parent_id',\n            autoLoad: true,\n            associationKey: 'child_groups' // read child data from child_groups\n        }, {\n            type: 'belongsTo',\n            model: 'Group',\n            primaryKey: 'id',\n            foreignKey: 'parent_id',\n            associationKey: 'parent_group' // read parent data from parent_group\n        }]\n    }\n});\n\n\n<a href=\"#!/api/Ext-method-onReady\" rel=\"Ext-method-onReady\" class=\"docClass\">Ext.onReady</a>(function(){\n\n    Group.load(10, {\n        success: function(group){\n            console.log(group.getGroup().get('name'));\n\n            group.groups().each(function(rec){\n                console.log(rec.get('name'));\n            });\n        }\n    });\n\n});\n</code></pre>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-associatedModel' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.Association'>Ext.data.association.Association</span><br/><a href='source/Association.html#Ext-data-association-Association-cfg-associatedModel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-associatedModel' class='name expandable'>associatedModel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The string name of the model that is being associated with. ...</div><div class='long'><p>The string name of the model that is being associated with. Required</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-associationKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.Association'>Ext.data.association.Association</span><br/><a href='source/Association.html#Ext-data-association-Association-cfg-associationKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-associationKey' class='name expandable'>associationKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the property in the data to read the association from. ...</div><div class='long'><p>The name of the property in the data to read the association from.\nDefaults to the name of the associated model.</p>\n</div></div></div><div id='cfg-ownerModel' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.Association'>Ext.data.association.Association</span><br/><a href='source/Association.html#Ext-data-association-Association-cfg-ownerModel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-ownerModel' class='name expandable'>ownerModel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The string name of the model that owns the association. ...</div><div class='long'><p>The string name of the model that owns the association. Required</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-primaryKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.Association'>Ext.data.association.Association</span><br/><a href='source/Association.html#Ext-data-association-Association-cfg-primaryKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-primaryKey' class='name expandable'>primaryKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the primary key on the associated model. ...</div><div class='long'><p>The name of the primary key on the associated model. Defaults to 'id'.\nIn general this will be the <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">Ext.data.Model.idProperty</a> of the Model.</p>\n<p>Defaults to: <code>&quot;id&quot;</code></p></div></div></div><div id='cfg-reader' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.Association'>Ext.data.association.Association</span><br/><a href='source/Association.html#Ext-data-association-Association-cfg-reader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-reader' class='name expandable'>reader</a><span> : <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a></span></div><div class='description'><div class='short'>A special reader to read associated data ...</div><div class='long'><p>A special reader to read associated data</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-type' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.Association'>Ext.data.association.Association</span><br/><a href='source/Association.html#Ext-data-association-Association-cfg-type' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-type' class='name expandable'>type</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The type configuration can be used when creating associations using a configuration object. ...</div><div class='long'><p>The type configuration can be used when creating associations using a configuration object.\nUse 'hasMany' to create a HasMany association</p>\n\n<pre><code>    associations: [{\n        type: 'hasMany',\n        model: 'User'\n    }]\n</code></pre>\n\n<p>Defaults to: <code>null</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.Association'>Ext.data.association.Association</span><br/><a href='source/Association.html#Ext-data-association-Association-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.association.Association-method-constructor' class='name expandable'>Ext.data.association.Association</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates the Association object. ...</div><div class='long'><p>Creates the Association object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Config object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"requires":["Ext.data.ModelManager"],"meta":{"author":["Ed Spencer"]},"files":[{"href":"Association.html#Ext-data-association-Association","filename":"Association.js"}]});