Ext.data.JsonP.Ext_data_association_HasMany({"inheritdoc":null,"aliases":{"association":["hasmany"]},"extends":"Ext.data.association.Association","alternateClassNames":["Ext.data.HasManyAssociation"],"uses":[],"singleton":false,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[],"property":[]},"component":false,"tagname":"class","code_type":"ext_define","members":{"css_var":[],"css_mixin":[],"cfg":[{"owner":"Ext.data.association.Association","tagname":"cfg","name":"associatedModel","id":"cfg-associatedModel","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"associationKey","id":"cfg-associationKey","meta":{}},{"owner":"Ext.data.association.HasMany","tagname":"cfg","name":"autoLoad","id":"cfg-autoLoad","meta":{}},{"owner":"Ext.data.association.HasMany","tagname":"cfg","name":"filterProperty","id":"cfg-filterProperty","meta":{}},{"owner":"Ext.data.association.HasMany","tagname":"cfg","name":"foreignKey","id":"cfg-foreignKey","meta":{}},{"owner":"Ext.data.association.HasMany","tagname":"cfg","name":"name","id":"cfg-name","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"ownerModel","id":"cfg-ownerModel","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"primaryKey","id":"cfg-primaryKey","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"reader","id":"cfg-reader","meta":{}},{"owner":"Ext.data.association.HasMany","tagname":"cfg","name":"store","id":"cfg-store","meta":{}},{"owner":"Ext.data.association.HasMany","tagname":"cfg","name":"storeName","id":"cfg-storeName","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"type","id":"cfg-type","meta":{}}],"method":[{"owner":"Ext.data.association.Association","tagname":"method","name":"constructor","id":"method-constructor","meta":{}},{"owner":"Ext.data.association.HasMany","tagname":"method","name":"applyStore","id":"method-applyStore","meta":{"private":true}},{"owner":"Ext.data.association.HasMany","tagname":"method","name":"read","id":"method-read","meta":{"private":true}}],"event":[],"property":[]},"superclasses":["Ext.data.association.Association","Ext.data.association.HasMany"],"html_meta":{"author":null},"private":false,"mixedInto":[],"name":"Ext.data.association.HasMany","mixins":[],"inheritable":false,"subclasses":[],"id":"class-Ext.data.association.HasMany","html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>Ext.data.HasManyAssociation</div><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='docClass'>Ext.data.association.Association</a><div class='subclass '><strong>Ext.data.association.HasMany</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/Ext.util.Inflector' rel='Ext.util.Inflector' class='docClass'>Ext.util.Inflector</a></div><h4>Files</h4><div class='dependency'><a href='source/HasMany.html#Ext-data-association-HasMany' target='_blank'>HasMany.js</a></div></pre><div class='doc-contents'><p>Represents a one-to-many relationship between two models. Usually created indirectly via a model definition:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Product', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'id',      type: 'int'},\n        {name: 'user_id', type: 'int'},\n        {name: 'name',    type: 'string'}\n    ]\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        {name: 'id',   type: 'int'},\n        {name: 'name', type: 'string'}\n    ],\n    // we can use the hasMany shortcut on the model to create a hasMany association\n    hasMany: {model: 'Product', name: 'products'}\n});\n</pre>\n\n\n<p></code></p>\n\n<p>Above we created Product and User models, and linked them by saying that a User hasMany Products. This gives\nus a new function on every User instance, in this case the function is called 'products' because that is the name\nwe specified in the association configuration above.</p>\n\n\n\n\n<p>This new function returns a specialized <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a> which is automatically filtered to load\nonly Products for the given model instance:</p>\n\n\n\n\n<pre><code>//first, we load up a User with id of 1\nvar user = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('User', {id: 1, name: 'Ed'});\n\n//the user.products function was created automatically by the association and returns a <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Store</a>\n//the created store is automatically scoped to the set of Products for the User with id of 1\nvar products = user.products();\n\n//we still have all of the usual Store functions, for example it's easy to add a Product for this User\nproducts.add({\n    name: 'Another Product'\n});\n\n//saves the changes to the store - this automatically sets the new Product's user_id to 1 before saving\nproducts.sync();\n</code></pre>\n\n\n\n\n<p>The new Store is only instantiated the first time you call products() to conserve memory and processing time,\nthough calling products() a second time returns the same store instance.</p>\n\n\n\n\n<p><u>Custom filtering</u></p>\n\n\n\n\n<p>The Store is automatically furnished with a filter - by default this filter tells the store to only return\nrecords where the associated model's foreign key matches the owner model's primary key. For example, if a User\nwith ID = 100 hasMany Products, the filter loads only Products with user_id == 100.</p>\n\n\n\n\n<p>Sometimes we want to filter by another field - for example in the case of a Twitter search application we may\nhave models for Search and Tweet:</p>\n\n\n\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Search', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    config: {\n        fields: [\n            'id', 'query'\n        ],\n\n        hasMany: {\n            model: 'Tweet',\n            name : 'tweets',\n            filterProperty: 'query'\n        }\n    }\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Tweet', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    config: {\n        fields: [\n            'id', 'text', 'from_user'\n        ]\n    }\n});\n\n//returns a Store filtered by the filterProperty\nvar store = new Search({query: 'Sencha Touch'}).tweets();\n</code></pre>\n\n\n\n\n<p>The tweets association above is filtered by the query property by setting the <a href=\"#!/api/Ext.data.association.HasMany-cfg-filterProperty\" rel=\"Ext.data.association.HasMany-cfg-filterProperty\" class=\"docClass\">filterProperty</a>, and is\nequivalent to this:</p>\n\n\n\n\n<pre><code>var store = <a href=\"#!/api/Ext-method-create\" rel=\"Ext-method-create\" class=\"docClass\">Ext.create</a>('<a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a>', {\n    model: 'Tweet',\n    filters: [\n        {\n            property: 'query',\n            value   : 'Sencha Touch'\n        }\n    ]\n});\n</code></pre>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-associatedModel' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-associatedModel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-associatedModel' class='name expandable'>associatedModel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The string name of the model that is being associated with. ...</div><div class='long'><p>The string name of the model that is being associated with. Required</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-associationKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-associationKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-associationKey' class='name expandable'>associationKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the property in the data to read the association from. ...</div><div class='long'><p>The name of the property in the data to read the association from.\nDefaults to the name of the associated model.</p>\n</div></div></div><div id='cfg-autoLoad' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasMany'>Ext.data.association.HasMany</span><br/><a href='source/HasMany.html#Ext-data-association-HasMany-cfg-autoLoad' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasMany-cfg-autoLoad' class='name expandable'>autoLoad</a><span> : <a href=\"#!/api/Boolean\" rel=\"Boolean\" class=\"docClass\">Boolean</a></span></div><div class='description'><div class='short'>True to automatically load the related store from a remote source when instantiated. ...</div><div class='long'><p>True to automatically load the related store from a remote source when instantiated.\nDefaults to <tt>false</tt>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-filterProperty' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasMany'>Ext.data.association.HasMany</span><br/><a href='source/HasMany.html#Ext-data-association-HasMany-cfg-filterProperty' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasMany-cfg-filterProperty' class='name expandable'>filterProperty</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optionally overrides the default filter that is set up on the associated Store. ...</div><div class='long'><p>Optionally overrides the default filter that is set up on the associated Store. If\nthis is not set, a filter is automatically created which filters the association based on the configured\n<a href=\"#!/api/Ext.data.association.HasMany-cfg-foreignKey\" rel=\"Ext.data.association.HasMany-cfg-foreignKey\" class=\"docClass\">foreignKey</a>. See intro docs for more details. Defaults to null.</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-foreignKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasMany'>Ext.data.association.HasMany</span><br/><a href='source/HasMany.html#Ext-data-association-HasMany-cfg-foreignKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasMany-cfg-foreignKey' class='name expandable'>foreignKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the foreign key on the associated model that links it to the owner\nmodel. ...</div><div class='long'><p>The name of the foreign key on the associated model that links it to the owner\nmodel. Defaults to the lowercased name of the owner model plus \"_id\", e.g. an association with a\nmodel called Group hasMany Users would create 'group_id' as the foreign key. When the remote store is loaded,\nthe store is automatically filtered so that only records with a matching foreign key are included in the\nresulting child store. This can be overridden by specifying the <a href=\"#!/api/Ext.data.association.HasMany-cfg-filterProperty\" rel=\"Ext.data.association.HasMany-cfg-filterProperty\" class=\"docClass\">filterProperty</a>.</p>\n\n<pre><code>    <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Group', {\n        extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n        fields: ['id', 'name'],\n        hasMany: 'User'\n    });\n\n    <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('User', {\n        extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n        fields: ['id', 'name', 'group_id'], // refers to the id of the group that this user belongs to\n        belongsTo: 'Group'\n    });\n</code></pre>\n\n</div></div></div><div id='cfg-name' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasMany'>Ext.data.association.HasMany</span><br/><a href='source/HasMany.html#Ext-data-association-HasMany-cfg-name' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasMany-cfg-name' class='name expandable'>name</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the function to create on the owner model to retrieve the child store. ...</div><div class='long'><p>The name of the function to create on the owner model to retrieve the child store.\nIf not specified, the pluralized name of the child model is used.</p>\n\n<pre><code>        // This will create a users() method on any Group model instance\n        <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Group', {\n            extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n            fields: ['id', 'name'],\n            hasMany: 'User'\n        });\n        var group = new Group();\n        console.log(group.users());\n\n        // The method to retrieve the users will now be getUserList\n        <a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Group', {\n            extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n            fields: ['id', 'name'],\n            hasMany: {model: 'User', name: 'getUserList'}\n        });\n        var group = new Group();\n        console.log(group.getUserList());\n</code></pre>\n\n</div></div></div><div id='cfg-ownerModel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-ownerModel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-ownerModel' class='name expandable'>ownerModel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The string name of the model that owns the association. ...</div><div class='long'><p>The string name of the model that owns the association. Required</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-primaryKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-primaryKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-primaryKey' class='name expandable'>primaryKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the primary key on the associated model. ...</div><div class='long'><p>The name of the primary key on the associated model. Defaults to 'id'.\nIn general this will be the <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">Ext.data.Model.idProperty</a> of the Model.</p>\n<p>Defaults to: <code>&quot;id&quot;</code></p></div></div></div><div id='cfg-reader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-reader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-reader' class='name expandable'>reader</a><span> : <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a></span></div><div class='description'><div class='short'>A special reader to read associated data ...</div><div class='long'><p>A special reader to read associated data</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-store' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasMany'>Ext.data.association.HasMany</span><br/><a href='source/HasMany.html#Ext-data-association-HasMany-cfg-store' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasMany-cfg-store' class='name expandable'>store</a><span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span></div><div class='description'><div class='short'>Optional configuration object that will be passed to the generated Store. ...</div><div class='long'><p>Optional configuration object that will be passed to the generated Store. Defaults to\nan empty Object.</p>\n</div></div></div><div id='cfg-storeName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasMany'>Ext.data.association.HasMany</span><br/><a href='source/HasMany.html#Ext-data-association-HasMany-cfg-storeName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasMany-cfg-storeName' class='name expandable'>storeName</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>Optional The name of the store by which you can reference it on this class as a property. ...</div><div class='long'><p>Optional The name of the store by which you can reference it on this class as a property.</p>\n</div></div></div><div id='cfg-type' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-type' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-type' class='name expandable'>type</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The type configuration can be used when creating associations using a configuration object. ...</div><div class='long'><p>The type configuration can be used when creating associations using a configuration object.\nUse 'hasMany' to create a HasMany association</p>\n\n<pre><code>    associations: [{\n        type: 'hasMany',\n        model: 'User'\n    }]\n</code></pre>\n\n<p>Defaults to: <code>null</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.association.Association-method-constructor' class='name expandable'>Ext.data.association.HasMany</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates the Association object. ...</div><div class='long'><p>Creates the Association object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Config object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-applyStore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasMany'>Ext.data.association.HasMany</span><br/><a href='source/HasMany.html#Ext-data-association-HasMany-method-applyStore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasMany-method-applyStore' class='name expandable'>applyStore</a>( <span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> storeConfig</span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Creates a function that returns an Ext.data.Store which is configured to load a set of data filtered\nby the owner mod...</div><div class='long'><p>Creates a function that returns an <a href=\"#!/api/Ext.data.Store\" rel=\"Ext.data.Store\" class=\"docClass\">Ext.data.Store</a> which is configured to load a set of data filtered\nby the owner model's primary key - e.g. in a hasMany association where Group hasMany Users, this function\nreturns a Store configured to return the filtered set of a single Group's Users.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>storeConfig</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The store-generating function</p>\n</div></li></ul></div></div></div><div id='method-read' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasMany'>Ext.data.association.HasMany</span><br/><a href='source/HasMany.html#Ext-data-association-HasMany-method-read' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasMany-method-read' class='name expandable'>read</a>( <span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> record, <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a> reader, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> associationData</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Read associated data ...</div><div class='long'><p>Read associated data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a><div class='sub-desc'><p>The record we're writing to</p>\n</div></li><li><span class='pre'>reader</span> : <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a><div class='sub-desc'><p>The reader for the associated model</p>\n</div></li><li><span class='pre'>associationData</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The raw associated data</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"requires":["Ext.util.Inflector"],"meta":{"author":["Ed Spencer"]},"files":[{"href":"HasMany.html#Ext-data-association-HasMany","filename":"HasMany.js"}]});