Ext.data.JsonP.Ext_data_association_HasOne({"inheritdoc":null,"aliases":{"association":["hasone"]},"extends":"Ext.data.association.Association","alternateClassNames":["Ext.data.HasOneAssociation"],"uses":[],"singleton":false,"statics":{"css_var":[],"css_mixin":[],"cfg":[],"method":[],"event":[],"property":[]},"component":false,"tagname":"class","code_type":"ext_define","members":{"css_var":[],"css_mixin":[],"cfg":[{"owner":"Ext.data.association.Association","tagname":"cfg","name":"associatedModel","id":"cfg-associatedModel","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"associationKey","id":"cfg-associationKey","meta":{}},{"owner":"Ext.data.association.HasOne","tagname":"cfg","name":"foreignKey","id":"cfg-foreignKey","meta":{}},{"owner":"Ext.data.association.HasOne","tagname":"cfg","name":"getterName","id":"cfg-getterName","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"ownerModel","id":"cfg-ownerModel","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"primaryKey","id":"cfg-primaryKey","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"reader","id":"cfg-reader","meta":{}},{"owner":"Ext.data.association.HasOne","tagname":"cfg","name":"setterName","id":"cfg-setterName","meta":{}},{"owner":"Ext.data.association.Association","tagname":"cfg","name":"type","id":"cfg-type","meta":{}}],"method":[{"owner":"Ext.data.association.Association","tagname":"method","name":"constructor","id":"method-constructor","meta":{}},{"owner":"Ext.data.association.HasOne","tagname":"method","name":"createGetter","id":"method-createGetter","meta":{"private":true}},{"owner":"Ext.data.association.HasOne","tagname":"method","name":"createSetter","id":"method-createSetter","meta":{"private":true}},{"owner":"Ext.data.association.HasOne","tagname":"method","name":"read","id":"method-read","meta":{"private":true}}],"event":[],"property":[]},"superclasses":["Ext.data.association.Association","Ext.data.association.HasOne"],"html_meta":{},"private":false,"mixedInto":[],"name":"Ext.data.association.HasOne","mixins":[],"inheritable":false,"subclasses":[],"id":"class-Ext.data.association.HasOne","html":"<div><pre class=\"hierarchy\"><h4>Alternate names</h4><div class='alternate-class-name'>Ext.data.HasOneAssociation</div><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='docClass'>Ext.data.association.Association</a><div class='subclass '><strong>Ext.data.association.HasOne</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/HasOne.html#Ext-data-association-HasOne' target='_blank'>HasOne.js</a></div></pre><div class='doc-contents'><p>Represents a one to one association with another model. The owner model is expected to have\na foreign key which references the primary key of the associated model:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        { name: 'id', type: 'int' },\n        { name: 'name', type: 'string' },\n        { name: 'address_id', type: 'int'}\n    ]\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Address', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: [\n        { name: 'id', type: 'int' },\n        { name: 'number', type: 'string' },\n        { name: 'street', type: 'string' },\n        { name: 'city', type: 'string' },\n        { name: 'zip', type: 'string' },\n    ],\n    // we can use the hasOne shortcut on the model to create a hasOne association\n    associations: { type: 'hasOne', model: 'Person' }\n});\n</code></pre>\n\n<p>In the example above we have created models for People and Addresses, and linked them together\nby saying that each Person has a single Address. This automatically links each Person to an Address\nbased on the Persons address_id, and provides new functions on the Person model:</p>\n\n<h2>Generated getter function</h2>\n\n<p>The first function that is added to the owner model is a getter function:</p>\n\n<pre><code>var person = new Person({\n    id: 100,\n    address_id: 20,\n    name: 'John Smith'\n});\n\nperson.getAddress(function(address, operation) {\n    // do something with the address object\n    alert(address.get('id')); // alerts 20\n}, this);\n</code></pre>\n\n<p>The getAddress function was created on the Person model when we defined the association. This uses the\nPersons configured <a href=\"#!/api/Ext.data.proxy.Proxy\" rel=\"Ext.data.proxy.Proxy\" class=\"docClass\">proxy</a> to load the Address asynchronously, calling the provided\ncallback when it has loaded.</p>\n\n<p>The new getAddress function will also accept an object containing success, failure and callback properties\n- callback will always be called, success will only be called if the associated model was loaded successfully\nand failure will only be called if the associatied model could not be loaded:</p>\n\n<pre><code>person.getAddress({\n    reload: true, // force a reload if the owner model is already cached\n    callback: function(address, operation) {}, // a function that will always be called\n    success : function(address, operation) {}, // a function that will only be called if the load succeeded\n    failure : function(address, operation) {}, // a function that will only be called if the load did not succeed\n    scope   : this // optionally pass in a scope object to execute the callbacks in\n});\n</code></pre>\n\n<p>In each case above the callbacks are called with two arguments - the associated model instance and the\n<a href=\"#!/api/Ext.data.Operation\" rel=\"Ext.data.Operation\" class=\"docClass\">operation</a> object that was executed to load that instance. The Operation object is\nuseful when the instance could not be loaded.</p>\n\n<p>Once the getter has been called on the model, it will be cached if the getter is called a second time. To\nforce the model to reload, specify reload: true in the options object.</p>\n\n<h2>Generated setter function</h2>\n\n<p>The second generated function sets the associated model instance - if only a single argument is passed to\nthe setter then the following two calls are identical:</p>\n\n<pre><code>// this call...\nperson.setAddress(10);\n\n// is equivalent to this call:\nperson.set('address_id', 10);\n</code></pre>\n\n<p>An instance of the owner model can also be passed as a parameter.</p>\n\n<p>If we pass in a second argument, the model will be automatically saved and the second argument passed to\nthe owner model's <a href=\"#!/api/Ext.data.Model-method-save\" rel=\"Ext.data.Model-method-save\" class=\"docClass\">save</a> method:</p>\n\n<pre><code>person.setAddress(10, function(address, operation) {\n    // the address has been saved\n    alert(address.get('address_id')); //now alerts 10\n});\n\n//alternative syntax:\nperson.setAddress(10, {\n    callback: function(address, operation), // a function that will always be called\n    success : function(address, operation), // a function that will only be called if the load succeeded\n    failure : function(address, operation), // a function that will only be called if the load did not succeed\n    scope   : this //optionally pass in a scope object to execute the callbacks in\n})\n</code></pre>\n\n<h2>Customisation</h2>\n\n<p>Associations reflect on the models they are linking to automatically set up properties such as the\n<a href=\"#!/api/Ext.data.association.HasOne-cfg-primaryKey\" rel=\"Ext.data.association.HasOne-cfg-primaryKey\" class=\"docClass\">primaryKey</a> and <a href=\"#!/api/Ext.data.association.HasOne-cfg-foreignKey\" rel=\"Ext.data.association.HasOne-cfg-foreignKey\" class=\"docClass\">foreignKey</a>. These can alternatively be specified:</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n    fields: [...],\n\n    associations: [\n        { type: 'hasOne', model: 'Address', primaryKey: 'unique_id', foreignKey: 'addr_id' }\n    ]\n});\n</code></pre>\n\n<p>Here we replaced the default primary key (defaults to 'id') and foreign key (calculated as 'address_id')\nwith our own settings. Usually this will not be needed.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-associatedModel' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-associatedModel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-associatedModel' class='name expandable'>associatedModel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The string name of the model that is being associated with. ...</div><div class='long'><p>The string name of the model that is being associated with. Required</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-associationKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-associationKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-associationKey' class='name expandable'>associationKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the property in the data to read the association from. ...</div><div class='long'><p>The name of the property in the data to read the association from.\nDefaults to the name of the associated model.</p>\n</div></div></div><div id='cfg-foreignKey' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasOne'>Ext.data.association.HasOne</span><br/><a href='source/HasOne.html#Ext-data-association-HasOne-cfg-foreignKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasOne-cfg-foreignKey' class='name expandable'>foreignKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the foreign key on the owner model that links it to the associated\nmodel. ...</div><div class='long'><p>The name of the foreign key on the owner model that links it to the associated\nmodel. Defaults to the lowercased name of the associated model plus \"_id\", e.g. an association with a\nmodel called Person would set up a address_id foreign key.</p>\n\n<pre><code><a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Person', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'name', 'address_id'], // refers to the id of the address object\n    hasOne: 'Address'\n});\n\n<a href=\"#!/api/Ext-method-define\" rel=\"Ext-method-define\" class=\"docClass\">Ext.define</a>('Address', {\n    extend: '<a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a>',\n    fields: ['id', 'number', 'street', 'city', 'zip'],\n    belongsTo: 'Person'\n});\nvar Person = new Person({\n    id: 1,\n    name: 'John Smith',\n    address_id: 13\n}, 1);\nperson.getAddress(); // Will make a call to the server asking for address_id 13\n</code></pre>\n</div></div></div><div id='cfg-getterName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasOne'>Ext.data.association.HasOne</span><br/><a href='source/HasOne.html#Ext-data-association-HasOne-cfg-getterName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasOne-cfg-getterName' class='name expandable'>getterName</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the getter function that will be added to the local model's prototype. ...</div><div class='long'><p>The name of the getter function that will be added to the local model's prototype.\nDefaults to 'get' + the name of the foreign model, e.g. getAddress</p>\n</div></div></div><div id='cfg-ownerModel' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-ownerModel' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-ownerModel' class='name expandable'>ownerModel</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The string name of the model that owns the association. ...</div><div class='long'><p>The string name of the model that owns the association. Required</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-primaryKey' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-primaryKey' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-primaryKey' class='name expandable'>primaryKey</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the primary key on the associated model. ...</div><div class='long'><p>The name of the primary key on the associated model. Defaults to 'id'.\nIn general this will be the <a href=\"#!/api/Ext.data.Model-cfg-idProperty\" rel=\"Ext.data.Model-cfg-idProperty\" class=\"docClass\">Ext.data.Model.idProperty</a> of the Model.</p>\n<p>Defaults to: <code>&quot;id&quot;</code></p></div></div></div><div id='cfg-reader' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-reader' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-reader' class='name expandable'>reader</a><span> : <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a></span></div><div class='description'><div class='short'>A special reader to read associated data ...</div><div class='long'><p>A special reader to read associated data</p>\n<p>Defaults to: <code>null</code></p></div></div></div><div id='cfg-setterName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasOne'>Ext.data.association.HasOne</span><br/><a href='source/HasOne.html#Ext-data-association-HasOne-cfg-setterName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasOne-cfg-setterName' class='name expandable'>setterName</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The name of the setter function that will be added to the local model's prototype. ...</div><div class='long'><p>The name of the setter function that will be added to the local model's prototype.\nDefaults to 'set' + the name of the foreign model, e.g. setAddress</p>\n</div></div></div><div id='cfg-type' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-cfg-type' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.Association-cfg-type' class='name expandable'>type</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The type configuration can be used when creating associations using a configuration object. ...</div><div class='long'><p>The type configuration can be used when creating associations using a configuration object.\nUse 'hasMany' to create a HasMany association</p>\n\n<pre><code>    associations: [{\n        type: 'hasMany',\n        model: 'User'\n    }]\n</code></pre>\n\n<p>Defaults to: <code>null</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.data.association.Association' rel='Ext.data.association.Association' class='defined-in docClass'>Ext.data.association.Association</a><br/><a href='source/Association.html#Ext-data-association-Association-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.association.Association-method-constructor' class='name expandable'>Ext.data.association.HasOne</a>( <span class='pre'>[<a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> config]</span> ) : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></div><div class='description'><div class='short'>Creates the Association object. ...</div><div class='long'><p>Creates the Association object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> (optional)<div class='sub-desc'><p>Config object.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createGetter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasOne'>Ext.data.association.HasOne</span><br/><a href='source/HasOne.html#Ext-data-association-HasOne-method-createGetter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasOne-method-createGetter' class='name expandable'>createGetter</a>( <span class='pre'></span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Returns a getter function to be placed on the owner model's prototype. ...</div><div class='long'><p>Returns a getter function to be placed on the owner model's prototype. We cache the loaded instance\nthe first time it is loaded so that subsequent calls to the getter always receive the same reference.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The getter function</p>\n</div></li></ul></div></div></div><div id='method-createSetter' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasOne'>Ext.data.association.HasOne</span><br/><a href='source/HasOne.html#Ext-data-association-HasOne-method-createSetter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasOne-method-createSetter' class='name expandable'>createSetter</a>( <span class='pre'></span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='private signature'>private</strong></div><div class='description'><div class='short'>Returns a setter function to be placed on the owner model's prototype ...</div><div class='long'><p>Returns a setter function to be placed on the owner model's prototype</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The setter function</p>\n</div></li></ul></div></div></div><div id='method-read' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.association.HasOne'>Ext.data.association.HasOne</span><br/><a href='source/HasOne.html#Ext-data-association-HasOne-method-read' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.association.HasOne-method-read' class='name expandable'>read</a>( <span class='pre'><a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a> record, <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a> reader, <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a> associationData</span> )<strong class='private signature'>private</strong></div><div class='description'><div class='short'>Read associated data ...</div><div class='long'><p>Read associated data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>record</span> : <a href=\"#!/api/Ext.data.Model\" rel=\"Ext.data.Model\" class=\"docClass\">Ext.data.Model</a><div class='sub-desc'><p>The record we're writing to</p>\n</div></li><li><span class='pre'>reader</span> : <a href=\"#!/api/Ext.data.reader.Reader\" rel=\"Ext.data.reader.Reader\" class=\"docClass\">Ext.data.reader.Reader</a><div class='sub-desc'><p>The reader for the associated model</p>\n</div></li><li><span class='pre'>associationData</span> : <a href=\"#!/api/Object\" rel=\"Object\" class=\"docClass\">Object</a><div class='sub-desc'><p>The raw associated data</p>\n</div></li></ul></div></div></div></div></div></div></div>","allMixins":[],"requires":[],"meta":{},"files":[{"href":"HasOne.html#Ext-data-association-HasOne","filename":"HasOne.js"}]});