/* Initialize jQTouch on startup. 

   This code comes directly from jQTouch.
 */
var jQT = new $.jQTouch({
  icon: 'jqtouch.png',
  addGlossToIcon: false,
  startupScreen: 'jqt_startup.png',
  statusBar: 'black',
  preloadImages: [
    '../../themes/jqt/img/back_button.png',
    '../../themes/jqt/img/back_button_clicked.png',
    '../../themes/jqt/img/button_clicked.png',
    '../../themes/jqt/img/grayButton.png',
    '../../themes/jqt/img/whiteButton.png',
    '../../themes/jqt/img/loading.gif'
  ]
});

// Any methods for onload go here.
jQuery(document).ready(function () {
  
  // If online, show all online-only resources
  if (window.navigator.onLine) {
    jQuery('.online-required').show();
  }

  // Query for the recipe-of-the-day if the user selects the menu item
  jQuery('#recipe4').bind('pageAnimationStart', function () {

    // This routine should only populate the DOM once, so check if we have loaded before
    if (!$(this).data('loaded')) {
      jQuery.ajax({ url: "sample.json",
                  success: function (data) {
                    
                    // Set the recipe title
                    jQuery('#recipe4 h1').text(data[0].title);


                    // Create a UL and add each recipe item to it
                    var ul = jQuery('<ul class="rounded">');
                    jQuery.each(data[0].ingredients, function (index, item) {
                      jQuery('<li>').text(item).appendTo(ul);
                    });

                    // Add the ingredients list and the recipe instructions
                    jQuery('#recipe4').append(ul).append(
                      jQuery('<p>').text(data[0].instructions)
                    );                    
                  },
                  error: function (e, e2, e3) {
                    // Error-handling
                  },
                  dataType: 'json'
                }
                );
      $(this).data('loaded', true);
    }
  });
});
                         

