package com.mm214.pinch;

import com.example.pinchexample.R;

import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.ScaleGestureDetector.SimpleOnScaleGestureListener;
import android.widget.TextView;

public class PinchExampleActivity extends Activity {

	TextView scaleText;
	ScaleGestureDetector scaleGestureDetector;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_pinch_example);
		
	      scaleText = (TextView)findViewById(R.id.myTextView);
	      
	      scaleGestureDetector = 
              new ScaleGestureDetector(this, 
                    new MyOnScaleGestureListener());

	}

	@Override
	public boolean onTouchEvent(MotionEvent event) {
	     scaleGestureDetector.onTouchEvent(event);
	     return true;
	}

	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.pinch_example, menu);
		return true;
	}

	public class MyOnScaleGestureListener extends
    SimpleOnScaleGestureListener {

    @Override
    public boolean onScale(ScaleGestureDetector detector) {

       float scaleFactor = detector.getScaleFactor();
 
       if (scaleFactor > 1) {
	         scaleText.setText("Zooming Out");
        } else {
	         scaleText.setText("Zooming In");
        }
       return true;
   }

   @Override
   public boolean onScaleBegin(ScaleGestureDetector detector) {
        return true;
   }

   @Override
   public void onScaleEnd(ScaleGestureDetector detector) {

   }
}	

}
