package com.ebookfrenzy.inappbilling;

import com.ebookfrenzy.inappbilling.util.IabHelper;
import com.ebookfrenzy.inappbilling.util.IabResult;
import com.ebookfrenzy.inappbilling.util.Inventory;
import com.ebookfrenzy.inappbilling.util.Purchase;

import android.os.Bundle;
import android.app.Activity;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import android.view.View;
import android.widget.Button;

public class InAppBillingActivity extends Activity {

	private static final String TAG = "com.ebookfrenzy.inappbilling";
	IabHelper mHelper;
	static final String ITEM_SKU = "android.test.purchased";
	//static final String ITEM_SKU = "com.example.buttonclick";
	
	private Button clickButton;
	private Button buyButton;
	
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_in_app_billing);
		buyButton = (Button)findViewById(R.id.buyButton);
		clickButton = (Button)findViewById(R.id.clickButton);	
		clickButton.setEnabled(false);
		
		String base64EncodedPublicKey = "<your license key here>";
        
    	mHelper = new IabHelper(this, base64EncodedPublicKey);
    
    	mHelper.startSetup(new 
		IabHelper.OnIabSetupFinishedListener() {
    	   	  public void onIabSetupFinished(IabResult result) 
		  {
    	        if (!result.isSuccess()) {
    	           Log.d(TAG, "In-app Billing setup failed: " + 
				result);
    	      } else {             
    	      	    Log.d(TAG, "In-app Billing is set up OK");
    	      	    mHelper.enableDebugLogging(true, TAG);
	      }
    	   }
    	});
	}

	public void buyClick(View view) {
	     mHelper.launchPurchaseFlow(this, ITEM_SKU, 10001,   
	    		 mPurchaseFinishedListener, "mypurchasetoken");
}

	
	IabHelper.OnIabPurchaseFinishedListener mPurchaseFinishedListener 
	= new IabHelper.OnIabPurchaseFinishedListener() {
	public void onIabPurchaseFinished(IabResult result, 
                    Purchase purchase) 
	{
	   if (result.isFailure()) {
	      // Handle error
	      return;
	 }      
	 else if (purchase.getSku().equals(ITEM_SKU)) {
	     consumeItem();
	    buyButton.setEnabled(false);
	}
	      
   }
};

	public void consumeItem() {
		mHelper.queryInventoryAsync(mReceivedInventoryListener);
	}
	
	IabHelper.QueryInventoryFinishedListener mReceivedInventoryListener 
		= new IabHelper.QueryInventoryFinishedListener() {
			public void onQueryInventoryFinished(IabResult result,
							Inventory inventory) {
		   		   
				if (result.isFailure()) {
					Log.d(TAG, "In onQueryInventoryFinished Failed");
				} else {
					Log.d(TAG, "In onQueryInventoryFinished, calling consumeAsync");
					mHelper.consumeAsync(inventory.getPurchase(ITEM_SKU), 
							mConsumeFinishedListener);
				}
			}
	};
	
	IabHelper.OnConsumeFinishedListener mConsumeFinishedListener =
			new IabHelper.OnConsumeFinishedListener() {
 
	public void onConsumeFinished(Purchase purchase, 
       IabResult result) {

		if (result.isSuccess()) {		    	 
			clickButton.setEnabled(true);
		} else {
			// handle error
		}
	  }
	};

	@Override
	public void onDestroy() {
		super.onDestroy();
		if (mHelper != null) mHelper.dispose();
			mHelper = null;
	}


	@Override
	protected void onActivityResult(int requestCode, int resultCode, 
	     Intent data) 
	{
	      if (!mHelper.handleActivityResult(requestCode, 
	              resultCode, data)) {     
	    	super.onActivityResult(requestCode, resultCode, data);
	      }
	}

	
	public void buttonClicked (View view)
	{
		clickButton.setEnabled(false);
		buyButton.setEnabled(true);
	}

	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.in_app_billing, menu);
		return true;
	}

}
