<?
class clock {
	var $img, $center, $legend;
    
    function clock(){
		// get hour
		$cali = localtime(); 
		$hour = $cali[2];
		$minute=date('i');
	
		// prepare image
		$this->img = imagecreate(81, 100);
        $white = imagecolorallocate($this->img, 255, 255, 255);
        $black = imagecolorallocate($this->img, 0, 0, 0);
		
		// draw clock's face
		$this->center=40;
        $long=33;
		imagearc($this->img, $this->center, $this->center, 80, 80, 0, 360, $black);
        $cont=0;
        while ($cont<60)
        {
            $mark=$cont;
            $degrees=($mark*6)-90;
            $y=$long*sin(deg2rad($degrees));
            $x=$long*cos(deg2rad($degrees));
        	imagearc($this->img, $this->center+$x, $this->center+$y, 3, 3, 0, 360, $black);
        	$cont=$cont+15;
        }
		
		// draw from 0 to 11 hours
		if ($hour==12){$hour=0;}
		
		// move clock's hands
		$this->moveMinute($minute);
		$this->moveHour($hour, $minute);
    }
	
	function moveHour($hour, $minute){
        $red = imagecolorallocate($this->img, 255, 0, 0);
        $long=20;
        $move=$hour+($minute/60);
        $degrees=($move*30)-90;
        $y=$long*sin(deg2rad($degrees));
        $x=$long*cos(deg2rad($degrees));
        imageline ($this->img, $this->center, $this->center, $this->center+$x, $this->center+$y, $red);
	}
	
	function moveMinute($minute){
        $black = imagecolorallocate($this->img, 0, 0, 0);
        $long=35;
        $degrees=($minute*6)-90;
        $y=$long*sin(deg2rad($degrees));
        $x=$long*cos(deg2rad($degrees));
        imageline ($this->img, $this->center, $this->center, $this->center+$x, $this->center+$y, $black);
	}
	
	function setLegend($legend){
        $black = imagecolorallocate($this->img, 0, 0, 0);
        imagerectangle($this->img, 1, 85, 79, 99, $black);
        imagestring($this->img, 3, $this->center+1-strlen($legend)*7/2, 86, $legend, $black);
	}

	function plot(){
		header("Content-type: image/png");
		imagepng($this->img);
		imagedestroy($this->img);
	}
}

?>
